/****************************************************************************

    CLASS:    GGcrypt

    PURPOSE:  Taken from the WINCRYPT.EXE (VERSION 1.0) code by Jeff Prosise
              Converted the actual crypting code to a C++ class.

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

    WINCRPT COPYRIGHT NOTICE

WINCRYPT.EXE (VERSION 1.0)               Copyright (c) 1994, Jeff Prosise
-------------------------------------------------------------------------
                    First Published in PC Magazine July, 1994 (Utilities)
-------------------------------------------------------------------------

*******************************************************************************/

#include "gglib.h"

#define KEYSIZE   512
#define KEYSIDES  64

#ifndef _GGcrypt_
#define _GGcrypt_

class GGcrypt {

private:

//-------------------------------------------
  char npFileData[KEYSIZE];   /* Pointer to file I/O buffer */
  char npKey[KEYSIZE];        /* Pointer to encryption key */
  char npTmp[KEYSIZE];        /* Pointer to temporary buffer */
//-------------------------------------------
  void SetCell(char *npGrid, unsigned int nWidth, unsigned int i, unsigned int j, int bCellState);
//-------------------------------------------
  int GetCell(char *npGrid, unsigned int nWidth, unsigned int i, unsigned int j);
//-------------------------------------------
  void Mutate(char *npInputKey, char *npOutputKey, unsigned int nWidth, unsigned int nHeight);
//-------------------------------------------

public:
//-------------------------------------------
// Reinitialize to another password
//
  void ReInitialize(char *pPassword, int iPasswordLen);
//-------------------------------------------
// Setup with a password
//
  GGcrypt(char *pPassword, int iPasswordLen);
//-------------------------------------------
// Encrypt or Decrypt with current password.
// You can scan from 1 to CryptKeySize().
//
  int ScanBlock(char *pBuffer, int iKeySize);
//-------------------------------------------
// Size of Crypt Key
//
  int CryptKeySize(void);
//-------------------------------------------
};

#endif
