/****************************************************************************

    CLASS:    GGcharMem

    PURPOSE:  For allocating a 'char' array.

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGcharMem_
#define _GGcharMem_

#define P_CHAR(A, B) (*##A)[B]

class GGcharMem : public GGmemory {

private:

  GGcharMem *pTmpCharMem;
  char ucNul;

//-----------------------------------
public:
//-----------------------------------
  char &operator[](int iIndex);
//-----------------------------------
  int SizeOf(void);
//-----------------------------------
  GGcharMem(void);
//-----------------------------------
  ~GGcharMem(void);
//-----------------------------------
  int Insert(int iStartPos, int iNumItems = 1);
//-----------------------------------
  int Delete(int iStartPos, int iNumItems = 1);
//-----------------------------------
  GGcharMem &operator<<(GGcharMem &sMemFrom);
//-----------------------------------
};

#endif
