/****************************************************************************

    CLASS:    GGunicode

    PURPOSE:  A UNICODE class. Right now, do all string malipulation in a
              GGstring class, then assign the GGstring class to this class.
              Works great in the Windows CE enviorment.

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version
              GBG. 07/21/1998 Added an assigment of 'unsigned short *', which
              is a UNICODE string

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

// NOTE:
// GGuniCode adds a terminating NULL aka Double NULL
// to the end of it's string when getting a GGstring.
// This is for when you pass GGuniCode.pMemory to those
// Win32 functions that expect a UNICODE string. Remember
// that UNICODE strings end with a NULL terminator.
// If you assign or append a GGuniCode to a GGstring and
// don't want the NULLs within the GGstring, just
// GGstring.RemoveChar(0) to remove all unwanted NULLs.
// Or...
// Simply do the following before assigning or appending
// to a GGstring:
//
// GGuniCode.ReDimArray(GGuniCode.Len())
//
// If you want to do compare, find, delete ...
// Assign a GGunicode to a GGstring, do your compare, find,
// delete ..., then assign back to a GGunicode once your
// done.
//
#ifndef _GGuniCode_
#define _GGuniCode_

#define _TC(A) ((TCHAR *)##A.pMemory)

class GGstring;

class GGuniCode : public GGshortMem {

private:

//-----------------------------------
public:
//-----------------------------------
  GGuniCode &operator=(char *pString);
//-----------------------------------
  GGuniCode &operator=(GGuniCode &sUniCode);
//-----------------------------------
  GGuniCode &operator=(GGstring &sString);
//-----------------------------------
  GGuniCode &operator=(unsigned short *pUniCode);
//-----------------------------------
  int FindNull(void);
//-----------------------------------
  int Len(void);
//-----------------------------------
};

#endif
