/****************************************************************************

    CLASS:    GGtree

    PURPOSE:  A Btree class

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include"gglib.h"

#ifndef _GGtree_
#define _GGtree_

//-----------------------------------
typedef struct gNode {          // Binary Tree item definition
  GGstring key;                 // Key for this item
  GGcharMem sData;              // Data for this item
  int iDeleted;                 // If this item is deleted
  struct gNode *pLeft,*pRight;  // pointers to subtrees
  struct gNode *pParent;        // pointer to parent

#ifdef _DEBUG
  char cData[1024];
  char cKey[1024];
#endif

} Tree;
//-----------------------------------

class GGtree {
private:
  Tree *pBtree;
  GGstring sTmpString;
  int iTotalNodes;

  Tree *_insert(GGstring &key, Tree *pTree, Tree *pParent, GGcharMem &sInData);
//-----------------------------------
  Tree *_search(GGstring &key, Tree *pTree);
//-----------------------------------
  int _remove(GGstring &key, Tree *pTree);
//-----------------------------------
  int _delete(GGstring &key, Tree *pTree);
//-----------------------------------
  Tree *_clean(Tree *pTree);
//-----------------------------------
  void _addnodes(Tree *pTree, Tree *pParent);
//-----------------------------------

public:
//-----------------------------------
  GGtree(void);
//-----------------------------------
  ~GGtree(void);
//-----------------------------------

  int Insert(GGstring &key, GGcharMem &sInData);
//-----------------------------------
  int Insert(char *pKey, GGcharMem &sInData);

//-----------------------------------
  GGcharMem *Search(GGstring &key);
//-----------------------------------
  GGcharMem *Search(char *pKey);
//-----------------------------------

  int Remove(GGstring &key);
//-----------------------------------
  int Remove(char *pKey);
//-----------------------------------

  int Delete(GGstring &key);
//-----------------------------------
  int Delete(char *pKey);
//-----------------------------------

  int GetTotalNodes(void);
//-----------------------------------
};

#endif
