/****************************************************************************

    CLASS:    GGserverSocket and GGclientSocket

    PURPOSE:  Classes for implimenting a TCP Server program.

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGsocket_
#define _GGsocket_

#define _SOCKET_BUFFER_   (1024*2)
#define _INVALID_SOCKET_  (unsigned int)(-1)
#define _SSOCKET_START_   1
#define _SSOCKET_NOSTART_ 0

class GGclientSocket : public GGthread {

private:

#if defined(_SOLARIS_234_)
  int iSocketId;

#elif defined(_WIN32)
  SOCKET iSocketId;
#endif

//  char cBuffer[_SOCKET_BUFFER_];
//  char cUserName[128];
  struct sockaddr_in sClient;

//-----------------------------------
  int ProcessThread(void);

public:

  GGstring sUserName;
  GGstring sBuffer;

  virtual int ProcessSocket(void) = 0;
//-----------------------------------
  void SetSocket(int iSocket);
//-----------------------------------
  void Close(void);
//-----------------------------------
  GGclientSocket();
//-----------------------------------
  ~GGclientSocket();
//-----------------------------------
  int Read(void);
//-----------------------------------
  int Write(GGstring &sString);
//-----------------------------------
//  int Write(char *pData, int iLen);
//-----------------------------------
  GGstring &GetBuffer(void);
//-----------------------------------
  GGstring &GetUserName(void);
//-----------------------------------
};

class GGserverSocket {

private:
  struct sockaddr_in sClient;
  struct sockaddr_in sServer;
  struct sockaddr_in sStopClient;

#if defined(_SOLARIS_234_)
  int iHostSocket;

#elif defined(_WIN32)
  SOCKET iHostSocket;
#endif

  GGclientSocket *pClientSocket;
  int iErrStatus;
  int iShutDown;
  int iPortNumber;

public:
//-----------------------------------
  virtual GGclientSocket *CreateClient(void) = 0;
//-----------------------------------
  GGserverSocket();
//-----------------------------------
  ~GGserverSocket();
//-----------------------------------
  int SetupServer(int iPort, char *pHostName = NULL);
//-----------------------------------
  GGclientSocket *Accept(int iSSocketStart = _SSOCKET_START_);
//-----------------------------------
  int IsShutDown(void);
//-----------------------------------
  void ShutDown(void);
//-----------------------------------
};

#endif
