/****************************************************************************

    CLASS:    GGservice, GGclientService and GGmessageBoxT

    PURPOSE:  GGservice and GGclientService help in the creation of a
              Windows NT Service. By using these classes, you'll only have
              to work on the actual code for the service.
              You'll be notified of the start, pause, continue, stop, shutdown
              and the control code events.

              NOTE:
              1.) Developing a new debug GGservice base class, to help in
              the aid of debugging services.

              2.) Developing a new GGservice base class to work with UNIX daemon
              processes.

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version
              GBG. 07/26/1998 The following functions, Interrogate(), ShutDown(),
              Paused(), Continued() and UserDefinedControl() are not required
              for virtual overrides. Only SetupService() and CleanUpService()
              are required for virtual overrides.

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGservice_
#define _GGservice_

// 10 min
#define _LOGOUT_TIMEOUT_  (60000*10)

class GGmessageBoxT : public GGthread {
private:
  char cMessage[256];

//--------------------------
  int ProcessThread(void);

public:
  GGmessageBoxT(char *pMessage);
//--------------------------
};

// This is your client service class, this is
// where your service code goes.
//
class GGclientService {

private:
  GGmessageBoxT *pMsgBox;

public:
#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
  GGeventLog *pEventLog;
#endif

// Virtual functions. You should be overriding
// these functions
//-----------------------------------
// This function gets called when the user
// stops your service
  virtual void CleanUpService(void) = 0;
//-----------------------------------
// This function gets called when someone
// is querying your service. It's up to you, but
// you can response with the program querying
// or you can just return from this function.
  virtual void Interrogate(void);
//-----------------------------------
// This function gets called when the your
// NT Computer is beening shutdow. You'd think
// that it would stop your service, but it doesn't,
// so that's why we have this function.
  virtual void ShutDown(void);
//-----------------------------------
// If the user pauses your service, put
// your pause code here.
// NOTE: In the constructor class, if
// you want to override dwControlsAccepted and
// not accept 'SERVICE_ACCEPT_PAUSE_CONTINUE',
// you can do this.
  virtual BOOLEAN Paused(void);
//-----------------------------------
// If the user restarts from a pause, put
// your continue code here.
// NOTE: In the constructor class, if
// you want to override dwControlsAccepted and
// not accept 'SERVICE_ACCEPT_PAUSE_CONTINUE',
// you can do this
  virtual BOOLEAN Continued(void);
//-----------------------------------
// If you kept SERVICE_USER_DEFINED_CONTROL in the base contructor
// class for dwControlsAccepted, you'll be notified of all user
// defined controls. Return with your state on the user defined
// control.
//
  virtual DWORD UserDefinedControl(DWORD dwControl, DWORD dwCurrentState, DWORD &dwServiceSpecificExit, DWORD &dwChkPoint);
//-----------------------------------
// Put your initialization and thread starting
// code here
  virtual BOOLEAN SetupService(DWORD argc, LPTSTR *argv) = 0;
//-----------------------------------
// Standard member functions
  GGclientService(char *pName);
//-----------------------------------
  ~GGclientService();
//-----------------------------------
  void NotificationMessageT(char *pMessage);
//-----------------------------------
  void NotificationMessage(char *pMessage);
};

class GGservice {

private:
  GGmessageBoxT *pMsgBox;

#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
  GGeventLog *pCopyRight;
#endif
  GGclientService *pClientService;

#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
  SERVICE_STATUS_HANDLE hServiceHandle;
  SERVICE_TABLE_ENTRY serviceTable[2];
#endif
  HANDLE terminateEvent;
  char cServiceName[128];

  DWORD dwServiceSpecificExit, dwChkPoint;

  BOOLEAN bServiceStarted;
  int iLogoutWait;
  DWORD dwControlsToAccepted;
  BOOLEAN bCanStart;
  BOOLEAN bShutDown;
  DWORD dwCurrState;
//-----------------------------------
  BOOLEAN CallSCM(DWORD dwCurrentState, DWORD dwWin32ExitCode, DWORD dwServiceSpecificExitCode, DWORD dwCheckPoint, DWORD dwWaitHint);
//-----------------------------------
  VOID Terminate(DWORD error);

public:

#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
  GGeventLog *pEventLog;
#endif
  static GGservice *pService;
//-----------------------------------
// Standard member functions
//-----------------------------------
// You never have to call the following two
// functions.
//
  VOID ServiceHandler(DWORD controlCode);
//-----------------------------------
  VOID ServiceMain(DWORD argc, LPTSTR *argv);
//-----------------------------------
// Send a Notification Message, even when your not
// logged into Windows NT.
// This one doesn't wait, cause it has been threaded
// out.
//
  void NotificationMessageT(char *pMessage);
//-----------------------------------
// Same as above, but will wait for a user to press
// the OK button on the message box.
//
  void NotificationMessage(char *pMessage);
//-----------------------------------
// Test to see if the System is beening shutdown.
//
  BOOLEAN IsShutDown(void);
//-----------------------------------
// Create your service with the following parameters:
//  1 - Service Name
//  2 - GGclientService class. This is where your service
//      code goes.
//  3 - Timeout waiting for sending messages to the system
//      on a response to your messages.
//  4 - Type of events you want to be altered about:
//      SERVICE_ACCEPT_STOP           User select to stop this service
//      SERVICE_ACCEPT_SHUTDOWN       Windows NT is beening shutdow
//      SERVICE_ACCEPT_PAUSE_CONTINUE User select either Pause or continue
//      SERVICE_USER_DEFINED_CONTROL  User Defined Controls
//
#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
  GGservice(char *pServiceName, GGclientService *pClientServ, int iTimeOutMilliSeconds = _LOGOUT_TIMEOUT_, DWORD dwControlsAccepted = (SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_SHUTDOWN | SERVICE_ACCEPT_PAUSE_CONTINUE));
#endif
//-----------------------------------
  ~GGservice();
//-----------------------------------
// After you've intialized everything, start you service
//
  BOOLEAN StartService(void);
//-----------------------------------

};

#endif                 
