/****************************************************************************

    CLASS:    GGeventLog

    PURPOSE:  A class to write out the the Windows NT Event Log

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGeventLog_
#define _GGeventLog_

class GGeventLog {
private:
  BOOLEAN bNoIni;
  char cExeName[128];
  char cIniName[128];
  char szMsg[256];
  HANDLE  hEventSource;
  LPTSTR  lpszStr[4];
  char cCheckIni[16];
  char cFormatBuffer[1024];
  va_list vMarker;
  int iStrings;
  DWORD dwRawDataSize;
  char cRawData[2048];

public:
//-----------------------------------
// For every entry you add to the event log, you can also
// include binary data as well. The maximum size that GGEventLog
// will include is 2048. The binary data will not be added until
// one of the Event Type functions are called.
//
// Ex:
//
// char cBuffer[2048];
//
// pEventLog->SetRawData(cBuffer, sizeof(cBuffer));
//
  int SetRawData(char *pRawData, int iRawSize);
//-----------------------------------
// Text to add to the event log. The text data will not be added until
// one of the Event Type functions are called.
//
// Ex: 
//
// pEventLog->SetBuffer("Hello World");
//
  void SetBuffer(char *pBuffer);
//-----------------------------------
// Text to add to the event log. This function acts like the printf()
// function, except you don't specify a buffer. The text data will not
// be added until one of the Event Type functions are called.
//
// Ex: 
//
// pEventLog->FormatBuffer("This is x = [%d]", x);
//
  void FormatBuffer(char *pFormat, ...);
// NOTE:
// You can call SetRawData() and either SetBuffer() or FormatBuffer(). If
// you call SetBuffer() and don't call one of the Event Type functions, then
// call FormatBuffer(), the data you passed in FormatBuffer() will overwrite
// what you passed in SetBuffer().
//
//-----------------------------------
// +--- EVENT TYPE FUNCTIONS
// |
// |  Once you call one of these functions, then if you specify a call to
// |  SetRawData() and one of the '*Buffer()' functions, your data will be
// |  saved to the Event Log.
// |
/* +-> */ void AuditFailure(WORD wCategory = 0, DWORD dwErr = 0, DWORD dwEventID = 0);
//-|---------------------------------
/* +-> */ void AuditSuccess(WORD wCategory = 0, DWORD dwErr = 0, DWORD dwEventID = 0);
//-|---------------------------------
/* +-> */ void InfoType(WORD wCategory = 0, DWORD dwErr = 0, DWORD dwEventID = 0);
//-|---------------------------------
/* +-> */ void WarningType(WORD wCategory = 0, DWORD dwErr = 0, DWORD dwEventID = 0);
//-|---------------------------------
/* +-> */ void ErrorType(WORD wCategory = 0, DWORD dwErr = 0, DWORD dwEventID = 0);
//-|---------------------------------
/* +-> */ void AddToEventLog(WORD wEventType, DWORD dwErr, WORD wCategory, DWORD dwEventID);
//-----------------------------------
// 
// 'pExeName' is the name displayed in the 'Source' column in the Event Log.
// If you specify a 'ini' file, the following entries will be look for in your
// specified 'ini' file:
//
// [params]
// displaywarnings=Y
// displayinfo=Y
//
// By changing 'Y' to any other character, no warnings or info types will be
// saved. All other events are logged.
//
  GGeventLog(char *pExeName, char *pIniName = NULL);
//-----------------------------------
};

#endif
