/****************************************************************************

    CLASS:    GGerror

    PURPOSE:  A class to get last known error

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGerror_
#define _GGerror_

class GGerror {

private:
  char cErrorBuffer[1024];

#if defined(_SOLARIS_234_)
  char *lpMsgBuf;

#elif defined(_WIN32)
  LPVOID lpMsgBuf;

#endif

public:
//--------------------------
  GGerror(void);
//--------------------------
// Get last error message in text format
//
  char *GetLastErrorMessage(void);
//--------------------------
// Get error message in text format based on the number
// passed to this function.
//
  char *GetErrorText(unsigned long ulMessageId);
//--------------------------

};

#endif
