/****************************************************************************

    CLASS:    GGthread

    PURPOSE:  A thread class. Any code that you want to run in a thread, do the
              following:

              1) Inhierit from this class
              2) Include a ProcessThread() function for the base virtual
                 function.
              3) Declare as a pointer to allocated from a 'new'. Never
                 declare as a non-pointer type. This has to do with the
                 ending of the thread.
              4) Once allocated, call the Start() method, and your code is
                 ready to run.

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGthread_
#define _GGthread_

#ifndef _THREAD_STACK_
#define _THREAD_STACK_      (1024*10)
#endif

class GGthread {

private:

  int iStart;
  int iThreadStarted;
  int iKilled;

public:
#if defined(_SOLARIS_234_)
  thread_t tid;

#elif defined(_WIN32)
  DWORD tid;
  HANDLE hCurrentThread;

#endif

//--------------------------
// The code you want to get processed
// in this thread gets put in this function
// in your inheirited class.
// NOTE:
// If you return a non-zero value, your class
// will be deleted as well as stopped, if you
// created GGthread as a pointer.
//
// If you don't declare GGthread as a pointer,
// always return from ProcessThread() with a
// zero.
//
  virtual int ProcessThread(void) = 0;
//--------------------------
  ~GGthread(void);
//--------------------------
  GGthread(void);
//--------------------------
// Is this thread stopped. Could be that it was
// never started.
// Returns non-zero if stopped.
//
  int IsStopped(void);
//--------------------------
// Stop this thread.
// Returns zero if successful
//
  int Stop(void);
//--------------------------
// Has this thread been killed?
// If it has, this class will not go away
// if you 'new'd it. You must 'delete' it,
// if it's a pointer.
// Once a thread has been killed, you can
// never start it again. If you want to
// restart a thread:
// Stop() then Start() it
// Stop() then Start() it
// Stop() then Start() it
// Get the picture....
//
// Returns non-zero if killed.
//
  int IsKilled(void);
//--------------------------
// This kills the thread but doesn't get rid
// of the class it you 'new'd it. You've got
// to 'delete' it to get rid of it, if it's
// a pointer.
// Returns zero if successful
//
  int Kill(void);
//--------------------------
// Start a thread, and re-start it if you used
// Stop().
// I'll say it again, if you killed it, you can't
// restart it.
// Returns zero if successful
//
  int Start(void);
//--------------------------
// Sleep this thread for so many seconds
//
  void Sleep(int iSeconds);
};

#endif
