/****************************************************************************

    CLASS:    GGlock

    PURPOSE:  A class for a program lock

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version
              GBG. 07/22/1998 Took out the 'inline' from IsReady() in the
              source 'cpp' file.

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGlock_
#define _GGlock_

class GGlock {

private:
  char cName[128];

#if defined(_SOLARIS_234_)
  mutex_t sMutex;
  int hLock;

#elif defined(_WIN32)
  HANDLE hLock;

#endif

  int iLocked;

public:
//--------------------------
// Give the lock a name
//
  GGlock(char *pName);
//--------------------------
  ~GGlock();
//--------------------------
// Lock it
//
  int Lock(void);
//--------------------------
// Unlock it
//
  void UnLock(void);
//--------------------------
// Has the lock been setup
//
  int IsReady(void);
//--------------------------
};

#endif
