/****************************************************************************

    HEADER:   gglib.h

    PURPOSE:  Main Header file for gglib library

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

    PLATFORMS:  Except where noted with the #ifxxx statements and operating
                specific classes, all class work on the following operating
                systems:

                Windows NT
                Windwos CE
                SunOS
      
                With more access to different machines and operating systems,
                this library can be ported to other operating systems.

*******************************************************************************/

// If _WIN32 is not defined, I'm assuming your on a Solaris
// box.
// NOTE: This will change once I start porting to other operating
// systems.

#ifndef _GGlib_
#define _GGlib_

#ifndef _WIN32

#ifndef _WIN32_WCE

#ifndef _WIN32_WCE_EMULATION
#define _SOLARIS_234_
#endif

#endif

#endif

#if defined(_SOLARIS_234_)

#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <iostream.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/filio.h>
#include <sys/conf.h>
#include <sys/varargs.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stropts.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <synch.h>

#define _REENTRANT
#include<thread.h>
#include<unistd.h>
#include<errno.h>

#elif defined(_WIN32) || defined(_WIN32_WCE) || defined(_WIN32_WCE_EMULATION)

#if defined(_WIN32) && (!defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION))
#include <winsock2.h>

#elif defined(_WIN32_WCE) || defined(_WIN32_WCE_EMULATION)
#include <windows.h>
#include <winsock.h>

#endif

#include <windows.h>
#include <windowsx.h>
#include <winbase.h>
#include <memory.h>
#include <tchar.h>

#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
#include <stdio.h>
#endif

#include <string.h>

#if defined(_WIN32) && (!defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION))
#include <signal.h>
#include <iostream.h>
#endif

#endif

#define CATCHALL_FUNC(A, B, C)  try{A;} catch(...){##C(B, #A);}
#define CATCHALL_LOCAL(A, B)    try{A;} catch(...){B}
#define KILL_THREAD       1
#define DONT_KILL_THREAD  0

#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
#include "ggerror.h"

#if defined(_WIN32)
#include "ggeventlog.h"
#endif

#endif

#include "ggcrypt.h"

#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
#include "gglock.h"
#endif

#if defined(_WIN32) && (!defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION))
#include "gglinklist.h"
#endif

#include "ggmemory.h"
#include "ggcharmem.h"
#include "ggintmem.h"
#include "gglongmem.h"
#include "ggshortmem.h"
#include "ggfloatmem.h"
#include "ggunicode.h"
#include "ggstring.h"
#include "ggvoidp.h"

#include "ggfile.h"
#include "ggchar2d.h"

#include "ggthread.h"
#include "ggtimer.h"

#include "ggtree.h"
#include "ggbtree.h"

#if defined(_WIN32) && (!defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION))
#include "ggservice.h"
#endif

#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
#include "ggsignal.h"
#include "ggsocket.h"
#endif

#endif
