/****************************************************************************

    CLASS:    GGbtree

    PURPOSE:  A Btree class with no reference to GG classes

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include"gglib.h"

#ifndef _GGbtree_
#define _GGbtree_

//-----------------------------------
typedef struct bNode {          // Binary Tree item definition
  char *pKey;                   // Key for this item
  void *pData;                  // Data for this item
  int iDeleted;                 // If this item is deleted
  struct bNode *pLeft,*pRight;  // pointers to subtrees
  struct bNode *pParent;        // pointer parent

} BTree;
//-----------------------------------

class GGbtree {
private:
  BTree *pBtree;
  int iTotalNodes;

//-----------------------------------
  BTree *_insert(char *pKey, BTree *pTree, BTree *pParent, void *pData);
//-----------------------------------
  BTree *_search(char *pKey, BTree *pTree);
//-----------------------------------
  int _remove(char *pKey, BTree *pTree);
//-----------------------------------
  int _delete(char *pKey, BTree *pTree);
//-----------------------------------
  BTree *_clean(BTree *pTree);
//-----------------------------------
  void _addnodes(BTree *pTree, BTree *pParent);
//-----------------------------------

public:
//-----------------------------------
  GGbtree(void);
//-----------------------------------
  ~GGbtree(void);
//-----------------------------------

//-----------------------------------
  int Insert(char *pKey, void *pData);
//-----------------------------------
  void *Search(char *pKey);
//-----------------------------------
  int Remove(char *pKey);
//-----------------------------------
  int Delete(char *pKey);
//-----------------------------------
  int GetTotalNodes(void);
//-----------------------------------
};

#endif
