/****************************************************************************

    CLASS:    GGtimer

    PURPOSE:  A timer class inhierited from the GGthread class.
              This class will sleep for the amount of seconds specified
              in SetSeconds(), not less the 10 seconds. The the code
              you place in your inhierited class in the function ProcessTimer()
              will be executed after the timer wakes up.

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGtimer_
#define _GGtimer_

class GGtimer : public GGthread {
private:
  int iTimerSecs;
  int iProcessCode;
//-----------------------------------
  int ProcessThread(void);
//-----------------------------------
public:
//-----------------------------------
  GGtimer();
//-----------------------------------
// Gets the number of seconds you set in
// SetSeconds().
//
  int GetSeconds(void);
//-----------------------------------
// Sets the number of seconds, before this
// timer wakes up and calls ProcessTimer().
// Returns zero if successful.
//
  int SetSeconds(int iSeconds);
//-----------------------------------
// Start this timer.
// Returns zero if successful.
//
  int Start(void);
//-----------------------------------
// 'Start' will start the timer, but setting
// 'iStatus' to a non-zero value will tell
// 'ProcessThread' to execute 'ProcessTimer'.
//
  void ProcessCode(int iStatus);
//-----------------------------------
  virtual int ProcessTimer(void) = 0;
//-----------------------------------
  virtual int KillTimer(void) = 0;
//-----------------------------------
};

#endif
