/****************************************************************************

    CLASS:    GGpageMem

    PURPOSE:  The original GGmemory base class. It's allocation was to slow
              for many basic needs. Keeping around in case it can be used for
              disk paging instead of memory paging.

              This would be a perfect example of why you'd want to use base
              classes. Just by replacing this base class with a new GGmemory
              base class, all inhierited class worked alot better.

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGpageMem_
#define _GGpageMem_

class GGpageMem {

private:

  GGpageMem *pTmpMem;
  int iPageArraySize;
  int iTotalSize;
  int iOffset;
  int iError;
  int iLastIndex;
  int iLastMemoryPageCached;
  char *pLinkPage;
#if !defined(_WIN32_WCE) && !defined(_WIN32_WCE_EMULATION)
  GGlinkList *pLinkList;
#endif
  int iPage;
  int iLenYou, iLenMe;
  int iYou, iMe, iNextYou, iNextMe;
  char *pYou, *pMe;
  unsigned char ucGarbage;

public:

//-----------------------------------
  virtual int SizeOf(void) = 0;
//-----------------------------------
  GGpageMem &operator=(GGpageMem &sMemory);
//-----------------------------------
  int GetArraySize(void);
//-----------------------------------
  int IsDimmed(void);
//-----------------------------------
  int ReDimArray(int iNewSize);
//-----------------------------------
  void MemSet(char cChar = 0);
//-----------------------------------
  unsigned LastIndex(void);
//-----------------------------------
  int IsOutOfBounds(void);
//-----------------------------------
  int CalcPage(int iIndex);
//-----------------------------------
  void *GetPage(int iIndex);
//-----------------------------------
  int GetOffset(int iIndex);
//-----------------------------------
  ~GGpageMem();
//-----------------------------------
  GGpageMem(int iPageSize = 0);
//-----------------------------------
  int GetByteCount(void);
//-----------------------------------
  int GetPageArrayCount(void);
//-----------------------------------
  GGpageMem &Self(void);
//-----------------------------------
};

#endif
