/****************************************************************************

    CLASS:    GGfile

    PURPOSE:  A class to work with disk files

    AUTHOR:   Gabe Garza

    CHANGES:  GBG. 07/20/1998 Initial release version
              GBG. 07/22/1998 Added lType to SetFilePosition().
              GBG. 07/23/1998 Added Stat() function. Stat() returns
              if this is a file or a directory.
              GBG. 07/26/1998 Fixed a bug in GetTempFile() when working with
              _WIN32, but not the CE.

    NOTICE:   These class were written to help in the development of tools
              needed for work and home use.
              These classes were written, tested and debugged at home with
              cross-platform porting, tested and debugged at work.
              You may use freely this class to help in the development of
              tools or programs for home or work use.

*******************************************************************************/

#include "gglib.h"

#ifndef _GGfile_
#define _GGfile_

#define _FILE_BUFFER_ 1024

#define _FILE_POS_ERROR_  (0xFFFFFFFF)

// Header file for class GGfile

#if defined(_SOLARIS_234_)

#define GENERIC_READ          0x1
#define GENERIC_WRITE         0x2
#define FILE_SHARE_READ       0x1
#define FILE_SHARE_WRITE      0x2
#define INVALID_HANDLE_VALUE  (-1)

#endif

#define _F_BEGIN_   1
#define _F_CURRENT_ 2
#define _F_END_     3

class GGfile {

private:
  GGstring sTmpString;
  GGstring sTmpString2;
  GGuniCode sTmpUniCode;
  GGuniCode sTmpUniCode2;

  char cFileBuffer[_FILE_BUFFER_];

  char cFileName[128];
  char cPath[1024];
  char cTempBuffer[2048];
  char cCheckPath[2048];

  int iFileName;
  int iPath;
  int iShare;
  int iLastBytesRead;
  int iNumBytesToWrite;
  GGstring cTmpGGstring;

#if defined(_SOLARIS_234_)
  int hFile;
  char wcTmpPath[256];
  char wcFileName[128];

#elif defined(_WIN32)
  HANDLE hFile;
  TCHAR wcTmpPath[256];
  TCHAR wcFileName[128];

#endif

  unsigned char ucGarbage;
  int iLastIndex;
//-----------------------------------
  int CheckCreatePath(char *pFileName);
//-----------------------------------

public:
//-----------------------------------
// The following three functions work together,
// but will soon be deleted pending a new
// C++ class that will be doing the same
// thing and more...
//
//  unsigned char &operator[](int iIndex);
//-----------------------------------
//  int IsOutOfBounds(void);
//-----------------------------------
//  unsigned int LastIndex(void);
//-----------------------------------
// Fill in the internal GGfile buffer from a
// GGstring and return number of bytes not
// written from the GGstring. After using this
// operator overload, call Write() to write the
// data to the file.
//
// GBG. 06/30/1998 Changed the way this overload
// works. When you assign a GGstring to GGfile,
// the GGstring will be written immediately to
// the file. The number of bytes or error will
// be returned.
//
  int operator=(GGstring &sString);
//-----------------------------------
// Number of bytes last read
//
  int LastBytesRead(void);
//-----------------------------------
// Flush what the operating system is caching
//
  void Flush(void);
//-----------------------------------
// Returns non-zero if this file is opened
//
  int IsOpened(void);
//-----------------------------------
// All creates return the same values:
//
//  4 - Could not create file or sub-directories
//  3 - File is already opened, close first
//  2 - No filename was specified
//  1 - Error creating file, possibly open by someone
//      else.
//  0 - No Error
//
// For a detail text message, create a GGerror class
// and call GetLastErrorMessage().
//
//
// Create with no share.
//
  int Create(unsigned long dwShare = 0);
//-----------------------------------
// Create with share in write
//
  int CreateSW(void);
//-----------------------------------
// Create with share in read/write
//
  int CreateSRW(void);
//-----------------------------------
// Clear the internal buffer for this GGfile
// class.
//
  void ClearBuffer(void);
//-----------------------------------
// All Writes and Read return the same values.
//
//  -1  - Error writing out to the file
//
// If successful, the number of bytes written
// in Write() or number of bytes read in Read(),
// will be returned.
//  
// Write to the file from the internal buffer
// 'iBytesToWrite'.
//
  int Write(int iBytesToWrite = _FILE_BUFFER_);
//-----------------------------------
// Write this NULL terminate string to the
// file.
//
  int Write(char *pBuffer);
//-----------------------------------
// Write out the data in the GGstring class
// to the file
//
// GBG 06/30/1998. Took out this function. See
// the '=' operator overload from above.
//
//  int Write(GGstring &sString);
//-----------------------------------
// Write from 'pBuffer', 'iBytesToWrite'.
// You must specify number of bytes to write.
//
  int Write(void *pBuffer, int iBytesToWrite);
//-----------------------------------
// Number of bytes to read into the internal
// buffer.
//
  int Read(int iBytesToRead = _FILE_BUFFER_);
//-----------------------------------
// Number of bytes to read into pBuffer. This
// is a external buffer supplied by the user.
//
  int Read(void *pBuffer, int iBytesToRead);
//-----------------------------------
// Setup a filename for this GGfile class.
// Nothing happens until you Open or Create this
// file. 
//
  GGfile(char *pFileName = NULL);
//-----------------------------------
// Close the file.
//
  void Close(void);
//-----------------------------------
  int IsExist(void);
//-----------------------------------
// All Opens return the same values:
//
//  3 - File is already opened, close first
//  2 - No filename was specified
//  1 - Error opening file, possibly open by someone
//      else.
//  0 - No Error
//
// For a detail text message, create a GGerror class
// and call GetLastErrorMessage().
//
// Avoid using this function, use one
// of the below OpenXX() functions.
//
  int Open(unsigned long dwMode, unsigned long dwShare = 0);
//-----------------------------------
// Open with read/write, no share
//
  int OpenRW(void);
//-----------------------------------
// Open with read/write, with read/write share
//
  int OpenRWsRW(void);
//-----------------------------------
// Open with write, no share
//
  int OpenW(void);
//-----------------------------------
// Open with write and share
//
  int OpenWs(void);
//-----------------------------------
// Open with read, no share
//
  int OpenR(void);
//-----------------------------------
// Open with read and share
//
  int OpenRs(void);
//-----------------------------------
// The next two functions are gone
// Don't use them
  char *GetPath(void);
//-----------------------------------
// Look above.
  char *GetFileName(void);
//-----------------------------------
// This function retrieves the full
// filename, or NULL if none was specified.
//
  char *GetFullFileName(void);
//-----------------------------------
// This function will soon be deleted pending
// a new C++ class that will be doing the same
// thing and more...
//
  void *GetBuffer(void);
// and here it is...
// NOTE: GetBuffer() now returns NULL. Use
// GetData() to get the data that was read in.
//
  GGstring &GetData(void);
  int GetBufferSize(void);
//-----------------------------------
// Get the file size length
//
  unsigned long GetFileSize(void);
//-----------------------------------
// If you want to create a temporary file,
// in the GGfile() constructor, don't specify
// a filename and just call this function.
// To get the full filename, call GetFullFileName().
//
  int GetTempFile(void);
//-----------------------------------
// All the file position functions return
// the same values.
//
//  _FILE_POS_ERROR_  - Error setting or getting
//                      file position pointer.
//
//  If successful, the current file position pointer.
//
// Get the current file postion pointer location
//
  unsigned long GetFilePosition(void);
//-----------------------------------
// Set the file position pointer based on the value
// you pass to it.
// NOTE:
// If you specify a huge number, on your next Write(),
// your file will increase by that huge number.
//
// You can now specify the follow:
//  _F_BEGIN_
//  _F_CURRENT_
//  _F_END_
//
  unsigned long SetFilePosition(unsigned long iPos, unsigned long lType = _F_BEGIN_);
//-----------------------------------
// Set your file position pointer to the beginning of
// the file.
//
  unsigned long GotoBegin(void);
//-----------------------------------
// Set your file position pointer to the end of the
// file.
//
  unsigned long GotoEnd(void);
//-----------------------------------
// Delete this file
//
  void Delete(void);
//-----------------------------------
// See if this is a file or directory
// Return values are:
// 1  - file
// 2  - directory
// -1 - Error
//
  int Stat(void);
//-----------------------------------
  ~GGfile();
//-----------------------------------
};

#endif
