/**************************************************************************
   MODULE      :  SqlWin.cpp
   Version     :  2.0
   Description :  This is the main code.  It contains the On<Menu> calls
                  as well as all related support function.
**************************************************************************/

#include "stdafx.h"
#include "SqlWin.h" 
#include "logonsql.h"
#include "Cdblib.h"

#ifdef _DEBUG
   #undef THIS_FILE
   static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

static UINT BASED_CODE indicators[] =
{
   ID_SEPARATOR,        // status line indicator
   ID_INDICATOR_CAPS,
   ID_INDICATOR_NUM,
   ID_INDICATOR_SCRL
};


static UINT BASED_CODE buttons[] =
{
   ID_FILE_OPEN,
   ID_FILE_SAVE_AS,
   ID_APP_EXIT,
   ID_SEPARATOR,
   ID_HELP_ABOUT 
};                        

CMsgList::MESGADDTEXTPROC   CSqlWinDlg::lpAddMessage ;
CSqlWinDlg  *               CSqlWinDlg::m_SqlWinDlg;

/////////////////////////////////////////////////////////////////////////////
// Message Map -- CSqlWinDlg

BEGIN_MESSAGE_MAP(CSqlWinDlg, CDialogWinApp)
   //{{AFX_MSG_MAP(CSqlWinDlg)
   ON_COMMAND(ID_HELP_ABOUT, OnHelpAbout)
   ON_COMMAND(ID_SERVER_CONNECT, OnServerConnect)
   ON_COMMAND(ID_SERVER_DISCONNECT, OnServerDisconnect)
   ON_BN_CLICKED(IDC_BTN_EXECUTE, OnBtnExecute)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSqlWinDlg::CSqlWinDlg
// This is the constructor for the CSqlWinDlg class.  It creates a 
// modeless dialog.

CSqlWinDlg::CSqlWinDlg(CWinApp *pCWndApp, CWnd *pParent) : CDialogWinApp()
{
   ASSERT(pCWndApp != NULL);
   
   m_pCWndApp = pCWndApp;     // save a ptr to the CWinApp for general use
   
   //{{AFX_DATA_INIT(CSqlWinDlg)
   //}}AFX_DATA_INIT

   CDialogWinApp::Create(IDD
      , indicators, sizeof(indicators)/sizeof(UINT)
      , buttons, sizeof(buttons)/sizeof(UINT), IDR_MAIN
      , pParent);   
      
   m_SqlWinDlg  = this;
   lpAddMessage =   m_MsgList.AddText;
   
   Cdb.SetTextProc( AddMessage );
}
   
/////////////////////////////////////////////////////////////////////////////
// CSqlWinDlg::DoDataExchange

void CSqlWinDlg::DoDataExchange(CDataExchange *pDX)
{
   CDialogWinApp::DoDataExchange(pDX); // call baseclass
   //{{AFX_DATA_MAP(CSqlWinDlg)
   DDX_Control(pDX, IDC_WORLD, m_Worldbmp);
   DDX_Control(pDX, IDC_LIST_MESSAGES, m_MsgList);
   DDX_Control(pDX, IDC_EDIT_SQL, m_EdtSql);
   //}}AFX_DATA_MAP
}

/////////////////////////////////////////////////////////////////////////////
// CSqlWinDlg::OnInitDialog
// OnInitDialog initializes the dialog display.

BOOL CSqlWinDlg::OnInitDialog()
{
   CDialogWinApp::OnInitDialog();   // call baseclass
   
   // TODO: Add extra initialization here
   
   return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSqlWinDlg::OnOK()
{
   // TODO: Add extra validation here
   
   CDialogWinApp::OnOK();
}

void CSqlWinDlg::OnCancel()
{
   // TODO: Add extra cleanup here
   
   CDialogWinApp::OnCancel();
}
   
void  CSqlWinDlg::AddMessage(const CString &msg, int iMtype)
{
   //if( lpAddMessage )
   //    (*lpAddMessage)(msg, iMtype);
   
   if( m_SqlWinDlg )
       m_SqlWinDlg->m_MsgList.AddText(msg, iMtype);
       
}
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog

CAboutDlg::CAboutDlg(CWnd* pParent /*=NULL*/)
   : CDialog(CAboutDlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(CAboutDlg)
   //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CAboutDlg)
   DDX_Control(pDX, ID_PROGRAM_VERSION, m_cProgVersion);
   DDX_Control(pDX, ID_PROGRAM_NAME, m_cProgName);
   DDX_Control(pDX, ID_SYSTEM_RESOURCES, m_cSystemResources);
   DDX_Control(pDX, ID_SYSTEM_MEMORY2, m_cSystemMemory2);
   DDX_Control(pDX, ID_SYSTEM_MEMORY, m_cSystemMemory);
   DDX_Control(pDX, ID_PROGRAM_COPYRIGHT, m_cCopyRight);
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
   //{{AFX_MSG_MAP(CAboutDlg)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg message handlers

void CSqlWinDlg::OnHelpAbout()
{
   CAboutDlg   dlg;
   dlg.DoModal();
}

BOOL CAboutDlg::OnInitDialog()
{
   CDialog::OnInitDialog();
                    
   BOOL fImUsingWin30 = TRUE;
   
   DWORD dwVersion = ::GetVersion();
   
   if ( LOBYTE(LOWORD(dwVersion)) >= 3 && HIBYTE(LOWORD(dwVersion)) > 0 )
      fImUsingWin30 = FALSE;
      
   TRACE("Windows version %d.%d, %d\n", LOBYTE(LOWORD(dwVersion)), HIBYTE(LOWORD(dwVersion)), fImUsingWin30);
   
   m_cProgName.SetWindowText("<Your Application Description>");
   m_cCopyRight.SetWindowText("Copyright \251 <Your Company Name>");
   m_cProgVersion.SetWindowText("1.0.000");
      
   char  szTemp[40];

   DWORD dwTemp = ::GetFreeSpace(0);
   wsprintf(szTemp, "Memory: %lu KB Free", dwTemp/1024);
   m_cSystemMemory.SetWindowText((fImUsingWin30 ? "" : (LPSTR)szTemp));
   m_cSystemMemory2.SetWindowText((fImUsingWin30 ? (LPSTR)szTemp : ""));

   if (fImUsingWin30)
      SetDlgItemText(ID_SYSTEM_RESOURCES, "");
   else
   {
      UINT uiTemp = ::GetFreeSystemResources(GFSR_SYSTEMRESOURCES);
      wsprintf(szTemp, "System Resources: %2i %%", uiTemp);
      m_cSystemResources.SetWindowText(szTemp);
   }
   
   return TRUE;  // return TRUE  unless you set the focus to a control
}

HWND ghWnd;           /* global window handle for handlers    */

void CSqlWinDlg::OnServerConnect() 
{    
     ghWnd = GetSafeHwnd();
     SetErrWnd(  GetSafeHwnd() );
     
     Cdb.Init();
     
     CLogonSql   dlg;   
     
     CdbLib::EnumServers();
     
     int Response = dlg.DoModal();
     if( Response == IDCANCEL)
     {
         return ;
     } 
     
     if( Cdb.Logon(dlg.m_userid,dlg.m_password,dlg.m_server) )
         ;
}

void CSqlWinDlg::OnServerDisconnect() 
{
   Cdb.LogOff();
}

void CSqlWinDlg::OnBtnExecute() 
{
   Cdb.ExecuteSqlBuffer( m_EdtSql,  m_MsgList);
}
