///////////////////////////////////////////////////////////////////////////////////
//
// Copywrite      n/a
//
// Program:       dblibrary class
//
// Module:        Cdblib.h    
//
// Description:   This class encapsulates usage of the dblibrary API
//
//                
//                The author allows free use of this source for personal or
// commercial use, the user disavows the author of any responsibility in its use,
// and it is the users responsibility to determine its suitability. 
// If the user modifies or alters the code in any way, the orginal copyright
// must remain, the revision history must be maintained, and any such additions
// alterations will be emailed to the author at  zfred@ozemail.com.au 
// I ask this as this code is by no means complete, but was sufficient for my
// requirements at the time of writing, any enhancements contributed I would
// like to incorporate for public release
// 
//////////////////////////////////////////////////////////////////////////////////    
// Although this uses DBLIB for Microsoft Sql server, the DBLIB for Sybase is 
// similiar, Sybase also have a improved api CTLIB.
// Microsoft of course would have you think today that DBLIB does not exist,
// but it does, this source was used with dblib and SQL Server 6.5 You can find
// the necesary files in the Backoffice SDK cd, the files
// NTWDBLIB.LIB
// MSDBLIB3.DLL
// SQLDB.H
// SQLFRONT.H
/////////////////////////////////////////////////////////////////////////////////
//
// Why would you use DBLIB ?  Well its very fast, faster than ODBC,
// and there are also the bulk copy APIs 
// Of course its a bit harder to use, hence this C++ wrapper
/////////////////////////////////////////////////////////////////////////////////
//                
                
//                
//             
// REVISION HISTORY
// ----------------
// Version     Date     Author      Comments
// --------------------------------------------------------------------------------
//  1.1        3Apr97   FredZickar  Further Enhanced at westpac  
//  1.0        21Jan97  FredZickar  Initial Writing  
//             
////////////////////////////////////////////////////////////////////////////////////


#ifndef _dblibcls_H
#define _dblibcls_H

// Your application needs to define the following environment
//#define DBMSWIN   Windows 16 bit environment
//#define DBNTWIN32 Windows NT 32 bit

#include "stdafx.h"

#include <sqlfront.h>
#include <sqldb.h>


/* Forward declarations of the error handler and message handler functions.
*/

extern "C" AddMessage(const CString &msg, int iMtype);
typedef void (CALLBACK * MESGTEXTPROC)( const CString &msg, int iMtype);        
void  SetErrWnd( HWND hWnd);
//////////////////////////////////////////////////////////////////////////////// 
//
class CdbLib;
//  CException
//    class CdbLibException;    // abnormal return value
//
class CdbLibException : public CException
{
   DECLARE_DYNAMIC(CdbLibException)

// Attributes
public:
   RETCODE m_nRetCode;
   CString m_strError;

// Implementation (use CdbLibThrowException to create)
public:
   CdbLibException(RETCODE nRetCode = SUCCEED);

   void Empty();
   virtual ~CdbLibException();

#ifdef _DEBUG
   virtual void AssertValid() const;
   void TraceErrorMessage(LPCTSTR szTrace) const;
#endif // _DEBUG
};

void AFXAPI CdbLibThrowException(RETCODE nRetCode, CdbLib* pdb, CString ErrMsg);
////////////////////////////////////////////////////////////////////////////////
 
////////////////////////////////////////////////////////////////////////////////
// dblibcls
////////////////////////////////////////////////////////////////////////////////    

class CdbLib : public CObject
{ 
  public:      
  
  CdbLib();
  virtual ~CdbLib();
  
  void   SetTextProc(MESGTEXTPROC lpfunc ) { m_lptextproc = lpfunc; };         
  static int  CdbLib::EnumServers();
  protected:
  
  static MESGTEXTPROC  m_lptextproc;
  static int           m_Instance;
  
  private:
  static int           m_LoggedIn;
  
  protected:
  
  static PLOGINREC  m_STATIC_login; 
  static CString    m_STATIC_userid;
  static CString    m_STATIC_password;
  static CString    m_STATIC_server;
  static BOOL       m_STATIC_InitFlag;
  static short      m_STATIC_CountLogins;
  BOOL   m_shared;
  PLOGINREC  m_login;
  
  public:     
  CString    m_userid;
  CString    m_password;
  CString    m_server;   
  PLOGINREC  GetLogin() const { return m_login;};
 
  PDBPROCESS m_dbproc; 
  static
  CStringList m_serverlist;
  
  static int dbwinErrorHandler(PDBPROCESS dbproc, INT severity, INT errno, INT oserr, LPCSTR dberrstr, LPCSTR oserrstr);
  static int dbwinMessageHandler(PDBPROCESS, DBINT, INT, INT, LPCSTR, LPCSTR, LPCSTR, DBUSMALLINT);

  static FARPROC lpdbwinMessageHandler; /* pointer to message handler        */
  static FARPROC lpdbwinErrorHandler;   /* pointer to error handler       */
 protected:        
  FARPROC lpdbProcesswinMessageHandler;// pointer to DBPROCESS message handler
  FARPROC lpdbProcesswinErrorHandler;  // pointer to DBPROCESS error handler 
  RETCODE result_code;
 private:
   
  public:
  void   Init();  
  void   SetMsgHandlerProc(DBMSGHANDLE_PROC);
  void   SetErrHandlerProc(DBERRHANDLE_PROC); 
  void   SetDBPROCMsgHandlerProc(DBMSGHANDLE_PROC);
  void   SetDBPROCErrHandlerProc(DBERRHANDLE_PROC); 
   
  BOOL   Logon(LPCSTR userid, LPCSTR password, LPCSTR server);
  inline const  BOOL  LoggedIn() { return m_LoggedIn; } ;
  virtual void   LogOff(); 
  
  BOOL   Dbopen(LPCSTR dbtouse=NULL);
  virtual void Dbclose(); 
  virtual void Cancel();
  int    ExecuteSql(const CWnd &MsgWnd);
  int    ExecuteSqlBuffer(CEdit & m_sqledit, const CWnd &MsgWnd);

// encapsulated dblibrary api  
  public:
  inline BOOL    dbdead ()       { return ::dbdead (m_dbproc);};
  inline RETCODE dbuse (LPCSTR s){ return ::dbuse (m_dbproc, s);  };
  inline RETCODE dbcmd(LPCSTR s) { return ::dbcmd (m_dbproc, s);  };
  inline RETCODE SQLAPI dbfcmd (LPCSTR s, ...)  { return ::dbfcmd (m_dbproc, s); };
  inline RETCODE dbcancel()      { return ::dbcancel(m_dbproc);   };
  inline STATUS  dbnextrow()     { return ::dbnextrow (m_dbproc); };
  inline RETCODE dbcanquery()    { return ::dbcanquery(m_dbproc); };
  inline RETCODE dbsettime(INT i){ return ::dbsettime (i);        };
  inline RETCODE dbsetlogintime (INT i) { return ::dbsetlogintime (i);};
  //inline RETCODE dbsqlexec()      { return ::dbsqlexec (m_dbproc );};
  RETCODE dbsqlexec();
  inline RETCODE dbsqlok()       { return ::dbsqlok (m_dbproc );  }; 
  inline RETCODE dbsqlsend()     { return ::dbsqlsend (m_dbproc); };
  inline RETCODE dbresults ()    { return (result_code = ::dbresults (m_dbproc)); };
  inline LPCBYTE dbdata (INT i)  { return ::dbdata (m_dbproc, i); };
  inline BOOL    dbdataready ()  { return ::dbdataready (m_dbproc); };
  inline RETCODE dbdatecrack (LPDBDATEREC drec, LPCDBDATETIME dt)
                                 { return ::dbdatecrack (m_dbproc, drec, dt); };
  inline RETCODE dbbind(INT i, INT j, DBINT k , LPBYTE l)
                                 { return ::dbbind (m_dbproc, i, j, k, l); };
  inline RETCODE dbcolinfo (INT i, INT j, INT k, LPDBCOL d)
                                 { return ::dbcolinfo (m_dbproc, i,j,k,d);};
  inline LPCSTR  dbcolname(INT i){ return ::dbcolname (m_dbproc, i); };
  inline INT     dbcoltype(INT i){ return ::dbcoltype (m_dbproc, i); };
  inline DBINT   dbcollen (INT i){ return ::dbcollen (m_dbproc, i);};
  inline DBINT   dbcolutype(INT i){ return ::dbcolutype (m_dbproc, i);};
  inline INT     dbconvert (INT i, LPCBYTE pbyte1, DBINT j, INT k, LPBYTE pbyte2, DBINT l)
                                 { return ::dbconvert (m_dbproc, i, pbyte1, j, k, pbyte2, l);};
  inline INT     dbnumcols ()    {  return ::dbnumcols (m_dbproc);};
  inline RETCODE dbnullbind (INT i, LPCDBINT ip) { return ::dbnullbind (m_dbproc, i, ip);};
  
  
};                         
// end of CdbLib
//////////////////////////////////////////////////////////////////////////////////////





//////////////////////////////////////////////////////////////////////////////////////
// classes to support dynamic record sets
// rather than always writing extremely specific dbbind statements 
// for column results, this class does this for you.
// then you simply retrieved results from a named/positioned column
//
// based on a similiar class implemented for odbc and MFC's odbc classes
// by the author
//
//
//////////////////////////////////////////////////////////////////////////////////////
// class cdbColmns
class CsColumn;
class CsColumns  : public CdbLib  // support of dynamic column binding
{
public:
   CsColumns();
   virtual ~CsColumns();                                         
   void BindColumns();
   void UnBindColumns();
   //COleVariant  GetColumnValue(int iColumn);
   //COleVariant  GetColumnValue(LPCTSTR lpszColumnName);
   const CsColumn *   GetColumnValue(LPCTSTR lpszColumnName) const;
   const CsColumn *   GetColumnValue(int iColumn) const;
   const CString      GetColumnString(LPCTSTR lpszName);
   const CString      GetColumnString(int iColumn);
   int                GetNumColumns() const;
   double  CsColumns::GetValueDouble(int iColumn);
   const CString      GetColumnName(int iColumn) const;
   

private:

   CPtrArray   m_aColumns;

   int      m_NoColumns;
             

   void     DescribeColumns();
   friend class CsColumn;

protected:
   virtual CString GetDefaultSQL();    // default SQL for Recordset
   virtual void CsColumns::Close();
};
                             
//////////////////////////////////////////////////////////
typedef struct _bindvars
{           
   union 
   {
   DBDATETIME m_date;
   DBMONEY  m_money;
   double   m_double;
   float    m_float;
   long     m_long;
   short    m_short;
   unsigned
   char     m_char;
   };
} tagbindvars ;
//////////////////////////////////////////////////////////////////////////////////
// class CsColumn
class CsColumn   : public  _bindvars
{
protected:
   ~CsColumn();
public:

   CsColumn(  CdbLib *pdb, int iColumn);
   const long     GetInt() const ;
   const short    GetShort()const;
   const double   GetDouble()const;
   const DBMONEY  GetMoney() const;
   const CString  GetCString() const;               
   const float    GetFloat() const;
   const DBDATETIME GetDate() const;
   void  GetDate(DBDATETIME &) const;
   const BOOL     IsNull() const;
   ///////////////////////////////////////////    
protected:
   int      m_Type;         
   DBINT    m_null;
   CString  m_ColName;
   short    m_SqlType;
   long     m_ColDef;
   long     m_cbValue;
   short    m_Scale;
   short    m_Nullable;
   int      m_index;    // column number               
   short    m_Bound;         
   ULONG    m_Length;       
   
   //DBDATETIME m_date;
   //DBMONEY  m_money;
   //double m_double;
   //float    m_float;
   //long      m_long;
   //short     m_short;
   //unsigned
   //char     m_char;
   CString  m_string;
   CByteArray m_binarydata;
   char     *m_buffer;

   friend class CsColumns;
};
////////////////////////////////////////////////////////////////////////////////////
// class cdbRecordset                                                               

class CdbRecordset : public  CsColumns 
{
   DECLARE_DYNAMIC(CdbRecordset)

// Constructor
public:
   CdbRecordset(); 
   CdbRecordset( const CdbLib  & cdb);
public:
   ~CdbRecordset();
   BOOL Open(LPCSTR dbtouse);
   BOOL Execute();
   void Close();
   BOOL Bind();
  // called before data fields are bound
   // field operations
   const   CString     GetFieldCStr(LPCTSTR lpszName);
   const   CString     GetFieldCStr(int nIndex);
private: // not yet implemented
protected:

};

////////////////////////////////////////////////////////////////////////////////////////
#endif
