///////////////////////////////////////////////////////////////////////////////////
//
// Copywrite      Fred Zickar
//
// Program:       dblibrary class
//
// Module:        Cdblib.h    
//
// Description:   This class encapsulates usage of the dblibrary API
//                
//                The author allows free use of this source for personal or
// commercial use, the user disavows the author of any responsibility in its use,
// and it is the users responsibility to determine its suitability. 
// If the user modifies or alters the code in any way, the orginal copyright
// must remain, the revision history must be maintained, and any such additions
// alterations will be emailed to the author at  zfred@ozemail.com.au 
// I ask this as this code is by no means complete, but was sufficient for my
// requirements at the time of writing, any enhancements contributed I would
// like to incorporate for public release
// 
//////////////////////////////////////////////////////////////////////////////////    
// Although this uses DBLIB for Microsoft Sql server, the DBLIB for Sybase is 
// similiar, Sybase also have a improved api CTLIB.
// Microsoft of course would have you think today that DBLIB does not exist,
// but it does, this source was used with dblib and SQL Server 6.5 You can find
// the necesary files in the Backoffice SDK cd, the files
// NTWDBLIB.LIB
// MSDBLIB3.DLL
// SQLDB.H
// SQLFRONT.H
/////////////////////////////////////////////////////////////////////////////////
//
// Why would you use DBLIB ?  Well its very fast, faster than ODBC,
// and there are also the bulk copy APIs 
// Of course its a bit harder to use, hence this C++ wrapper
/////////////////////////////////////////////////////////////////////////////////
//                
//             
// REVISION HISTORY
// ----------------
// Version     Date     Author      Comments
// --------------------------------------------------------------------------------
//  1.1        3Apr97   FZickar     Further Enhanced at westpac  
//  1.0        21Jan97  FZickar     Initial Writing  
//             
////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////////
//
// Usage Notes
// -----------
//
// Initialising and using a CdbLib object
//
// Example:
// 
// class Prg
// {
//   ....
//   CdbLib   cdb;
//   RunAnddosomething();
// };
//
// void Prg::RunAnddosomething()
// {
//                       
//    cdb.Init();
//    if( cdb.Logon("sa","","\\MSSQL1") == SUCCEED &&
//        cdb.Dbopen() == SUCCEED )
//    {
//        cdb.dbuse("master");
//        cdb.dbcmd("select name from sysobjects order by name");
//        ......
//       
// 
//
// Creating another dbproc instance (or another connection)        
// --------------------------------------------------------
//
//    CdbLib  cdb2;
//
//    if( cdb2.Dbopen() == SUCCEED )
//    {
//       cdb2.dbuse("public");
//       cdb.dbcmd("....
//
//       cdb2.Dbclose();      // however this dbproc can be automatically
//                            // closed when cdb2 goes out of scope
//
//       ......
//
////////////////////////////////////////////////////////////////////////////////////
// CdbRecordset examples
//
//    CdbRecordset  db;
//    CString   sTitle;
//
//    if( db.Logon("sa","","\\MSSQL1") == SUCCEED &&
//        db.Open("pubs") )
//        
//    db.dbcmd("select * from authors");
//    if( db.Execute() )
//        if( db.Bind() )
//        {
//           while( (row_code= db.dbnextrow()) != NO_MORE_ROWS) 
//           {
//             if(row_code == REG_ROW)
//             {
//                sTitle = db.GetFieldCStr(1);
//                cout << "Author Title " << sTitle << endl;
//             }
//          
//    
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
// includes

#include "stdafx.h" 
#include "cdblib.h"

#if WIN32
#define __export
#endif

extern HWND ghWnd;           /* global window handle for handlers    */
static HWND errhWnd;            /* global window handle for current error*/

void  SetErrWnd( HWND hWnd)
{
   errhWnd = hWnd;
}

/////////////////////////////////////////////////////////////////////////////////////
// static instance of CdbLib variables 
FARPROC        CdbLib::lpdbwinMessageHandler; /* pointer to message handler        */
FARPROC        CdbLib::lpdbwinErrorHandler;   /* pointer to error handler       */   
MESGTEXTPROC   CdbLib::m_lptextproc;
CStringList    CdbLib::m_serverlist;
int            CdbLib::m_Instance = 0;
PLOGINREC      CdbLib::m_STATIC_login  =NULL;
CString        CdbLib::m_STATIC_userid ="";
CString        CdbLib::m_STATIC_password="";
CString        CdbLib::m_STATIC_server ="";
BOOL           CdbLib::m_LoggedIn = FALSE ;
short          CdbLib::m_STATIC_CountLogins = 0;
BOOL           CdbLib::m_STATIC_InitFlag=FALSE;
///////////////////////////////////////////////////////////////////////////////////
// CdbLib
///////////////////////////////////////////////////////////////////////////////////
 
CdbLib::CdbLib()
{
   if(m_Instance > 0)
   {
      m_login     = m_STATIC_login;       // copy to instance variables
      m_userid    = m_STATIC_userid;
      m_password  = m_STATIC_password;
      m_server    = m_STATIC_server;
   }
   m_shared    = FALSE;
   
   m_dbproc = (PDBPROCESS)NULL;
   lpdbProcesswinMessageHandler = NULL;
   lpdbProcesswinErrorHandler = NULL;
   
     
   if(m_Instance==0)
   {
         lpdbwinMessageHandler = NULL;
         lpdbwinErrorHandler   = NULL;
   }
   m_lptextproc   = NULL;
   
//   if( m_STATIC_InitFlag == FALSE)      // initialisation of class statics
//     Init();
       
   m_Instance++;
} 

CdbLib::~CdbLib()
{  
   
   LogOff();
   m_Instance--;   
   
   #ifdef  DBMSWIN
   if(lpdbProcesswinMessageHandler != NULL)
         FreeProcInstance(lpdbProcesswinMessageHandler);
         
   if(lpdbProcesswinErrorHandler != NULL)
         FreeProcInstance(lpdbProcesswinErrorHandler      );
   #endif         
   

   if(m_Instance==0)
   {       
         
         #ifdef  DBMSWIN
            FreeProcInstance(lpdbwinMessageHandler);  /* release handlers  */
            FreeProcInstance(lpdbwinErrorHandler);
         #endif
         dbwinexit();       /* free any active dbprocesses     */

   }  

   if(m_shared) 
      m_shared--;
   
}

void CdbLib::Init()
{                     
     if(m_STATIC_InitFlag)
        return;
        
     m_STATIC_InitFlag = TRUE;
     m_LoggedIn = FALSE;
     m_STATIC_login = NULL;
        
     dbinit();
     HINSTANCE hInst =  AfxGetInstanceHandle(); 

     #ifdef DBMSWIN       
     lpdbwinMessageHandler =
            MakeProcInstance((FARPROC)dbwinMessageHandler, hInst);
     lpdbwinErrorHandler =
            MakeProcInstance((FARPROC)dbwinErrorHandler, hInst);
         
         /* Install the instances into dblib */ 
     dbmsghandle(lpdbwinMessageHandler);
     dberrhandle(lpdbwinErrorHandler);
     #else
        dbmsghandle((DBMSGHANDLE_PROC)dbwinMessageHandler);
        dberrhandle((DBERRHANDLE_PROC)dbwinErrorHandler);
    #endif 
}
//////////////////////////////////////////////////////////////////////
int  CdbLib::EnumServers()
{    
     int   r, i;
     unsigned short numentries=0;
     LPSTR namebuf, p,p1=0;
     
     m_serverlist.RemoveAll();
     namebuf = new char [32000];
     
     r = dbserverenum( NET_SEARCH | LOC_SEARCH, namebuf, 32000, &numentries );
     
     i = numentries;
     p = namebuf;
     while(i-- && *p)
     {               
        m_serverlist.AddTail( p );
        
        while(*p) p++;
        p++;
     } 
     
     delete namebuf;
     
     return numentries;     
}
     
                               
//////////////////////////////////////////////////////////////////////
// Logon
// establishes a login with a server, if Logon is reused in another
// instance, logon to a different server is possible
// m_STATIC_CountLogins tracks the number of logins established.


BOOL CdbLib::Logon(LPCSTR userid, LPCSTR password, LPCSTR server)
{                       
   BOOL fReturn = FALSE;
                                  
   m_userid =  userid;
   m_password =  password;
   m_server   =  server;
      
      
   DBLOCKLIB();      /* lock down library     */
//   if (m_dbproc != (PDBPROCESS)NULL) /* if an active process close it */
//      dbclose(m_dbproc);

   if(m_shared)      // can't changed the login of a shared dbproc
      return FALSE;                                                          
   
   
   TRY
   {
         
      if ((m_login = dblogin()) != (PLOGINREC)NULL) /* get loginrec */
      {
         DBSETLUSER(m_login,(LPCSTR)m_userid); /* set user  */
         DBSETLVERSION(m_login,DBVER60); /* Request 6.0 server behavior */
         DBSETLPWD(m_login, m_password);
         DBSETLAPP(m_login, "RMW");
         
         m_LoggedIn = TRUE;
         fReturn = TRUE;
         
         
         if(m_STATIC_CountLogins == 0)    // first login assumes a static instance
         {
            m_STATIC_login    = m_login;
            m_STATIC_userid   = m_userid;
            m_STATIC_password = m_password;
            m_STATIC_server   = m_server;
            
         }  
         m_STATIC_CountLogins++;
      }
      else /* memory allocation problem */
         m_LoggedIn = FALSE;  //   MessageBox(hDlg, "Could not allocate Login Record","System Error", MB_ICONHAND | MB_OK);
   
   }
   CATCH_ALL(e)
   {
      ;
   }
   END_CATCH_ALL;
            
   DBUNLOCKLIB(); /* done unlock library  */
   
   return fReturn;

}
//////////////////////////////////////////////////////////////////////
// LogOff
//
void CdbLib::LogOff()
{     
   if(m_shared==0)   // not a shared dbproc/login
   {
      if(m_STATIC_CountLogins>1)    // were additional login
      {
         m_STATIC_CountLogins--;
         if(m_login)
            ::dbfreelogin(m_login);

         m_login = NULL;
         m_LoggedIn = FALSE;
      }
   }
   
   if(m_Instance==1)
      m_STATIC_login = NULL;

   Dbclose();
}     
//////////////////////////////////////////////////////////////////////////////////////////////
// For Windows-based clients, when dbopen is called with the name of a SQL Server to connect 
// to, DB-Library uses the configuration information in the [SQLSERVER] section of the WIN.INI
// file. The entries of the [SQLSERVER] section of WIN.INI have the following format
//          
// logical_name = Net-Library_Name[,network_specific_ parameters]
//

BOOL  CdbLib::Dbopen(LPCSTR dbtouse)
{     
   BOOL fReturn = FALSE;
                            
   TRY
   {                        
      /* now open the connection to server */
      if ((m_dbproc = dbopen(m_login,(LPCSTR)m_server))
         == (PDBPROCESS)NULL)
      {
         /* if NULL couldn't connect   */
         fReturn = FALSE;
      }
      else if(dbtouse != NULL) /* got connect so use the pubs database */
      {
         ::dbuse(m_dbproc, (LPSTR)dbtouse);
          
         fReturn = TRUE;    
      }
   }
   CATCH_ALL(e)
   {
      ;
   }
   END_CATCH_ALL;
   
   return fReturn;      
}                 

void  CdbLib::Dbclose()
{               
   PDBPROCESS nullprocess = (PDBPROCESS)NULL;   // because of compiler error!!
   
   MY_TRY
   {
      if( m_dbproc != nullprocess)
      {
        if(m_shared == 0)
        {
         dbclose ( m_dbproc );
         m_dbproc = NULL;
        }               
      }
      if(m_Instance==0)
         LogOff();
   }
   MY_CATCH_ALL(e)
   {
      ;
   }
   MY_END_CATCH_ALL;

}

////////////////////////////////////////////////////////////////////////
RETCODE CdbLib::dbsqlexec()
{
   RETCODE rc = FAIL;
#if WIN32
   try
   {
      rc =::dbsqlexec (m_dbproc );
   }
   catch(...)
   {
      rc = FAIL;
   }
#else
   TRY
   {
      rc =::dbsqlexec (m_dbproc );
   }
   CATCH_ALL(e)
   {
      rc = FAIL;
   }
   END_CATCH_ALL;
#endif

   return rc;
}

////////////////////////////////////////////////////////////////////////
// clear any result set processing
void CdbLib::Cancel()
{    
   PDBPROCESS nullprocess = (PDBPROCESS)NULL;
   
   if( m_dbproc != nullprocess
      && ::dbdead( m_dbproc) == FALSE)
   {                               
       
       do {   
            ::dbcanquery( m_dbproc );
       }
       while( ::dbmorecmds( m_dbproc ) == SUCCEED && ::dbresults(m_dbproc) == SUCCEED );
   }
}     
//////////////////////////////////////////////////////////////////////////////
int  CdbLib::ExecuteSql(const CWnd &MsgWnd)
{                                         
   int retc;
   
      if(::dbsqlexec(m_dbproc) == FAIL)  // execute command
      {
           // problem occurred, just try another command
           TRACE("Error in executing command batch!\n");
//                 x = 1;
           return 0;
      }
        // command executed correctly, get results information
      while((retc = ::dbresults(m_dbproc)) != NO_MORE_RESULTS)
      {
         if (retc == FAIL) // if error get out of loop
            break;
           // headers and data could be printed here with only two
           // function calls, dbprhead(dbproc), and dbprrow(dbproc),
           // which would output the headers, and all the data to
           // standard output.  However, that isn't very informative
           // toward understanding how this data is obtained and
           // processed, so I do it the hard way, one column at a time.

           //PrintHeaders(dbproc);     // print header data

           // loop on each row, until all read
           while((retc= ::dbnextrow(m_dbproc))!=NO_MORE_ROWS)
           {
              if(retc == FAIL)      // if fail, then clear
              {            // connection completely, just
                 ::dbcancel(m_dbproc);   // in case.
                 break;
              }
              else
              ;//    PrintRow(dbproc); // else print the current row
           }     
                 
         if(DBCOUNT(m_dbproc) == 1L)   // print the row count
            TRACE("(1 row effected)\n");
         else
            TRACE("(%ld rows effected)\n",DBCOUNT(m_dbproc));

      } // end while(dbresults())
      
      return 0;

}
//////////////////////////////////////////////////////////////////////////////
int  CdbLib::ExecuteSqlBuffer(CEdit & m_sqledit, const CWnd &MsgWnd)
{                                        
   int n,line;
   int x=0; // lines executed
   char  sbuffer[256+2];
   
   
   n = m_sqledit.GetLineCount();
   
   for(line=0;line<n;line++)
   {           
      if( m_sqledit.GetLine(  line, sbuffer, 256) == 0 )
        continue;
      
      
         // loop on command input until quit or exit appears in first 4 bytes.
      if((strnicmp(sbuffer,"quit",4) != 0) && (strnicmp(sbuffer,"exit",4)!=0))
      {
         if(strnicmp(sbuffer,"go",2) == 0)   // is it go
         {   
            ExecuteSql( MsgWnd );  
            dbfreebuf( m_dbproc );
            x = 0;

         }    
         else
         {  
            ::dbcmd(m_dbproc, sbuffer );
            //strcat(cmd," ");      // go not detected, so put space
            ::dbcmd(m_dbproc," ");   // between each command and set in
            x++;
         }           // dbproc.
      }// quit    
      
      
   } // end for()
  
   if(x>0)  // execute remaining lines
   {
      ExecuteSql( MsgWnd );
   }
   dbfreebuf( m_dbproc );
   
   return 0;
}

//////////////////////////////////////////////////////////////////////
// SetMsgHandlerProc
// Set Message handler procedure for the dblibrary
//
void  CdbLib::SetMsgHandlerProc(DBMSGHANDLE_PROC fMsgProc)
{    
    #ifdef DBMSWIN   
     HINSTANCE hInst =  AfxGetInstanceHandle();
      
     if(lpdbwinMessageHandler != NULL)
        FreeProcInstance(lpdbwinMessageHandler);
          
     lpdbwinMessageHandler =
            MakeProcInstance((FARPROC)fMsgProc, hInst);

     dbmsghandle(lpdbwinMessageHandler);
      
    #else
      dbmsghandle(fMsgProc);
    #endif
} 
//////////////////////////////////////////////////////////////////////
// SetErrHandlerProc
// Set Message handler procedure for the dblibrary
//
void  CdbLib::SetErrHandlerProc(DBERRHANDLE_PROC fErrProc)
{   
   #ifdef DBMSWIN
   
      HINSTANCE hInst =  AfxGetInstanceHandle();
                      
      if(lpdbwinErrorHandler != NULL)
      FreeProcInstance(lpdbwinErrorHandler);
                               
      lpdbwinErrorHandler =
            MakeProcInstance((FARPROC)fErrProc, hInst);
      dberrhandle( lpdbwinErrorHandler );
   #else
      dberrhandle( fErrProc);
   #endif 
}


                               
//////////////////////////////////////////////////////////////////////
// SetDBPROCMsgHandlerProc
// Set Message handler procedure for the current dbproc
void  CdbLib::SetDBPROCMsgHandlerProc(DBMSGHANDLE_PROC fMsgProc)
{
   PDBPROCESS nullprocess = (PDBPROCESS)NULL;   // because of compiler error!!
   
   if( m_dbproc != nullprocess)
   {   
   #ifdef DBMSWIN
      HINSTANCE hInst =  AfxGetInstanceHandle();
       
      lpdbProcesswinMessageHandler =
            MakeProcInstance((FARPROC)fMsgProc, hInst);

      dbmsghandle(lpdbProcesswinMessageHandler);
   #else
      dbprocmsghandle( m_dbproc,fMsgProc); 
   #endif
   }
} 
//////////////////////////////////////////////////////////////////////
// SetDBPROCErrHandlerProc
// Set Message handler procedure for the current dbproc
//
void  CdbLib::SetDBPROCErrHandlerProc(DBERRHANDLE_PROC fErrProc)
{                                                 
   PDBPROCESS nullprocess = (PDBPROCESS)NULL;   // because of compiler error!!
   
   if( m_dbproc != nullprocess)
   {  
   #ifdef DBMSWIN 
      HINSTANCE hInst =  AfxGetInstanceHandle();
       
      lpdbProcesswinErrorHandler =
            MakeProcInstance((FARPROC)fErrProc, hInst);
        
            dberrhandle( lpdbProcesswinErrorHandler );
   #else
      dbprocerrhandle( m_dbproc,fErrProc); 
   #endif
   }
}

#pragma   warning(disable:4100)
  
/****************************************************************************

   FUNCTION: dbwinMessageHandler(PDBPROCESS, DBINT, DBSMALLINT, DBSMALLINT,
      LPSTR)

   PURPOSE:  When the Data Server returns a message to dblib this function
      will be called to process that message.  This function is
      installed into dblib via MakeProcInstance.  It must be declared
      as a FAR cdecl function, not as a FAR PASCAL function, unlike
      other call back routines, as dblib conducts all of it's calls
      in the cdecl fashion.  You must return 0 to dblib.

   RETURN:  Return 0

   COMMENTS:

****************************************************************************/

int FAR __export CdbLib::dbwinMessageHandler(PDBPROCESS dbproc, DBINT msgno, 
                                 INT msgstate, INT severity, LPCSTR msgtext, 
                                 LPCSTR srvname,  LPCSTR  procname,
                                 DBUSMALLINT line
                                 )
{
   static CString msgStr;  
   
   msgStr.Format("Mesg: %d:%d:%d:%s", (int)msgno,(int)msgstate,(int)severity,msgtext);
   
   MessageBox(errhWnd,msgtext,(LPSTR)"SQL DataServer Message",MB_OK);   
   
      
   if(m_lptextproc)
      m_lptextproc( msgStr, 0);
   return(0);
}


/****************************************************************************

   FUNCTION: dbwinErrorHandler(PDBPROCESS, int, int, int, LPSTR, LPSTR)

   PURPOSE:  When dblib returns an error message to the application this
      function will be called to process that error.  This function is
      installed into dblib via MakeProcInstance.  It must be declared
      as a FAR cdecl function, not as a FAR PASCAL function, unlike
      other call back routines, as dblib conducts all of it's calls
      in the cdecl fashion.  You must return either INT_CANCEL,
      INT_CONTINUE, or INT_EXIT to dblib.

   RETURN:  Return continuation code.

   COMMENTS:

****************************************************************************/

int FAR __export CdbLib::dbwinErrorHandler(PDBPROCESS dbproc, INT severity, INT errno, INT oserr, LPCSTR dberrstr, LPCSTR oserrstr)
{                        
   static CString ErrStr;
   
   ErrStr.Format("error:%d Severity %d %s\t", errno, severity, dberrstr);
   
   MessageBox(errhWnd,dberrstr,(LPSTR)"DB-LIBRARY error",MB_ICONHAND | MB_OK);

   if (oserr != DBNOERR)   /* os error */
      MessageBox(errhWnd,oserrstr,(LPSTR)"Operating-System error",MB_ICONHAND | MB_OK);

   return(INT_CANCEL);  /* cancel command */
}
////////////////////////////////////////////////////////////////////////////////////////





//////////////////////////////////////////////////////////////////////////////////////                         
//////////////////////////////////////////////////////////////////////////////////////
//    Exception implementation
//
// 
IMPLEMENT_DYNAMIC(CdbLibException, CException)

CdbLibException::CdbLibException(RETCODE nRetCode)
{
   m_nRetCode = nRetCode;
}

CdbLibException::~CdbLibException()
{
}                   
void CdbLibException::Empty()
{
   m_strError.Empty();
}

#ifdef _DEBUG
void CdbLibException::AssertValid() const
{
   CObject::AssertValid();
}
#endif // _DEBUG

/////////////////////////////////////////////////////////////////////
void AFXAPI CdbLibThrowException(RETCODE nRetCode, CdbLib* pdb, CString ErrMsg)
{
   CdbLibException* pException = new CdbLibException(nRetCode);
   if (nRetCode == SUCCEED && pdb != NULL)
   {
//    pException->BuildErrorString(pdb, hstmt);
   }
   else if (nRetCode == FAIL)
   {                               
   }
   pException->m_strError += ErrMsg;
   TRACE1("%s\n", (LPCSTR)pException->m_strError);

   THROW(pException);
}






                            
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//    recordset implementation 
//    
//    allows usage of a dynamic recordset to store sql query results
//    
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//
// CsColumns implementation which is the CsColumn collection used
// by CsRecordset
//
////////////////////////////////////////////////////////////////////////////
CsColumns::CsColumns() : CdbLib()
{
    m_NoColumns = 0;
    m_aColumns.SetSize(0);
    
}

CsColumns::~CsColumns()
{
    UnBindColumns();  
}

void CsColumns::Close()
{
   UnBindColumns();
   
}

CString CsColumns::GetDefaultSQL()
{
   return "";
}

int   CsColumns ::GetNumColumns() const
{
   return m_NoColumns;
}

void  CsColumns ::DescribeColumns( )   
{
   int i,n;
   CsColumn *pCol;

   n = dbnumcols ();
   m_NoColumns=0;
   
// TRY
// {
       for(i=1;i <= n;i++)
       {
               pCol = new CsColumn( this, i );
   
               m_aColumns.InsertAt( i, pCol );
               m_NoColumns++;
       } 
//   }
//   CATCH( CException, e)
//   {
//    ;
//   }
}   
////////////////////////////////////////////////////////////////////////
// BindColums
//
void CsColumns::BindColumns()    // virtual
{
     UnBindColumns();      // clear any current columns 
     DescribeColumns( );                                    
}
////////////////////////////////////////////////////////////////////////
void CsColumns::UnBindColumns()
{
     CsColumn *pCol=NULL;

     int n = m_aColumns.GetUpperBound();
     
     for(int i=0; i <= n; i++ )
     {
        pCol = (CsColumn *) m_aColumns[i];
        delete pCol;
     }
     m_NoColumns = 0;
     m_aColumns.RemoveAll();
}
/////////////////////////////////////////////////////////////////////
// Retrieve column values
//
const CsColumn * CsColumns::GetColumnValue(LPCTSTR lpszColumnName) const
{
   CsColumn *pCol=NULL;
   ASSERT(lpszColumnName!=NULL);
   
      for(int i=1; i <= m_NoColumns; i++ )
      {
         pCol = (CsColumn *) m_aColumns[i];
         if( pCol->m_ColName.CompareNoCase(lpszColumnName) ==0 )
            return pCol;
      }
                  
      ASSERT(FALSE);    // column not found, check your code
      return NULL;
}  

const CsColumn * CsColumns::GetColumnValue(int iColumn) const
{
   CsColumn *pCol=NULL;
   
   if(iColumn <= m_NoColumns)
   {
      pCol = (CsColumn*)m_aColumns[iColumn];  // array 0..n

      return pCol;
   }
   
   ASSERT(FALSE);    // column not found, check your code
   return NULL;
}

double  CsColumns::GetValueDouble(int iColumn)
{
   CsColumn *pCol;

   if(iColumn <= m_NoColumns)
   {
      pCol = (CsColumn*)m_aColumns[iColumn];  // array 0..n

      return pCol->m_double;
   }             
   
   ASSERT(FALSE);
   return (double)0;
}

const CString  CsColumns::GetColumnString(LPCTSTR lpszColumnName)
{
   CsColumn *pCol;
   TRY
   {
      for(int i=1; i <= m_NoColumns; i++ )
      {
         pCol = (CsColumn *) m_aColumns[i];
         if( pCol->m_ColName.CompareNoCase(lpszColumnName) ==0 )
            return pCol->GetCString();
      }
   }
   CATCH( CException,  e )
   {
      // Note: DELETE_EXCEPTION(e) not necessary

   }
   END_CATCH
   
   ASSERT(FALSE);
   CString result;

   return result;

}

const CString  CsColumns::GetColumnString(int iColumn)
{
   CsColumn *pCol;

   if(iColumn <= m_NoColumns)
   {
      pCol = (CsColumn*)m_aColumns[iColumn];  // array 
      if(pCol)
         return pCol->GetCString();
   }

   ASSERT(FALSE); 
   CString result;

   return result;
}                
//////////////////////////////////////////////////////////////////
// get the table column name   
const CString      CsColumns::GetColumnName(int iColumn) const
{
   CsColumn *pCol;

   if(iColumn <= m_NoColumns)
   {
      pCol = (CsColumn*)m_aColumns[iColumn];  // array 
      if(pCol)
         return pCol->m_ColName;
   }             
   
   ASSERT(FALSE);
   CString result;

   return result;
   
}

/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
// CsColumn implementation used by CdbRecordset
//
//
CsColumn::CsColumn(  CdbLib *pdb, int iColumn)
{
   char     *pbuf;
   RETCODE  rc;  
   DBCOL    colInfo;
   
   m_index = iColumn;
   m_null = 0;
   
   if( ! pdb->dbdead() )
   {
      colInfo.SizeOfStruct = sizeof(colInfo);
                      
      rc = pdb->dbcolinfo ( CI_REGULAR, iColumn, 0, &colInfo); 
                      
      m_Type      = pdb->dbcoltype(iColumn);
      m_ColName   = pdb->dbcolname(iColumn);
      m_Length    = m_ColDef     = pdb->dbcollen(iColumn);
      m_Nullable  = colInfo.Null;
      m_Scale     = colInfo.Scale;
      
         

      switch(m_Type)
      {
      case SQLINTN:       
                        rc = pdb->dbbind(iColumn,TINYBIND,1L,  (BYTE *)&m_char);
                        break;
      case SQLINT2:
                        rc = pdb->dbbind(iColumn,SMALLBIND,2L, (BYTE *)&m_short);
                        break;
      case SQLINT4:     
                        rc = pdb->dbbind(iColumn,INTBIND,4L,   (BYTE *)&m_long);
                        break;
      
      case SQLCHAR:    
                        pbuf = m_string.GetBufferSetLength((int)m_ColDef +1);
                        rc = pdb->dbbind(iColumn,NTBSTRINGBIND,m_ColDef +1,   (BYTE *)pbuf);
                        break;
      
      
      case SQLBIT:
                        rc = pdb->dbbind(iColumn,BITBIND,1L,   &m_char);
                        break;

      case SQLDATETIME:  
      case SQLDATETIMN: 
      
                        rc = pdb->dbbind(iColumn,DATETIMEBIND,sizeof(DBDATETIME),(BYTE *)&m_date);
                        break;
      case SQLMONEY:  
      case SQLMONEYN:
      case SQLMONEY4:
      case SQLFLTN:     
                        rc = pdb->dbbind(iColumn,MONEYBIND,sizeof(DBMONEY),(BYTE *)&m_money);
                        break;
      
      case SQLFLT8:
                        rc = pdb->dbbind(iColumn,FLT8BIND,sizeof(double),(BYTE *)&m_double);
                        break;
      case SQLVARCHAR:
      case SQLVARBINARY:
                        pbuf = m_string.GetBufferSetLength((int)m_ColDef +1);
                        rc = pdb->dbbind(iColumn,NTBSTRINGBIND,m_ColDef +1,   (BYTE *)pbuf);
                        break;
      case SQLFLT4:
                        rc = pdb->dbbind(iColumn,FLT4BIND,sizeof(float),(BYTE *)&m_float);
                        break;
      
      
      default:      
               ASSERT(FALSE);
      }
      if(rc==SUCCEED)
         rc = pdb->dbnullbind(iColumn, &m_null);
   }

}

CsColumn::~CsColumn()
{    
   switch(m_Type)
   {
      case SQLCHAR:    
      case SQLVARCHAR:
      case SQLVARBINARY:
                         m_string.ReleaseBuffer();
                         break;
      default:
                         ;                  
   }
}

const BOOL  CsColumn::IsNull() const
{
   if(m_null == -1)
      return TRUE;

   return FALSE;
}

const long     CsColumn::GetInt() const
{
   if(m_null != -1)
   {
      switch(m_Type)
      {
         case SQLBIT:       
                           return m_char;
                           break;
         case SQLINT2:
                           return m_short;
                           break;
         case SQLINT4:                   
                           return m_long;
      }
   }
   return 0;
}   

const short    CsColumn::GetShort() const
{
   if(m_null != -1)
   {
      switch(m_Type)
      {
         case SQLBIT:       
                           return m_char;
                           break;
         case SQLINT2:
                           return m_short;
                           break;
         case SQLINT4:                   
                           return (short)m_long;
      }
   }
   return 0;
}  
 
const double   CsColumn::GetDouble() const
{                           
   RETCODE rc;
   
   if(m_null != -1)
   {
      switch(m_Type)
      {
         case SQLBIT:       
                           return m_char;
                           break;
         case SQLINT2:
                           return m_short;
                           break;
         case SQLINT4:                   
                           return m_long;
         case SQLFLT4:
                           return m_float;
                     
         case SQLFLT8:
                           return m_double;
         case SQLMONEY:  
         case SQLMONEYN:
         case SQLMONEY4:
         case SQLFLTN:     
                           rc = ::dbconvert( 0,SQLMONEY,(BYTE *)&m_money,(DBINT)-1, SQLFLT8, (BYTE *) &m_double, (DBINT)-1 );
                           return m_double;
      }
   }
   return (double)0;
}

const DBMONEY  CsColumn::GetMoney() const
{                                    
   RETCODE rc;
   
   if(m_null != -1)
   {
      switch(m_Type)
      {
         case SQLINT2:
                           rc = ::dbconvert(NULL, SQLINT2, (BYTE *) &m_short, (DBINT)-1, SQLMONEY,(BYTE *)&m_money,(DBINT)-1);
                           return m_money;
         case SQLINT4:
                           rc = ::dbconvert(NULL, SQLINT4, (BYTE *) &m_long, (DBINT)-1, SQLMONEY,(BYTE *)&m_money,(DBINT)-1);
                           return m_money;
         case SQLFLT4:
                           rc = ::dbconvert(NULL, SQLFLT4, (BYTE *) &m_float, (DBINT)-1,SQLMONEY,(BYTE *)&m_money,(DBINT)-1 );
                           return m_money;
                     
         case SQLFLT8:   
                           rc = ::dbconvert((PDBPROCESS )NULL, SQLFLT8, (BYTE *) &m_double, (DBINT)-1,SQLMONEY,(BYTE *)&m_money,(DBINT)-1 );
                           return m_money;
         case SQLMONEY:  
         case SQLMONEYN:
         case SQLMONEY4:
         case SQLFLTN:     
                           return m_money;
      }
   }

   DBMONEY result;
   result.mnyhigh = 0;
   result.mnylow  = 0;
   return result;
}

const DBDATETIME CsColumn::GetDate() const
{
   if(m_null != -1)  // not null
   {
      switch(m_Type)
      {
         case SQLDATETIME:  
         case SQLDATETIMN: 
                           return m_date;
      }
   }
   DBDATETIME     result;
   result.dtdays  = 0;
   result.dttime  = 0;
   return result;
}

void  CsColumn::GetDate(DBDATETIME & dt) const
{
   if(m_null != -1)
   {  // not null 
      switch(m_Type)
      {
         case SQLDATETIME:  
         case SQLDATETIMN: 
                            dt = m_date;
                            return;
      }
   }
   dt.dtdays  = 0;
   dt.dttime  = 0;
}

static const char *monthnames[] = { "", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", 0};

const CString  CsColumn::GetCString()  const
{
   CString result;
   RETCODE rc;
   char buffer[40]={0};

   if(m_null == -1)  // column is null
   {
      result = "";
   }
   else
   {

      switch(m_Type)
      {
      case SQLINTN:    
                        itoa( m_char, buffer, 10);
                        result = buffer;   
                        break;
      case SQLINT2:
                        itoa( m_short, buffer, 10);
                        result = buffer;   
                        break;
      case SQLINT4:                  
                        ltoa( m_long, buffer, 10);
                        result = buffer;   
                        break;
      case SQLCHAR:    
                        result = m_string;
                        break;
      
      case BINARYBIND:
      case SQLBIT:
                        if (m_char!=0)
                           result = "true";
                        else
                           result = "false";
                        break;

      case SQLDATETIME:  
      case SQLDATETIMN: 
                        rc = ::dbconvert(
                        (PDBPROCESS )NULL, SQLDATETIME, (BYTE *) &m_date, (DBINT)-1, SQLCHAR,
                        (BYTE *)&buffer, (DBINT)-1);
                        result = buffer;
                        break;
      case SQLMONEY:  
      case SQLMONEYN:
      case SQLMONEY4:
      case SQLFLTN:     
                        rc = ::dbconvert(
                        (PDBPROCESS )NULL, SQLMONEY, (BYTE *) &m_money, (DBINT)-1, SQLCHAR,
                        (BYTE *)&buffer, (DBINT)-1);
                        result = buffer;
                        break;
      
      case SQLFLT8:
                        rc = ::dbconvert(
                        (PDBPROCESS )NULL, SQLFLT8, (BYTE *) &m_double, (DBINT)-1, SQLCHAR,
                        (BYTE *)&buffer, (DBINT)-1);
                        result = buffer;
                        break;
      case SQLVARCHAR:
      case SQLVARBINARY:
                        result = m_string;
                        break;
      case SQLFLT4:
                        rc = ::dbconvert(
                        (PDBPROCESS )NULL, SQLFLT4, (BYTE *) &m_float, (DBINT)-1, SQLCHAR,
                        (BYTE *)&buffer, (DBINT)-1);
                        result = buffer;
                        break;
      default:      
               ASSERT(FALSE);
      }
   }

   result.TrimLeft();
   return result;
}



////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
//
// class CdbRecordset
////////////////////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNAMIC(CdbRecordset, CObject)

CdbRecordset::CdbRecordset() 
{
   Init();
   m_shared = FALSE;
            
}

CdbRecordset::CdbRecordset(const  CdbLib & cdb) 
{                                
   // this constructor allows sharing of the dbprocess
    m_login    = cdb.GetLogin();
    m_userid   = cdb.m_userid;
    m_password = cdb.m_password;
    m_server   = cdb.m_server;
    m_dbproc   = cdb.m_dbproc;
    m_shared   ++;
}
 
CdbRecordset::~CdbRecordset()
{   
    Cancel();
}  


BOOL CdbRecordset::Open(LPCSTR dbtouse)
{
     if(LoggedIn())
     {
       return Dbopen(dbtouse);
     }               
     return FALSE;
}
void CdbRecordset::Close() 
{          
     Dbclose();
}

BOOL CdbRecordset::Bind()
{
     if( result_code != FAIL )
     {
         BindColumns();
         return TRUE;      
     }
     return FALSE;
}

