#include <windowsx.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <windows.h>
#include <resolv.h>
#include "res.h"
#include "resource.h"
//#include "gui.h"
//#include "dialog.h"

HINSTANCE hInstance, hInstance2;

extern void PrintHelp();
HWND gDlg;
char *current_string;
int current_lines = 0;
int oldlines = 0;
char current_qtype[30];
char current_class[10];
char current_nameserver[200];
BOOLEAN nameserver_set = FALSE;
BOOLEAN changing_size = FALSE;
BOOLEAN locallserver = FALSE;
HCURSOR hStdCursor, hWaitCursor;
RECT savedlargerc, savedsmallrc;
int current_servers = 1;
BOOLEAN bFirst = TRUE;

#define maxservers 100
char szServers[MAXSERVERS][200];

#define MAXTYPES 13
LPSTR szTypes[MAXTYPES]={
  "A",
  "ANY",
  "CNAME",
  "HINFO",
  "MX",
  "PX",
  "NS",
  "PTR",
  "SOA",
  "TXT",
  "WKS",
  "SRV",
  "NAPTR"
  };

#define MAXROOTS 11
LPSTR szRoots[MAXROOTS]={
  "a.root-servers.net.",
  "b.root-servers.net.",
  "c.root-servers.net.",
  "d.root-servers.net.",
  "e.root-servers.net.",
  "f.root-servers.net.",
  "g.root-servers.net.",
  "h.root-servers.net.",
  "i.root-servers.net.",
  "j.root-servers.net.",
  "k.root-servers.net."
  };
 

#define MAXCLASSES 4
LPSTR szClasses[MAXCLASSES]={
  "IN",
  "ANY",
  "HESIOD",
  "CHAOS"
  };

 char filestring[100000];
 int selarray[5000];
//HANDLE outputfile;
FILE *outputfile;
BOOLEAN editednameserver = FALSE;
BOOLEAN editeddomain = FALSE;
BOOLEAN editedquery = FALSE;
BOOLEAN enlarging = FALSE;
char Query [NAME_LEN];
char Domain [NAME_LEN];
char text[10000];
char qtype[30];

long current_extent = 0;
void PrintToBox();
long WGetListboxStringExtent(HWND hList, LPSTR psz)
{
    TEXTMETRIC  tm;
    HDC         hDC;
    HFONT       hFont;
    long       wExtent;
    SIZE        mysize;


    /*
     * Make sure we are using the correct font.
     */
    hDC=GetDC(hList);
    hFont=(HFONT)SendMessage(hList, WM_GETFONT, 0, 0L);

    if (hFont!=NULL)
        SelectObject(hDC, hFont);

    GetTextMetrics(hDC, &tm);

    /*
     * Add one average text width to insure that we see the end of the
     * string when scrolled horizontally.
     */
     GetTextExtentPoint32(hDC,psz,lstrlen(psz)+tm.tmAveCharWidth,&mysize);
     wExtent=mysize.cx;
     ReleaseDC(hList, hDC);

     return wExtent;
}

void checkhscroll(char *string)
 {
   long newextent = WGetListboxStringExtent(gDlg,string);
   
   if (newextent > current_extent)
     {
       // set it
       SendDlgItemMessage(gDlg, IDC_OUTPUT, LB_SETHORIZONTALEXTENT, (WPARAM)newextent,0);
       current_extent = newextent;
     }
 }

void opentempfile()
{
outputfile = fopen("nslookup.tmp","w+");
}

void bringtoend(loc)
  int loc;
 { 
   SendDlgItemMessage(gDlg, IDC_OUTPUT, LB_SETTOPINDEX, (DWORD)(WPARAM)loc,0);
 }


void processtempfile()

{
           int count;
           FILE *tfile;
           fflush(outputfile);
           fclose(outputfile);
           
           tfile = fopen("nslookup.tmp","r");
           count = fread(filestring,sizeof(char),100000,tfile);
           filestring[count] = '\0';

           PrintToBox(filestring,count);
           PrintToBox("\n-------------------------------------------------------------------\n",0);
           fclose(outputfile);
           SetCursor(hStdCursor);
           opentempfile();
}


void process_query_button(HWND hDlg)
 {
   int i = 0;
				
   oldlines = current_lines;
   editedquery = FALSE;

    // ls command
   if (strncmp(Query,"ls ",3) == 0)
     {
       char option[100];
       char name[200];
       char cmd[10];
       char dummy1[50];
       char dummy2[50];

       strcpy(text,"> ");
       strcat(text,Query);
       strcat(text,"\n\n");
       PrintToBox(text,0);

       // now check if the second parameter is a -x and if so call listhostsbytype
	  i = sscanf(Query, "%s %s %s %s %s", cmd, option, name,dummy1,dummy2);
       SetCursor(hWaitCursor);
       if ((i >= 3) && (strncmp(option,"-t",2) == 0))
         ListHostsByType(Query,0);
       else ListHosts(Query,0);
       processtempfile();
     }

    // finger command
    else if (strncmp(Query,"finger ",7) == 0)
           {
             strcpy(text,"> ");
             strcat(text,Query);
             strcat(text,"\n\n");
             PrintToBox(text,0);
             
             SetCursor(hWaitCursor);
             Finger(Query,0);
             processtempfile();
           }

     else // regular lookup query
           {
             strcpy(text,"> ");
             strcat(text,Query);
             strcat(text," [");
             strcat(text,current_qtype);
             strcat(text," ");
             strcat(text,current_class);
             strcat(text,"]\n\n");
             PrintToBox(text,0); 
             
             SetCursor(hWaitCursor);
             LookupHost((char*)Query, 0);
             processtempfile();
           }                       
    bringtoend(oldlines);
}

void process_domain_changes(HWND hDlg)
{
  int i = 0;

  editeddomain = FALSE;
  i = GetDlgItemText(hDlg, IDC_DOMAIN, (LPTSTR)Domain, NAME_LEN);
  if (i != 0)	
    {	
      sprintf(Query,"do=%s",Domain);
      SetOption(Query);                    
    }
      
}  

void process_nameserver_addition(name)
 char *name;
 {
    int index;
    int location = SendDlgItemMessage(gDlg,IDC_NAMESERVER,CB_FINDSTRING,(WPARAM)-1,(LPARAM)(LPCTSTR)name);

        /* add new server to array if not already in list */
        if (location == CB_ERR)
          {
            // printf("*added a string to the server list = %s pos %d\n",name,current_servers);
            strcpy(szServers[current_servers],name);
            ++current_servers;
          }
        /* now reset the list */
	   SendDlgItemMessage(gDlg, IDC_NAMESERVER, CB_RESETCONTENT,(WPARAM)0,(LPARAM)0);
        index = SendDlgItemMessage (gDlg, IDC_NAMESERVER, CB_ADDSTRING, 0, (DWORD)(LPCSTR)current_nameserver);
        for(index=1;index<=current_servers; index++)
          SendDlgItemMessage(gDlg,IDC_NAMESERVER,CB_ADDSTRING,0,(LONG)(LPSTR)szServers[index-1]);
	   SendDlgItemMessage (gDlg, IDC_NAMESERVER, CB_SETCURSEL, 0, 0);
 }   

void process_nameserver_changes(HWND hDlg)
{

  /* lgk new code here to add old to end of list and make new one 1st */
  /* first see if old server is already in the list.. if so we don't need to add it
     if not add it to the list before setting the new server */

  int i = 0;
 
  editednameserver = FALSE;
  oldlines = current_lines;

  i = GetDlgItemText(hDlg, IDC_NAMESERVER, (LPTSTR)text, NAME_LEN);
  if (i != 0)
     {
       SetCursor(hWaitCursor);
       if (IsDlgButtonChecked(hDlg, IDC_LSERVER))
          {
            strcpy(Query,"lserver ");
            strcat(Query,text);
            SetDefaultServer(Query,1);
          }
        else
          {
            strcpy(Query,"server ");
            strcat(Query,text);
            SetDefaultServer(Query,0);
          }

        nameserver_set = TRUE;
        strcpy(current_nameserver,text);
        process_nameserver_addition(current_nameserver);
        processtempfile();
        bringtoend(oldlines);
      }
}


void centerdialog(HWND hDlg)
 {
   RECT rc;
   GetWindowRect(hDlg, &rc);
 
    SetWindowPos(hDlg, NULL,
       ((GetSystemMetrics(SM_CXSCREEN) - (rc.right - rc.left)) / 2),
       ((GetSystemMetrics(SM_CYSCREEN) - (rc.bottom - rc.top)) / 2),
       0, 0, SWP_NOSIZE | SWP_NOACTIVATE);
 }

void restore_dialog(HWND hDlg, BOOLEAN large)
  {

   if (large)
    {
     SetWindowPos(hDlg,NULL,savedlargerc.left,savedlargerc.top,0,0,SWP_NOSIZE | SWP_NOACTIVATE);
    }
   else
    {
     if (savedsmallrc.left == -1) // override to center small dialog first time
       centerdialog(hDlg);
     else
       SetWindowPos(hDlg,NULL,savedsmallrc.left,savedsmallrc.top,0,0,SWP_NOSIZE | SWP_NOACTIVATE);
    }
  }




// gets info from aboutdialogbox
BOOL CALLBACK aboutDialogFunc(  hDlg,  uMsg,  wParam,  lParam)
HWND hDlg;
UINT uMsg;
WPARAM wParam;
LPARAM lParam;
 {

	switch (uMsg)
	{
  	  case WM_INITDIALOG:
            // We need to initialize stuff in the dialog box...
            return (TRUE);
     
	  case WM_DESTROY:
	  	  break;

	  case WM_COMMAND:
		  switch (GET_WM_COMMAND_ID(wParam, lParam))
		  {
		    case IDOK:
		 	    EndDialog(hDlg, TRUE);
			    break;
	       }

     default:
       return(FALSE);
    }
	   
    return(TRUE);
}


// gets info from dialogbox
BOOL CALLBACK lpDialogFunc(  hDlg,  uMsg,  wParam,  lParam)
HWND hDlg;
UINT uMsg;
WPARAM wParam;
LPARAM lParam;
{
	extern char rootServerName [NAME_LEN];
	extern char defaultServer[NAME_LEN];
	extern int  queryClass;
	extern int  queryType;
	extern struct __res_state _res;
     int tabstops = 5;
	int i, index, len;

     switch (uMsg)
	{
	case WM_INITDIALOG:
            // We need to initialize stuff in the dialog box...
            if (!changing_size)
            {
               gDlg = hDlg;
            
                // lgk new code to center dialog
               centerdialog(hDlg);
               strcpy(szServers[0],defaultServer);
               strcpy(current_nameserver,defaultServer);
               index = SendDlgItemMessage (hDlg, IDC_NAMESERVER, CB_ADDSTRING, 0, (DWORD)(LPCSTR)defaultServer);
               SendDlgItemMessage (hDlg, IDC_NAMESERVER, CB_SETCURSEL, 0, 0); 
                 for(index=1;index<=current_servers;index++)
                    SendDlgItemMessage(hDlg,IDC_NAMESERVER,CB_ADDSTRING,0,(LONG)(LPSTR)szServers[index-1]);

			SetDlgItemText(hDlg, IDC_DOMAIN, (LPTSTR)_res.defdname);
			SetDlgItemInt(hDlg,IDC_PORT,nsport,FALSE);
			SetDlgItemInt(hDlg,IDC_RETRY,_res.retry,FALSE);
			SetDlgItemInt(hDlg,IDC_TIMEOUT,_res.retrans,FALSE);
               CheckDlgButton(hDlg,IDC_LSERVER,0);
               CheckDlgButton(hDlg,IDC_VC,0);
               CheckDlgButton(hDlg,IDC_RECURSE,1);
               CheckDlgButton(hDlg,IDC_IGNORE,0);
	          SendDlgItemMessage(hDlg, IDC_OUTPUT, LB_INITSTORAGE, 10000,(DWORD) 100000);
               strcpy(current_qtype,"A");
               strcpy(current_class,"IN");

               for(index=0;index<MAXTYPES;index++)
                  SendDlgItemMessage(hDlg,IDC_QueryType,CB_ADDSTRING,0,(LONG)(LPSTR)szTypes[index]);
               for(index=0;index<MAXCLASSES;index++)
                 SendDlgItemMessage(hDlg,IDC_CLASS,CB_ADDSTRING,0,(LONG)(LPSTR)szClasses[index]);
               for(index=0;index<MAXROOTS;index++)
                 SendDlgItemMessage(hDlg,IDC_ROOTSERVER,CB_ADDSTRING,0,(LONG)(LPSTR)szRoots[index]);
               SendDlgItemMessage (hDlg, IDC_QueryType, CB_SETCURSEL, 0, 0);
			SendDlgItemMessage (hDlg, IDC_CLASS, CB_SETCURSEL, 0, 0);
               SendDlgItemMessage (hDlg, IDC_ROOTSERVER, CB_SETCURSEL, 0, 0);
               opentempfile();
               savedsmallrc.left = -1;
            }

           else // changing size don't reinit stuff
           {
               gDlg = hDlg;
               restore_dialog(hDlg,enlarging);
               index = SendDlgItemMessage (hDlg, IDC_NAMESERVER, CB_ADDSTRING, 0, (DWORD)(LPCSTR)current_nameserver);
			SendDlgItemMessage (hDlg, IDC_NAMESERVER, CB_SETCURSEL, 0, 0);
               for(index=1;index<=current_servers;index++)
                  SendDlgItemMessage(hDlg,IDC_NAMESERVER,CB_ADDSTRING,0,(LONG)(LPSTR)szServers[index-1]);

			SetDlgItemText(hDlg, IDC_DOMAIN, (LPTSTR)_res.defdname);
			SetDlgItemInt(hDlg,IDC_PORT,nsport,FALSE);
			SetDlgItemInt(hDlg,IDC_RETRY,_res.retry,FALSE);
			SetDlgItemInt(hDlg,IDC_TIMEOUT,_res.retrans,FALSE);
               CheckDlgButton(hDlg,IDC_LSERVER,locallserver);
               CheckDlgButton(hDlg,IDC_VC,(_res.options & RES_USEVC));
               CheckDlgButton(hDlg,IDC_DEBUG,(_res.options & RES_DEBUG));
               CheckDlgButton(hDlg,IDC_RECURSE,(_res.options & RES_RECURSE));
               CheckDlgButton(hDlg,IDC_D2,(_res.options & RES_DEBUG2));
               CheckDlgButton(hDlg,IDC_IGNORE,(_res.options & RES_IGNTC));
               SendDlgItemMessage(hDlg, IDC_OUTPUT, LB_INITSTORAGE, 10000,(DWORD) 100000);
               for(index=0;index<MAXTYPES;index++)
                  SendDlgItemMessage(hDlg,IDC_QueryType,CB_ADDSTRING,0,(LONG)(LPSTR)szTypes[index]);
               for(index=0;index<MAXCLASSES;index++)
                 SendDlgItemMessage(hDlg,IDC_CLASS,CB_ADDSTRING,0,(LONG)(LPSTR)szClasses[index]);
               for(index=0;index<MAXROOTS;index++)
                  SendDlgItemMessage(hDlg,IDC_ROOTSERVER,CB_ADDSTRING,0,(LONG)(LPSTR)szRoots[index]);

               SendDlgItemMessage (hDlg, IDC_QueryType, CB_SETCURSEL,  
                    SendDlgItemMessage(hDlg,IDC_QueryType,CB_FINDSTRINGEXACT,(WPARAM)-1,(LPARAM)(LPCTSTR)current_qtype),0);
			SendDlgItemMessage (hDlg, IDC_CLASS, CB_SETCURSEL, 
                    SendDlgItemMessage(hDlg,IDC_CLASS,CB_FINDSTRINGEXACT,(WPARAM)-1,(DWORD)(LPCTSTR)current_class),0);
               SendDlgItemMessage (hDlg, IDC_ROOTSERVER, CB_SETCURSEL,
                    SendDlgItemMessage(hDlg,IDC_ROOTSERVER,CB_FINDSTRINGEXACT,(WPARAM)-1,(DWORD)(LPCTSTR)rootServerName),0);
               if (nameserver_set)
                  SetDlgItemText(hDlg, IDC_NAMESERVER, (LPTSTR)current_nameserver);
               changing_size = FALSE;
               current_lines = 0;
               oldlines = 0;
               SendDlgItemMessage(gDlg, IDC_OUTPUT, LB_SETHORIZONTALEXTENT, (WPARAM)0,0);
               current_extent = 0;
               opentempfile();
             }

           return (TRUE);

     // users messages means return
     // when we get return check if any commands are pending

	case WM_DESTROY:
	      break;

	case WM_COMMAND:
         {
            WORD cmd = GET_WM_COMMAND_ID(wParam,lParam);
            // don't do this if command is the return key
            if (cmd != IDOK)
              {
               if ((editednameserver) && (cmd != IDC_NAMESERVER))
                 {            

                  process_nameserver_changes(hDlg);
                 }

               if ((editeddomain) && (cmd != IDC_DOMAIN))
                 {
                  process_domain_changes(hDlg);
                 }
              }
           }

          
		switch (GET_WM_COMMAND_ID(wParam, lParam))
		{

          case IDOK: // special case means the return button was pressed
            { 
              HWND hwndTest;

              hwndTest = GetFocus() ;

              if ((hwndTest == GetDlgItem(hDlg,IDC_QUERYSTRING)) && editedquery) 
                {
                 i = GetDlgItemText(hDlg, IDC_QUERYSTRING, (LPTSTR)Query, NAME_LEN);
                 if (i != 0)
                  process_query_button(hDlg);
                 else editedquery = FALSE;
                }
              else if ((hwndTest == GetDlgItem(hDlg,IDC_NAMESERVER)) && editednameserver)   
                { 
                  process_nameserver_changes(hDlg);
                }
              else if ((hwndTest == GetDlgItem(hDlg,IDC_DOMAIN)) && editeddomain)
                {
                 process_domain_changes(hDlg);
                }
               else if (editednameserver) // the above hwnd doesnot work any longer with combo boxes so the below 
                                          // is a kludge to get return working again
                  {
                   process_nameserver_changes(hDlg);
                  }
              }
              break;

		case IDCANCEL:
			EndDialog(hDlg, TRUE);
               fclose(outputfile);
               _unlink("nslookup.tmp");
               ExitThread(0);
			break;

          case IDC_HIDE:
               GetWindowRect(hDlg, &savedlargerc);
               EndDialog(hDlg, TRUE);
               changing_size = TRUE;
               enlarging = FALSE;
               hInstance = GetModuleHandle (NULL);
 	          DialogBox(hInstance, MAKEINTRESOURCE(IDD_DIALOG2), NULL, lpDialogFunc);
               break;

          case IDC_ENLARGE:
               GetWindowRect(hDlg, &savedsmallrc);
               EndDialog(hDlg, TRUE);
               changing_size = TRUE;
               enlarging = TRUE;
               hInstance = GetModuleHandle (NULL);
 	          DialogBox(hInstance, MAKEINTRESOURCE(IDD_DIALOG1), NULL, lpDialogFunc);
               break;

          case IDC_COPY: // copy to clipboard
               {
                 // first get the current selection from the dialog and then copy to a string
                 // use filestring
                 int selcount = SendDlgItemMessage (hDlg, IDC_OUTPUT, LB_GETSELCOUNT,0,0);
                 int rv = 0;
                 int i = 0;
                 HGLOBAL hData;
                 LPVOID lpData;

                 SetCursor(hWaitCursor);
                 if (selcount > 5000)
                 {
                    PrintToBox("\n\nCan only copy a maximum of 5000 lines to the Clipboard!\n\n");
                 }
                 else if (selcount > 0)
                  {
                    // now get the selections
                    rv = SendDlgItemMessage(hDlg,IDC_OUTPUT,LB_GETSELITEMS,(WPARAM)selcount,(LPARAM)(LPINT)&selarray);
                    if (rv != 0)
                      {
                       // now go and get each item
                       filestring[0] = '\0';
                       for (i=0; i<rv; i++)
                         {
                           SendDlgItemMessage(hDlg,IDC_OUTPUT,LB_GETTEXT, (WPARAM)selarray[i], (LPARAM)(LPCTSTR)text);
                           // now concat to file string
                           strcat(filestring,text);
                           strcat(filestring,"\n\r");
                         }

                /* Allocate memory and copy the string to it. */

                hData = GlobalAlloc(GMEM_MOVEABLE, strlen(filestring)+1);

                if (hData == NULL  ||
                   (lpData = GlobalLock(hData)) == NULL)
                   
                  {
                   PrintToBox("\n\nCopy To Clipboard Failed - Out of Memory\n\n");
                  }
                 else
                 {
                  lstrcpy(lpData, (LPCTSTR)filestring);
                  GlobalUnlock(hData);

                  /*
                   * Clear the current contents of the clipboard,
                   * and set the data handle to the new string.
                   */

                  if (OpenClipboard(hDlg))
                    {
                      EmptyClipboard();
                      SetClipboardData(CF_TEXT, hData);
                      CloseClipboard();
                      SendDlgItemMessage(hDlg,IDC_OUTPUT,LB_SETSEL, (WPARAM)(BOOL)FALSE,(LPARAM)(UINT)-1);
                    }
                 }
                    hData = NULL;
               }
               }
               }

              SetCursor(hStdCursor);
              break;

		case IDQUERY:
              i = GetDlgItemText(hDlg, IDC_QUERYSTRING, (LPTSTR)Query, NAME_LEN);
              if (i == 0)
                {
                 editedquery = FALSE;
	            break;
                }
              process_query_button(hDlg);
		    break;

		case IDC_DEBUG:
			 CheckDlgButton(hDlg, IDC_D2, 0); // turn off d2 button
			 SetOption("nod2");
			 if (IsDlgButtonChecked(hDlg, IDC_DEBUG))
                  {
                    SetOption("deb"); 			 
                    CheckDlgButton(hDlg, IDC_D2, 0); // turn off d2 button
			     SetOption("nod2");
                  }
			 else
			   SetOption("nodeb");
			 break;

          case IDC_LSERVER:
               if (IsDlgButtonChecked(hDlg, IDC_LSERVER ))
			   locallserver = TRUE;
			else
			   locallserver = FALSE;
			break;

		case IDC_D2:       // debug has to be on for d2 to work
               if (IsDlgButtonChecked(hDlg, IDC_D2))
                 {                      
                    SetOption("deb");
                    SetOption("d2");			
                    CheckDlgButton(hDlg, IDC_DEBUG, 1);// turn off debug button
                 }
			else
			   SetOption("nod2");
			break;
          
          case IDC_CLEAR:
               SendDlgItemMessage(hDlg, IDC_OUTPUT, LB_RESETCONTENT, 0, 0);
               current_lines = 0;
               oldlines = 0;
               SendDlgItemMessage(gDlg, IDC_OUTPUT, LB_SETHORIZONTALEXTENT, (WPARAM)0,0);
               current_extent = 0;

               break;

		case IDC_IGNORE:
			if (IsDlgButtonChecked(hDlg, IDC_IGNORE))
			  SetOption("ig");
			else
			  SetOption("noig");
			break;

		case IDC_RECURSE: 
			if (IsDlgButtonChecked(hDlg, IDC_RECURSE))
			   SetOption("rec");
			else
			   SetOption("norec");
			break;

		case IDC_VC:
			if (IsDlgButtonChecked(hDlg, IDC_VC))
			   SetOption("v");
			else
			   SetOption("nov");
			break;

		case IDC_PORT:
			i = GetDlgItemInt(hDlg,IDC_PORT,NULL,FALSE);
			if ((i != 0) && (i << 65536))	
                 {	
			 	sprintf(Query,"po=%d",i);
                    SetOption(Query);
			  }
			break;

		case IDC_RETRY:
			i = GetDlgItemInt(hDlg, IDC_RETRY, NULL, FALSE);
			if ((i != 0) && (i << 65536))
                 {	
				sprintf(Query,"ret=%d",i);
                    SetOption(Query);
			  }
			break;

		case IDC_TIMEOUT:
			i = GetDlgItemInt(hDlg, IDC_TIMEOUT, NULL, FALSE);
			if ((i != 0) && (i << 65536))
                 {	
				sprintf(Query,"ti=%d",i);
                    SetOption(Query);
			  }
			break;
		
		case IDC_DOMAIN:
               i = GetDlgItemText(hDlg, IDC_DOMAIN, (LPTSTR)text, NAME_LEN);
               if (strcmp(Domain,text) != 0)
                    {
                     editeddomain = TRUE;
                    }
		      break;

		case IDC_NAMESERVER:
               /* problem: after hitting return the nameserver gets changed but this
                  flag immediately gets set again so that as soon as we leave the field
                  it gets set a second time .... solution only set this if nameserver has
                  changed by comparing field to current variable */

                  i = GetDlgItemText(hDlg, IDC_NAMESERVER, (LPTSTR)text, NAME_LEN);
                  if (strncmp(defaultServer,text,strlen(defaultServer)) != 0)
                    {
                     editednameserver = TRUE;
                    }
                 break;

		case IDC_OUTPUT:
			break;

          case IDC_GUIHELP:
               oldlines = current_lines;
               PrintHelp();
               processtempfile();
               bringtoend(oldlines);
               break;

          case IDC_ALL:
               oldlines = current_lines;
               SetOption("all");
               processtempfile();
               bringtoend(oldlines);
               break;

		case IDC_QueryType:
		    index = SendDlgItemMessage(hDlg, IDC_QueryType, CB_GETCURSEL, 0, 0);
              len = SendDlgItemMessage(hDlg, IDC_QueryType, CB_GETLBTEXT, index, (DWORD)(LPCSTR)qtype);
              sprintf(Query,"ty=%s",qtype);
              SetOption(Query);
              strcpy(current_qtype,qtype);
		  break;

		case IDC_ROOTSERVER:
             index = SendDlgItemMessage(hDlg, IDC_ROOTSERVER, CB_GETCURSEL, 0, 0);
             len = SendDlgItemMessage(hDlg, IDC_ROOTSERVER, CB_GETLBTEXT, index, (DWORD)(LPCSTR)text);

			if (index != 0)	
                {	
                    sprintf(Query,"ro %s",text);
                    strcpy(rootServerName,text); 
                    SetOption(Query);
			}
			break;
		
		case IDC_QUERYSTRING:
               editedquery = TRUE;
			break;

		case IDC_CLASS:
		  index = SendDlgItemMessage(hDlg, IDC_CLASS, CB_GETCURSEL, 0, 0);
            len = SendDlgItemMessage(hDlg, IDC_CLASS, CB_GETLBTEXT, index, (DWORD)(LPCSTR)qtype);
            sprintf(Query,"cl=%s",qtype);
            SetOption(Query);
            strcpy(current_class,qtype);
		  break;

          case IDD_ABOUT: 	

               hInstance2 = GetModuleHandle (NULL);
               DialogBox(hInstance2,MAKEINTRESOURCE(IDD_ABOUTBOX),hDlg, aboutDialogFunc);
		break;
		 
         }
         break;

	default:
		return(FALSE);
	}

	return(TRUE);
}


void gui()	// starts here
{
     hStdCursor=LoadCursor((HINSTANCE)NULL,IDC_ARROW);
     hWaitCursor=LoadCursor((HINSTANCE)NULL,IDC_APPSTARTING);
    	hInstance = GetModuleHandle (NULL);
 	DialogBox(hInstance, MAKEINTRESOURCE(IDD_DIALOG1), NULL, lpDialogFunc);
     fclose(outputfile);
     _unlink("nslookup.tmp");
	return;
}


void PrintToBox(char *newtext, int count)
{
     extern HWND gDlg;
     int ctr = 0;
     int ctr2;
     char *cstring_ptr;
     char letter;
     BOOLEAN pending = FALSE;
     int len1 = strlen(newtext);

     if (count != 0)
       len1 = count;
     
//     printf("in print to box with string = %s \n",newtext);

     if (current_string == NULL)
       current_string = malloc(3000);

      cstring_ptr = current_string;        
        
        // lgk we need to parse the string and replace tabs with 5 spaces and newlines
        *cstring_ptr = '\0';
       for (ctr=0; ctr <= len1; ctr++)
        {
         letter = (char)*newtext;
          if (letter == '\t')
           {
            pending = TRUE;
            for (ctr2 = 0; ctr2 < 5; ctr2++)
               *cstring_ptr++ = ' ';
           } 
         else  if (letter == '\n')
          {
            *cstring_ptr++ = '\0';
 	       SendDlgItemMessage(gDlg, IDC_OUTPUT, LB_ADDSTRING, 0,(LPARAM)(LPCTSTR) current_string);
 	       checkhscroll(current_string);
            cstring_ptr = current_string;
            *cstring_ptr = '\0';
            pending = FALSE;
            ++current_lines;
          }  
        else if (letter == '\0') // ignore
        { }
        else if (letter == '\r') // ignore
        {  
          *cstring_ptr++ = ' ';
          pending = TRUE;
        }

        else // process
         {   
          *cstring_ptr++ = letter;
          pending = TRUE;
         }
       ++newtext;

      }
  if (pending) 
     {
      *cstring_ptr++ = '\0';
      SendDlgItemMessage(gDlg, IDC_OUTPUT, LB_ADDSTRING, 0,(LPARAM)(LPCTSTR) current_string);
      checkhscroll(current_string);
      ++current_lines;
     }
}


