
/*
   NOTE: All of these are C structures which means, mostly, that
         any character string fields are terminated with an ASCII
         NULL or 0. Bit maps are two-byte integers.
*/

#define MAX_AREAS   200    // do NOT change any of these values
#define MAX_AFIX     10
#define MAX_SEND     10
#define MAX_FREQ     10


struct _MAREA {            // this is in the _CFG later
   char tag[41],
        desc[41];
   int  SPARE1,
        SPARE2;
   int  new:1,
        arc:1,
        UNUSED:14;
   long lastrec;
};

struct _AFIX {             // this is in the _CFG later
   int add;
   char area[21];
};

struct _SEND {             // this is in the _CFG later
   char file[31],
        desc[65];
};

struct _FREQ {             // this is in the _CFG later
   char file[31];
};

struct _CFG {
   /* telecom config */
   int  port;
   long baud;
   int  locked;
   char init[31];
   char predial[31];
   char postdial[31];
   char SPARE_1[64];

   /* boss config */
   int  zone;
   int  net;
   int  node;
   char domain[31];
   char phone[16];
   long boss_baud;
   int  func_req:1,        // note that this is a bit mapped int field
        noupld:1,
        BOSS_UNUSED:14;
   char SPARE_2[64];

   /* local config */
   char name[36];
   char password[9];
   int  point;
   char origin[41];
   char archive[31];
   char unarchive[31];
   char editor[9];
   int  toss:1,            // note that this is a bit mapped int field
        link:1,
        logs:1,
        LOC_UNUSED:13;
   char city[21],
        basedir[31];
   int  zapwarn;           // warning threshold in k-bytes
   char SPARE_3[128];

   /* Hudson message base areas */
   struct _MAREA marea[MAX_AREAS];     // this is the struct defined above

   /* AreaFix list */
   struct _AFIX afix[MAX_AFIX];        // this is the struct defined above

   /* Send file list */
   struct _SEND send[MAX_SEND];        // this is the struct defined above

   /* Request list */
   struct _FREQ freq[MAX_FREQ];        // this is the struct defined above

};


