#define TITLE   "EXTR_NET"                /*  Program Name    */
#define DATES   "1988-94"                 /*  Copyright Date  */
#define VERSION "2.20"                    /*  Version Number  */
/*

                                  EXTR_NET
                                Version 2.20
            Copyright (c) Bob Swift, 1988-94.  All Rights Reserved.
                   Compiled with the Borland C++ compiler.

   This program is designed to read an input nodelist file and extract
   selected Networks, Regions and/or Zones.  The extracted portions of
   the nodelist are stored in a file specified on the command line.

   The format for using this program is as follows:


        EXTR_NET <srcfile> <destfile> [I] <net1> <net2>...<net20>

   where <srcfile>    is the name of the nodelist file to be read
         <destfile>   is the name of the output file created
         [I]          optionally include all Zone entries
         <net..>      are the numbers of the Net/Region/Zones to be extracted
                      and may include zone specifiers for Nets and Regions
                      (the program is presently set to handle 20 numbers).
                      These numbers may be preceded by a N, R or Z in order
                      to extract the entire Net, Region or Zone.  Examples
                      are: 123 N342 n2:201 r17 Z1


   The nodelist may be specified with a full drive and path.  The destination
   file must not have a drive or path specified.  It will be output to the
   current directory.

   The program will display a VERY brief set of instructions if it is called
   without any arguments or if it encounters an error.  The following is a
   list of the error codes returned by the program:

                  0 - No errors.  Normal termination.
                  1 - Bad or missing command line argument.
                  2 - Unable to open the input file.
                  3 - Unable to open the output file.
                  4 - Problem writing to output file.
                  5 - Problem closing input file.
                  6 - Problem closing output file.
                  7 - Unable to open configuration file.
                  8 - Unable to create backup file.

   When an error is encountered, the program will exit immediately and will
   attempt to properly close all files.

   Although I have chosen to retain all rights to this program, you are free
   to use it under the following conditions:

            - You realize that there is NO Warrantee of any sort.
              It was tested pretty thoroughly here before release
              but who knows what bugs may be lurking within.

            - You will not modify the code and release a new version
              of the program.  I welcome suggestions for improvement
              (especially when accompanied by code) but I make no
              guarantee of future releases.

            - If you find the program useful, I ask that you do
              something to brighten somebody else's day.  Just
              exactly what, I will leave up to you.


   You may freely distribute this program provided that you distribute only
   the complete archive which includes the EXTR_NET.EXE, EXTR_NET.C and
   EXTR_NET.DOC.  In addition, You MUST NOT charge for the program nor can
   you charge a copy fee over $4.00 (including the price of the diskette).


                                                   Bob Swift (1:342/5)


*/

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <mem.h>

    /* the CRC polynomial. This is used by XMODEM (almost CCITT).
     * If you change P, you must change crctab[]'s initial value to what is
     * printed by initcrctab()
     */
#define   P    0x1021

    /* number of bits in CRC: don't change it. */
#define W 16

    /* this the number of bits per char: don't change it. */
#define B 8

static unsigned short crctab[1<<B] = { /* as calculated by initcrctab() */
    0x0000,  0x1021,  0x2042,  0x3063,  0x4084,  0x50a5,  0x60c6,  0x70e7,
    0x8108,  0x9129,  0xa14a,  0xb16b,  0xc18c,  0xd1ad,  0xe1ce,  0xf1ef,
    0x1231,  0x0210,  0x3273,  0x2252,  0x52b5,  0x4294,  0x72f7,  0x62d6,
    0x9339,  0x8318,  0xb37b,  0xa35a,  0xd3bd,  0xc39c,  0xf3ff,  0xe3de,
    0x2462,  0x3443,  0x0420,  0x1401,  0x64e6,  0x74c7,  0x44a4,  0x5485,
    0xa56a,  0xb54b,  0x8528,  0x9509,  0xe5ee,  0xf5cf,  0xc5ac,  0xd58d,
    0x3653,  0x2672,  0x1611,  0x0630,  0x76d7,  0x66f6,  0x5695,  0x46b4,
    0xb75b,  0xa77a,  0x9719,  0x8738,  0xf7df,  0xe7fe,  0xd79d,  0xc7bc,
    0x48c4,  0x58e5,  0x6886,  0x78a7,  0x0840,  0x1861,  0x2802,  0x3823,
    0xc9cc,  0xd9ed,  0xe98e,  0xf9af,  0x8948,  0x9969,  0xa90a,  0xb92b,
    0x5af5,  0x4ad4,  0x7ab7,  0x6a96,  0x1a71,  0x0a50,  0x3a33,  0x2a12,
    0xdbfd,  0xcbdc,  0xfbbf,  0xeb9e,  0x9b79,  0x8b58,  0xbb3b,  0xab1a,
    0x6ca6,  0x7c87,  0x4ce4,  0x5cc5,  0x2c22,  0x3c03,  0x0c60,  0x1c41,
    0xedae,  0xfd8f,  0xcdec,  0xddcd,  0xad2a,  0xbd0b,  0x8d68,  0x9d49,
    0x7e97,  0x6eb6,  0x5ed5,  0x4ef4,  0x3e13,  0x2e32,  0x1e51,  0x0e70,
    0xff9f,  0xefbe,  0xdfdd,  0xcffc,  0xbf1b,  0xaf3a,  0x9f59,  0x8f78,
    0x9188,  0x81a9,  0xb1ca,  0xa1eb,  0xd10c,  0xc12d,  0xf14e,  0xe16f,
    0x1080,  0x00a1,  0x30c2,  0x20e3,  0x5004,  0x4025,  0x7046,  0x6067,
    0x83b9,  0x9398,  0xa3fb,  0xb3da,  0xc33d,  0xd31c,  0xe37f,  0xf35e,
    0x02b1,  0x1290,  0x22f3,  0x32d2,  0x4235,  0x5214,  0x6277,  0x7256,
    0xb5ea,  0xa5cb,  0x95a8,  0x8589,  0xf56e,  0xe54f,  0xd52c,  0xc50d,
    0x34e2,  0x24c3,  0x14a0,  0x0481,  0x7466,  0x6447,  0x5424,  0x4405,
    0xa7db,  0xb7fa,  0x8799,  0x97b8,  0xe75f,  0xf77e,  0xc71d,  0xd73c,
    0x26d3,  0x36f2,  0x0691,  0x16b0,  0x6657,  0x7676,  0x4615,  0x5634,
    0xd94c,  0xc96d,  0xf90e,  0xe92f,  0x99c8,  0x89e9,  0xb98a,  0xa9ab,
    0x5844,  0x4865,  0x7806,  0x6827,  0x18c0,  0x08e1,  0x3882,  0x28a3,
    0xcb7d,  0xdb5c,  0xeb3f,  0xfb1e,  0x8bf9,  0x9bd8,  0xabbb,  0xbb9a,
    0x4a75,  0x5a54,  0x6a37,  0x7a16,  0x0af1,  0x1ad0,  0x2ab3,  0x3a92,
    0xfd2e,  0xed0f,  0xdd6c,  0xcd4d,  0xbdaa,  0xad8b,  0x9de8,  0x8dc9,
    0x7c26,  0x6c07,  0x5c64,  0x4c45,  0x3ca2,  0x2c83,  0x1ce0,  0x0cc1,
    0xef1f,  0xff3e,  0xcf5d,  0xdf7c,  0xaf9b,  0xbfba,  0x8fd9,  0x9ff8,
    0x6e17,  0x7e36,  0x4e55,  0x5e74,  0x2e93,  0x3eb2,  0x0ed1,  0x1ef0
    };

int cfputs(char *s,FILE *stream);
unsigned short updcrc(unsigned short icrc,unsigned char *icp,unsigned int icnt);
void helpscrn(int ernum);
void add_period(char filename[]);
void build_bak_name(char filename[]);
int is_in_dir(char *filename);
int del_backup(char *filename);
int linetest(char *linetst1, char *inline);
int make_backup(char *srcfile, char *destfile);
char version[] = {VERSION};  /* Current Version Number */
char title[] = {TITLE};
char dates[] = {DATES};
unsigned short crc;

/*******************************************************************/

void main(int argc, char *argv[])
{

FILE *infile,*outfile;
char flnames[3][40];
char inline[358];
char linetst1[20];
char lintest[21][20];
char zontest[21][10];
char linshow[21][40];
int  lineflag[21];
char semi[20];
char temp[20];
char spaces[80];
char curzone[10];
time_t t;
fpos_t filepos;
char *pntr;
int i,j;
int sub1;
int count;
int flag;
int zoneflag;

memset(spaces,' ',79);
spaces[79] = '\0';
strcpy(curzone,"0");
zoneflag = 0;
t = time(NULL);

printf("\n\n%s Version %s\n",title,version);
printf("Copyright (c) Bob Swift, %s.  All Rights Reserved.\n",dates);

if (argc < 4 || argc > 14) helpscrn(1);
strcpy(flnames[1],strupr(argv[1]));             /*  Input File  */
strcpy(flnames[2],strupr(argv[2]));             /* Output File  */
strcpy(flnames[3],strupr(argv[2]));             /* Backup File  */

if (is_in_dir(flnames[2]) == 1)
    helpscrn(7);

add_period(flnames[3]);
build_bak_name(flnames[3]);

if (del_backup(flnames[3]) == 1)
    helpscrn(8);

/*  Exit if output file has an extension of BAK  */
if (strcmp(flnames[2],flnames[3])==0)
   helpscrn(8);

if (make_backup(flnames[2],flnames[3]) == 1)
    helpscrn(8);

infile=fopen(flnames[1],"rt");
if (infile == NULL)
    helpscrn(2);

if ((outfile=fopen(flnames[2],"wt")) == NULL)
    helpscrn(3);

count = 3;
sub1 = 0;
while (count < argc)      /*  Set Up Search Strings  */
  {
    strcpy(semi,argv[count]);
    switch(semi[0])
      {
      case 'i': ;
      case 'I': sub1++;
                strcpy(lintest[sub1],"I,");
                strcpy(zontest[sub1],"0");
                strcpy(linshow[sub1],"Include all ZONE entries.");
                lineflag[sub1] = 'I';
                zoneflag = 1;
                break;
      case 'n': ;
      case 'N': sub1++;
                strcpy(lintest[sub1],"Host,");
                strcpy(zontest[sub1],"0");
                strcpy(linshow[sub1],"Net ");
                lineflag[sub1] = 'N';
                i = 0;
                j = 1;
                strcpy(temp,"0");
                while (semi[j] != '\0')
                  {
                  temp[i] = semi[j];
                  i++;
                  j++;
                  temp[i] = '\0';
                  if (semi[j] == ':')
                    {
                    j++;
                    strcpy(zontest[sub1],temp);
                    i = 0;
                    strcpy(temp,"0");
                    }
                  }
                strcat(lintest[sub1],temp);
                strcat(lintest[sub1],",");
                strcat(linshow[sub1],temp);
                if (zontest[sub1][0] != '0')
                  {
                  strcat(linshow[sub1],"  (Zone ");
                  strcat(linshow[sub1],zontest[sub1]);
                  strcat(linshow[sub1],")");
                  }
                break;
      case 'r': ;
      case 'R': sub1++;
                strcpy(lintest[sub1],"Region,");
                strcpy(zontest[sub1],"0");
                strcpy(linshow[sub1],"Region ");
                lineflag[sub1] = 'R';
                i = 0;
                j = 1;
                strcpy(temp,"0");
                while (semi[j] != '\0')
                  {
                  temp[i] = semi[j];
                  i++;
                  j++;
                  temp[i] = '\0';
                  if (semi[j] == ':')
                    {
                    j++;
                    strcpy(zontest[sub1],temp);
                    i = 0;
                    strcpy(temp,"0");
                    }
                  }
                strcat(lintest[sub1],temp);
                strcat(lintest[sub1],",");
                strcat(linshow[sub1],temp);
                if (zontest[sub1][0] != '0')
                  {
                  strcat(linshow[sub1],"  (Zone ");
                  strcat(linshow[sub1],zontest[sub1]);
                  strcat(linshow[sub1],")");
                  }
                break;
      case 'z': ;
      case 'Z': sub1++;
                strcpy(lintest[sub1],"Zone,");
                strcpy(zontest[sub1],"0");
                strcpy(linshow[sub1],"Zone ");
                lineflag[sub1] = 'Z';
                i = 5;
                j = 1;
                strcpy(temp,"0");
                while (semi[j] != '\0')
                  {
                  lintest[sub1][i] = semi[j];
                  linshow[sub1][i] = semi[j];
                  i++;
                  j++;
                  }
                lintest[sub1][i] = '\0';
                linshow[sub1][i] = '\0';
                strcat(lintest[sub1],",");
                break;
      default:
          {
            sub1++;
            lineflag[sub1] = 'A';
            strcpy(lintest[sub1],"Zone,");
                strcpy(zontest[sub1],"0");
            strcpy(linshow[sub1],"Zone ");
                i = 0;
                j = 0;
                strcpy(temp,"0");
                while (semi[j] != '\0')
                  {
                  temp[i] = semi[j];
                  i++;
                  j++;
                  temp[i] = '\0';
                  if (semi[j] == ':')
                    {
                    j++;
                    strcpy(zontest[sub1],temp);
                    i = 0;
                    strcpy(temp,"0");
                    }
                  }
                strcat(lintest[sub1],temp);
                strcat(lintest[sub1],",");
                strcat(linshow[sub1],temp);
            sub1++;
            lineflag[sub1] = 'A';
            strcpy(lintest[sub1],"Region,");
                strcpy(zontest[sub1],zontest[sub1-1]);
                strcpy(zontest[sub1-1],"0");
            strcpy(linshow[sub1],"Region ");
                strcat(lintest[sub1],temp);
                strcat(lintest[sub1],",");
                strcat(linshow[sub1],temp);
                if (zontest[sub1][0] != '0')
                  {
                  strcat(linshow[sub1],"  (Zone ");
                  strcat(linshow[sub1],zontest[sub1]);
                  strcat(linshow[sub1],")");
                  }
            sub1++;
            lineflag[sub1] = 'A';
            strcpy(lintest[sub1],"Host,");
                strcpy(zontest[sub1],zontest[sub1-1]);
            strcpy(linshow[sub1],"Net ");
                strcat(lintest[sub1],temp);
                strcat(lintest[sub1],",");
                strcat(linshow[sub1],temp);
                if (zontest[sub1][0] != '0')
                  {
                  strcat(linshow[sub1],"  (Zone ");
                  strcat(linshow[sub1],zontest[sub1]);
                  strcat(linshow[sub1],")");
                  }
          }
      }
  count++;
  }
printf("Extracting:   ");    /*  Echo Input To User  */
for (count=1;count<=sub1;count++)
{
  printf("%s\n              ",linshow[count]);
}
printf("\n");

/*  Get first line of source nodelist file  */
/*  and print header to output file.        */
if (fgets(inline,256,infile) == NULL)
  {
  if (fputs(";A Extracted Nodelist Segment : 00000\n",outfile) == EOF) helpscrn(4);
  }
else
  {
  if (fputs(";A Extracted ",outfile) == EOF) helpscrn(4);
  if (fputs(inline+3,outfile) == EOF) helpscrn(4);
  }
crc = 0;
if (fgetpos(outfile,&filepos) != 0) helpscrn(4);
filepos = filepos - 7L;

/*  Print extraction info to output file  */
if (cfputs(";A \n;A Extracted with ",outfile) == EOF) helpscrn(4);
if (cfputs(title,outfile) == EOF) helpscrn(4);
if (cfputs(" Version ",outfile) == EOF) helpscrn(4);
if (cfputs(version,outfile) == EOF) helpscrn(4);
if (cfputs("\n;A ",outfile) == EOF) helpscrn(4);
if (cfputs("Copyright (c) Bob Swift, ",outfile) == EOF) helpscrn(4);
if (cfputs(dates,outfile) == EOF) helpscrn(4);
if (cfputs(".  All Rights Reserved.",outfile) == EOF) helpscrn(4);
if (cfputs("\n;A \n;A Extracted from ",outfile) == EOF) helpscrn(4);
if (cfputs(flnames[1],outfile) == EOF) helpscrn(4);
if (cfputs(" on ",outfile) == EOF) helpscrn(4);
if (cfputs(ctime(&t),outfile) == EOF) helpscrn(4);
if (cfputs(";A \n;A Extracting:     ",outfile) == EOF) helpscrn(4);
if (cfputs(linshow[1],outfile) == EOF) helpscrn(4);
for (count=2;count<=sub1;count++)
  {
  if(cfputs("\n;A                 ",outfile) == EOF) helpscrn(4);
  if(cfputs(linshow[count],outfile) == EOF) helpscrn(4);
  }
if (cfputs("\n;A \n;\n",outfile) == EOF) helpscrn(4);

/*  Initialize  */
count = sub1;
flag = 1;
j = 0;

/*  Get line from source file  */
while (fgets(inline,256,infile) != NULL)
  {
  if (inline[0] == 'Z')
    {
      i = 0;
      for (sub1=5;(inline[sub1] != ',') && (sub1 < strlen(inline));sub1++)
        {
          curzone[i] = inline[sub1];
          i++;
          curzone[i] = '\0';
        }
    }
    strcpy(semi,";");
    i = linetest(semi,inline);
    strcpy(semi,";\n");
    if ((linetest(semi,inline) == 1 && flag == 0) || i == 0)
    {

      if (flag == 0)
      {
        strcpy(semi,"Host");
        i = linetest(semi,inline);
        if (i == 1 && (j == 'N' || j == 'A')) flag = 1;
        if (flag == 1) if (cfputs(";\n",outfile) == EOF) helpscrn(4);
      }

      if (flag == 0)
      {
        strcpy(semi,"Region");
        i = linetest(semi,inline);
        if (i == 1 && (j == 'N' || j == 'R' || j == 'A')) flag = 1;
        if (flag == 1) if (cfputs(";\n",outfile) == EOF) helpscrn(4);
      }


      if (flag == 0)
      {
        strcpy(semi,"Zone");
        flag = linetest(semi,inline);
        if (flag == 1) if (cfputs(";\n",outfile) == EOF) helpscrn(4);
      }

      if (flag == 0)
      {
        if (cfputs(inline,outfile) == EOF)
           helpscrn(4);
      }

      if (flag == 1)
      {

        /*  Cycle through the search patterns  */
        for (sub1=1;sub1<=count && linetest(lintest[sub1],inline)==0;sub1++)
        {
            /*  Null Line  */
        }

        if (sub1 <= count) i = linetest(curzone,zontest[sub1]);
        if ((sub1 <= count) && ((zontest[sub1][0] == '0') || (i == 1)))
        {
          if (cfputs(inline,outfile) == EOF)
             helpscrn(4);
          flag = 0;
          j = lineflag[sub1];
        }
      }

      if (flag == 1)
      {

        /*  Check if Zone and print if all Zones selected  */
        strcpy(semi,"Zone");
        if (linetest(semi,inline) == 1)
        {
          i = 0;
          for (sub1=1;sub1<=count;sub1++)
          {
            if (linetest(zontest[sub1],curzone) == 1) i = 1;
          }
          if ((i == 1) || (zoneflag == 1))
          {
            if (cfputs(inline,outfile) == EOF) helpscrn(4);
            if (cfputs(";\n",outfile) == EOF) helpscrn(4);
          }
        }

      }
    }
  if (inline[0] == 'Z' || inline[0] == 'R' || (inline[0] == 'H' && inline[2] == 's'))
    {
      inline[strlen(inline)-1] = '\0';
      i = 0;
      for (sub1=0;sub1<=strlen(inline) && i<3;sub1++)
        {
          if (inline[sub1] == ',')
            {
              i++;
              if (i >= 3)
                inline[sub1] = '\0';
              if (i == 1)
                inline[sub1] = ' ';
            }
          if (inline[sub1] == '_')
            inline[sub1] = ' ';
        }
      strcat(inline,spaces);
      inline[79] = '\0';
      printf("%s",inline);
      if (inline[0] == 'Z')
        printf("\n");
      else
        printf("\r");
    }
  }
if (cfputs(";S End of extracted file.\n;S \n",outfile) == EOF) helpscrn(4);

/*  Close the source file  */
if (fclose(infile) != 0)
   helpscrn(5);

/*  Update the CRC value in the output file  */
if (fsetpos(outfile,&filepos) != 0) helpscrn(4);
fprintf(outfile,"%05u",crc);

/*  Close the destination file  */
if (fclose(outfile) != 0)
   helpscrn(6);

/*  Thank the user and exit gracefully  */
printf("%s",spaces);
printf("\nExtraction complete.  Thank-you for using %s.\n\n",title);
exit(0);
}


/*******************************************************************/

int cfputs(char *s,FILE *stream)
{
char string[256];
int i,j;

i = 0;
j = 0;
string[0] = '\0';
while (s[j] != '\0')
  {
  if (s[j] == '\n')
    {
    string[i] = 13;
    i++;
    string[i] = 10;
    i++;
    string[i] = '\0';
    }
  else
    {
    string[i] = s[j];
    i++;
    string[i] = '\0';
    }
  j++;
}
crc = updcrc(crc,string,i);
return (fputs(s,stream));
}


/*******************************************************************/

unsigned short updcrc(unsigned short icrc,unsigned char *icp,unsigned int icnt)
{
register unsigned short crc1 = icrc;
register unsigned char *cp = icp;
register unsigned int cnt = icnt;

while (cnt--)  crc1 = (crc1<<B) ^ crctab[(crc1>>(W-B)) ^ *cp++];

return(crc1);
}


/*******************************************************************/


int is_in_dir(char *filename)
/*  Check if input file in current directory  */
{
if (strchr(filename,'\\')!=NULL || strchr(filename,':')!=NULL)
   return(1);
 else
   return(0);
}



void add_period(char filename[])
/*  If input file has no extension finish it with a period  */
{
if (strchr(filename,'.')==NULL)
   strcat(filename,".");
}

void build_bak_name(char filename[])
/*  Build file name for backup file  */
{
int flag;
for (flag=0;filename[flag]!='.';flag++)
   {
   /*  NULL Line  */
   }
filename[flag] = '\0';
strcat(filename,".BAK");
}


int del_backup(char *filename)
/*  Check for existing backup file and delete  */
{
FILE *tempfile;
tempfile=fopen(filename,"r");
fclose(tempfile);
if (tempfile != NULL)
   {
   if (unlink(filename) != 0)
      return(1);
   }
return(0);
}


int make_backup(char *srcfile, char *destfile)
/*  Rename source file to destination file  */
{
FILE *tempfile;
tempfile=fopen(srcfile,"r");
fclose(tempfile);
if (tempfile != NULL)
   {
   if (rename(srcfile,destfile) != 0)
      return(1);
   }
return(0);
}


int linetest(char *linetst1, char *inline)
/*  This is the routine that actually checks for a match  */
{
int j;
for ( j=0; linetst1[j] == inline[j]; j++ )
    if (linetst1[j+1] == '\0') return(1);
return(0);
}


void helpscrn(int ernum)
/*  Here are the error messages and VERY brief instructions  */
{
cprintf("\n");
switch (ernum) {

case  1 : printf("     **  Bad or missing command line argument  **\n\n");
          break;

case  2 : printf("     **  Unable to open input file  **\n\n");
          break;

case  3 : printf("     **  Unable to open output file  **\n\n");
          break;

case  4 : printf("     **  Problem writing to output file  **\n\n");
          break;

case  5 : printf("     **  Problem closing input file  **\n\n");
          break;

case  6 : printf("     **  Problem closing output file  **\n\n");
          break;

case  7 : printf("     **  Output file not in current directory  **\n\n");
          break;

case  8 : printf("     **  Unable to create backup file  **\n\n");
          break;
    }
printf("This program is designed to read an input nodelist file and extract");
printf("\nselected Networks, Regions and/or Zones.  The extracted portions ");
printf("of\nthe nodelist are stored in a file specified on the command line");
printf(".\n\nThe format for using this program is as follows:\n\n");
printf("     EXTR_NET <srcfile> <destfile> [I] <net1> <net2>...<net20>\n\n");
printf("where <srcfile>    is the name of the nodelist file to be read\n");
printf("      <destfile>   is the name of the output file created\n");
printf("      [I]          optionally include all Zone entries\n");
printf("      <net..>      are the numbers of the Net/Region/Zones to be extracted\n");
printf("                   and may include zone specifiers for Nets and Regions\n");
printf("                   (the program is presently set to handle 20 numbers).\n");
printf("                   These numbers may be preceded by a N, R or Z in order\n");
printf("                   to extract the entire Net, Region or Zone.  Examples\n");
printf("                   are: 123 N342 n2:201 r17 Z1\n");
exit(ernum);
}

