/***********************************************************/
/* LIBRARY 2.00 source code copyright (c) 1993 by M. Kimes */
/*                          all rights reserved            */
/* code may not be used without prior written permission   */
/***********************************************************/

#define DEFINELIBGLOBALS

#include "doorskel.h"
#include "library.h"

void _cdecl deinitialize_library (void) {

  register word x;

  if (numsecs)
    for(x = 0;x<numsecs;x++)
      if (section[x])
        free (section[x]);
  free_docs();
  if(tmpin)
    remove(tmpin);
  if(tmpout)
    remove(tmpout);
  if(lastextracted)
    remove(lastextracted);

  if (home_dir[1] == ':') {
    DoorSetDrive(home_dir[0] - '@');
    chdir(home_dir);
  }
}


int lib_args (char *arg) {

ReSwitch:

  switch (toupper(*arg)) {
    case '-':
    case '/':   memmove(arg,&arg[1],strlen(arg));
                goto ReSwitch;
    case '\"':  /* remove enclosing quotes */
                memmove(arg,&arg[1],strlen(arg));
                if(arg[strlen(arg)] == '\"')
                  arg[strlen(arg)] = 0;
                goto ReSwitch;
    case 'H':   strcpy(home_dir,strupr(&arg[1]));
                break;
    case '@':   strcpy(lib_dir,strupr(&arg[1]));
                break;
    case 'F':   strcpy(secfile,&arg[1]);
                break;
    case '#':   sysmode = 1;
                break;
    case 'R':   sysmode = 2;
                break;
    case '$':   maint = (char)atoi(&arg[1]);
                break;
    case 'Z':   DoorSetTabSpaces(atoi(&arg[1]));
                break;
    case 'I':   initialsection = atoi(&arg[1]);
                break;
    default:    DoorANSIPrintf("\r\x1b[K\04Unknown argument \"%s\"\r\n",arg);
                DosSleep(1000L);
  }
  return 0;
}


void lib_help (void) {

  DoorANSIPrintf("H<home directory> (Defaults to start directory)\r\n"
          "@<library directory> (Defaults to start directory)\r\n"
          "F<security file> (Defaults to none)\r\n"
          "I<#> (Start in section #)\r\n"
          "# (Sysop-mode...read any file on the system)\r\n"
          "R (Reader mode...read any file in current directory)\r\n"
          "$<#> (Maintenance option will be available at level <#>)\r\n"
          "Z<#> Tabsize\r\n");
}


void functionkey_read (int keynum) {

  static char filename[CCHMAXPATH];

  sprintf(filename,".\\LIBRTEXT.%03d",keynum);
  DoorDebugPrintf("\r\n\04Attempting to read \"%s\"\r\n",filename);
  DoorReadText(filename,0);
}

void functionkey_spawn (int keynum) {

  static char filename[388];

  sprintf(filename,"%s /C LIBRE%03d.CMD",getenv("COMSPEC"),keynum);
  DoorDebugPrintf("\r\n\04Attempting to spawn \"%s\"\r\n",filename);
  DoorSpawn(filename);
}


int main (int argc,char *argv[]) {

  register word x;
  char          s[258];
  char          command;

  DoorSetProgramName("Library-OS/2 v1.11");
  DoorSetCopyRight("copyright (c) 1993/94 by M. Kimes");
  DoorSetExtraArgs(lib_args);
  DoorSetExtraHelp(lib_help);
  for(x = 0;x < 6;x++)
    DoorSetFunctionKey(x,functionkey_read);
  for(x = 6;x < 11;x++)
    DoorSetFunctionKey(x,functionkey_spawn);
  if(DoorInit(argc,argv))
    return 1;
  atexit(deinitialize_library);
  for (x = 0;x < MAXSECTIONS;x++)
    section[x] = NULL;
  for (x = 0;x < MAXFILES;x++)
    document[x] = NULL;

  if (!*home_dir) {
    getcwd(s,CCHMAXPATH);
    sprintf(home_dir,"%c:\\%s",DoorGetDrive() + '@',s);
  }
  else if (home_dir[strlen(home_dir) - 1] == '\\')
    home_dir[strlen(home_dir) - 1] = 0;

  if (*lib_dir) {
    if (lib_dir[1] == ':')
      DoorSetDrive(*lib_dir - '@');
    if (lib_dir[strlen(lib_dir)-1] == '\\')
      lib_dir[strlen(lib_dir) - 1] = 0;
    chdir (lib_dir);
  }

  if(DoorSearchPath("LIBRARY.MNU"))
    libmenu = 1;
  if(DoorSearchPath("LIBMAINT.MNU"))
    maintmenu = 1;

  sprintf(tmpin,"LIBIN$$$.%03hu",DoorGetNodeNumber());
  sprintf(tmpout,"LIBOUT$$.%03hu",DoorGetNodeNumber());
  unlink(tmpin);
  unlink(tmpout);

  DoorCLS();

  if (sysmode == 1) {
    DoorANSIPuts("\r\x1b[K\04SysOp Mode");
    for(;;) {
      DoorPrintGraphics(make_ansi(PC_LIGHTCYAN,PC_BLACK,NULL));
      strcpy(s,DoorGenericInput(99,0,1,0,FLEP,"\r\nFilename to read: ",NULL));
      DoorPuts("\r\n");
      if (!*s) {
        DoorPrintGraphics(make_ansi(PC_YELLOW,PC_BLACK,NULL));
        if (*DoorGenericInput(1,0,1,1,YESNO,"Quit? (Y/n) ",NULL) != 'N')
          return 0;
        if (*DoorGenericInput(1,0,1,1,YESNO,"\r\n Toggle ANSI? (y/N) ",
            NULL) != 'N')
          DoorToggleGraphics();
        if(!DoorGetGraphics())
          DoorPuts("\x1b[0m\r    \r");
        continue;
      }
      DoorPuts("[P]aged or [T]yped? [P] ");
      if (*DoorGenericInput(1,0,1,1,ALPHA,"[P]aged or [T]yped? [P] ",
          NULL) == 'T')
        grapharea = 1;
      else
        grapharea = 0;
      if(grapharea)
        DoorCLS();
      if(DoorReadText(s,(grapharea == 0)) > 0) {
        if(grapharea == 0) {
          sprintf(s,"\x1b[%d;1H",DoorGetLength());
          DoorModemPuts(s);
          DoorANSIPrintf("\x1b[%d;1H",DoorGetMaxy());
          if(!DoorInkey(18000L))
            DoorHitReturn();
        }
      }
    }
  }
  if (sysmode == 2) {
    DoorANSIPuts("\r\x1b[K\04Reader Mode");
    for(;;) {
      DoorPrintGraphics(make_ansi(PC_LIGHTCYAN,PC_BLACK,NULL));
      strcpy(s,DoorGenericInput(32,0,1,0,FLE,
               "\r\nFilename to read ([Enter] exits): ",NULL));
      DoorPuts("\r\n");
      if (!*s) {
        DoorPrintGraphics(make_ansi(PC_YELLOW,PC_BLACK,NULL));
        if (*DoorGenericInput(1,0,1,1,YESNO," Quit? (Y/n) ",NULL) != 'N')
          return 0;
        if (*DoorGenericInput(1,0,1,1,YESNO,"\r\n Toggle ANSI? (y/N) ",
            NULL) != 'N')
          DoorToggleGraphics();
        continue;
      }
      if (*DoorGenericInput(1,0,1,1,ALPHA,"\r\n[P]aged or [T]yped? [P] ",
          NULL) == 'T')
        grapharea = 1;
      else
        grapharea = 0;
      if(grapharea)
        DoorCLS();
      if(DoorReadText(s,(grapharea == 0)) > 0) {
        if(grapharea == 0) {
          sprintf(s,"\x1b[%d;1H",DoorGetLength());
          DoorModemPuts(s);
          DoorANSIPrintf("\x1b[%d;1H",DoorGetMaxy());
          if(!DoorInkey(18000L))
            DoorHitReturn();
        }
      }
    }
  }
  numsecs = load_sections();
  if (*secfile)
    numsecs = security();
  DoorPrintGraphics(make_ansi(PC_LIGHTGREY,PC_BLACK,NULL));
  if (numsecs == 0) {
    DoorPuts("\r\nSorry, the Library is empty.\r\n");
    DosSleep(1000L);
    return 0;
  }

  if(initialsection > 0 && initialsection < numsecs + 1)
    cursec = initialsection - 1;

  DoorPrintf("\r\n%u section%s available.\r\n",numsecs,&"s"[numsecs == 1]);

  list_zoo(cursec,0,0,NULL);

  for(;;) {
    DoorComPurgeIn();
    DoorPrintGraphics(make_ansi(PC_DARKCYAN,PC_BLACK,NULL));
    DoorPrintf("\r\nYou are in Library Section #%u",cursec + 1);
    DoorPrintGraphics(make_ansi(PC_YELLOW,PC_BLACK,NULL));
    DoorPrintf(" (%s)\r\n",section[cursec]);
    DoorPrintGraphics(make_ansi(PC_DARKCYAN,PC_BLACK,NULL));
    DoorPrintf("%u document%s available.\r\n",numfiles,&"s"[numfiles == 1]);
    if (*section[cursec] == '_') {
      if(!DoorGetGraphics()) {
        DoorRemoteBell();
        DoorPuts("WARNING!  ");
      }
      DoorPuts("ANSI Graphics are required in this section.\r\n");
    }
    DoorPrintGraphics(make_ansi(PC_LIGHTCYAN,PC_BLACK,NULL));
    if (!menus)
      printmenu();
    else
      DoorPuts("\r\n[A,B,F,H,J,L,N,P,Q,R,S,<>,?]");
    DoorPrintGraphics(make_ansi(PC_DARKCYAN,PC_BLACK,NULL));
    DoorPrintf("\r\n  %ld mins: ",DoorMinsLeft());
    DoorPrintGraphics(make_ansi(PC_LIGHTCYAN,PC_BLACK,NULL));
    command = *DoorGenericInput(1,0,1,1,ALLL,NULL,NULL);
    DoorPuts("\r\n");
    switch (command) {
      case '?':   if(menus) {
                    printmenu();
                    break;
                  }
      case 'H':   if(DoorSearchPath("LIBRARY.HLP"))
                    DoorReadText(DoorSearchPath("LIBRARY.HLP"),1);
                  else
                    DoorPuts("\r\nSorry, no help available.\r\n");
                  break;
      case 'M':   if(!maint)
                    goto Default;
                  maintenance();
                  break;
      case 'Q':   return 0;
      default:
Default:
                  if(!common(command)) {
                    DoorRemoteBell();
                    if (menus) {
                      DoorPrintGraphics(make_ansi(PC_LIGHTCYAN,PC_BLACK,NULL));
                      printmenu();
                    }
                    break;
                  }
    }
  }
}



void _fastcall printmenu (void) {

  if(libmenu)
    DoorReadText("LIBRARY.MNU",0);
  else {
    DoorPuts("\r\n[A]NSI Graphics Toggle                   [B]rowse for Keyword"
           "\r\n[F]ull List/Menu Toggles                 [H]elp w/Library  [?]Help/Full Menu"
           "\r\n[J]ump to another Section                [L]ist Documents in this Section"
           "\r\n[N]ext Section [>]                       [P]revious Section [<]"
           "\r\n[Q]uit the Library                       [R]ead a Document"
           "\r\n[S]ections in Library");
    if(maint)
      DoorPuts("                    [M]aintenance");
  }
}


void _fastcall readfile (word x,word z) {

  char          s[CCHMAXPATH];
  struct stat   st;

  DoorPuts("\r\nHold on, extracting file...");
  DoorANSIPuts("\r\n");
  sprintf(s,"ZOO eO %s %s",section[z],document[x]);
  DoorSpawn(s);
  strcpy(lastextracted,document[x]);
  DoorBackup(27);
  if (stat(document[x],&st)) {
    *lastextracted = 0;
    DoorPuts("\r\nAttempt failed.\r\n");
    return;
  }
  if(grapharea)
    DoorCLS();
  if(DoorReadText(document[x],(grapharea == 0)) > 0) {
    if(grapharea != 0) {
      sprintf(s,"\x1b[%d;1H",DoorGetLength());
      DoorModemPuts(s);
      DoorANSIPrintf("\x1b[%d;1H",DoorGetMaxy());
      if(!DoorInkey(18000L))
        DoorHitReturn();
    }
  }
  remove(document[x]);
  DoorAddToLog("LIBRARY: Read \"%s\"",document[x]);
}


word _fastcall load_sections (void) {

  DOORFINDBUF f;
  int         hDir;
  word        x = 0;
  char        toggler = 0;
  char        togchar[] = "|/-\\";

  hDir = HDIR_CREATE;
  if(!DoorFindFirst(&hDir,"*.ZOO",&f,FILE_ARCHIVED | FILE_NORMAL)) {
    do {
      if(x && !(x % 25)) {
        toggler++;
        if(toggler > 3)
          toggler = 0;
        DoorPrintf("%c\b",togchar[toggler]);
      }
      section[x] = strdup(strtok(f.achName,"."));
      if(!section[x]) {
        DoorPuts("\r\nNo memory for sections\r\n");
        exit(4);
      }
      x++;
    } while (!DoorFindNext(hDir,&f) && x < MAXSECTIONS);
    DoorFindClose(hDir);
    if(x >= 25)
      DoorPuts(" \b");
  }
  return x;
}



void _fastcall list_sections (void) {

  register word x,lines = 0;

  DoorPrintGraphics(make_ansi(PC_LIGHTBLUE,PC_BLACK,NULL));
  DoorPuts("\r\n  Available Sections:\r\n");
  for (x = 0;x<numsecs;x++) {
    DoorPrintf("%s%-5u %s%-32s",(DoorGetGraphics()) ? "\x1b[0;2;36m" : "",
            x + 1,(DoorGetGraphics()) ? "\x1b[0;1;36m" : "",section[x]);
    if (!((x + 1) % 2)) {
      DoorPuts("\r\n");
      if(++lines > DoorGetLength() - 2) {
        if (*DoorGenericInput(1,0,1,1,YESNO,"More? (Y/n) ",NULL) == 'N')
          break;
        lines = 0;
      }
    }
    else
      DoorPuts("   ");
    if (lines && DoorInkey(0L) == ' ')
      break;
  }
  if ((x + 1) % 2)
    DoorPuts("\r\n");
  if (DoorGetLength())
    if (lines > DoorGetLength() - 12)
      DoorHitReturn();
}



void _fastcall full_list (char *keyword) {

  struct stat st;
  char        ff1[CCHMAXPATH];
  char        s[CCHMAXPATH],s1[11];
  register word x,lines = 0;
  int         temp;
  char        isansi[23] = "";

  if(!keyword) {
    DoorPrintGraphics(make_ansi(PC_LIGHTBLUE,PC_BLACK,NULL));
    DoorPuts("\r\n  Available Sections:\r\n");
    DoorPrintGraphics(make_ansi(PC_YELLOW,PC_BLACK,NULL));
    DoorPuts("#     Name                               Date         Size\r\n");
    DoorPrintGraphics(make_ansi(PC_LIGHTBLUE,PC_BLACK,NULL));
    DoorPuts("----- --------------------------------   ----------   -------\r\n");
    lines = 3;
  }
  for (x = 0;x < numsecs;x++) {
    if (DoorInkey(0L) == ' ')
      break;
    sprintf(ff1,"%s.ZOO",section[x]);
    if(!stat(ff1,&st)) {
      if (*ff1 == '_')
        strcpy(isansi," \x1b[0;1;34mANSI");
      else
        *isansi = 0;
      if (DoorGetGraphics())
        sprintf(s,"%s%-5u %s%-32s   \x1b[0;2;36m%s   %-7lu%s\r\n",
                "\x1b[0;2;36m",x + 1,"\x1b[0;1;36m",section[x],
                DoorStrDate(st.st_mtime,s1),st.st_size,isansi);
      else {
        if (*isansi)
          continue;
        sprintf(s,"%-5u %-32s   %-s   %-7lu\r\n",
                x + 1,section[x],DoorStrDate(st.st_mtime,s1),st.st_size);
      }
      DoorPuts(s);
      if(++lines > DoorGetLength() - 2 && x < numsecs - 1) {
        if (*DoorGenericInput(1,0,1,1,YESNO,"More? (Y/n) ",NULL) == 'N') {
          DoorPuts("\r\n");
          break;
        }
        DoorPrintGraphics(make_ansi(PC_YELLOW,PC_BLACK,NULL));
        DoorPuts("#     Name                               Date         Size\r\n");
        DoorPrintGraphics(make_ansi(PC_LIGHTBLUE,PC_BLACK,NULL));
        DoorPuts("----- --------------------------------   ----------   -------\r\n");
        lines = 2;
      }
      temp = list_zoo(x,1,(keyword == NULL),keyword);
      if(temp < 0)
        break;
      lines += temp;
    }
  }
  if (lines > DoorGetLength() - 12)
    DoorHitReturn();
}



void _fastcall quick_list (void) {

  register word x,lines = 0;

  DoorPrintGraphics(make_ansi(PC_LIGHTBLUE,PC_BLACK,NULL));
  DoorPrintf("\r\n  Available Document%s:\r\n",&"s"[numfiles == 1]);
  for (x = 0;x < numfiles;x++) {
    DoorPrintf("%s%-5u %s%-32s",((DoorGetGraphics()) ? "\x1b[0;2;33m": ""),
            x + 1,((DoorGetGraphics()) ? "\x1b[0;1;33m" : ""),document[x]);
    if (!((x + 1) % 2)) {
      DoorPuts("\r\n");
      if(++lines > DoorGetLength() - 2) {
        if (*DoorGenericInput(1,0,1,1,YESNO,"More? (Y/n) ",NULL) == 'N')
          break;
        lines = 0;
      }
    }
    else
      DoorPuts("   ");
    if (lines && DoorInkey(0L) == ' ')
      break;
  }
  if ((x + 1) % 2) {
    lines++;
    DoorPuts("\r\n");
  }
  if (lines > DoorGetLength() -12)
    DoorHitReturn();
}


word _fastcall security (void) {

  FILE         *handle;
  char          s[81];
  register word x,z;
  int           secure,less;

  handle = DoorFsopen(secfile,"rb",SH_DENYWR);
  if(!handle) {
    DoorANSIPuts("\r\x1b[K\04Cannot open security file.");
    DosSleep(1000L);
    return 0;
  }
  while (!feof(handle) && numsecs) {
    if (!fgets(s,81,handle))
      break;
    for (x = 0;x < numsecs;x++) {
      if (!strcmp(strtok(s," "),section[x])) {
        secure = atoi(strtok(0," "));
        less = (secure < 0) ? 1 : 0;
        secure = abs(secure);
        if((!less && DoorGetSecLevel() < (word)secure) ||
           (less && DoorGetSecLevel() > (word)secure)) {
          for(z = x;z < numsecs;z++) {
            section[x] = NULL;
            if (section[x + 1]) {
              strcpy(section[x],section[x + 1]);
              section[x] = section[x + 1];
              section[x + 1] = 0;
            }
            numsecs--;
          }
        }
        break;
      }
    }
  }
  fclose(handle);
  return numsecs;
}


void _fastcall free_docs (void) {

  register word x;

  if (numfiles) {
    for (x = (numfiles - 1);x < numfiles;x--) {
      if (document[x])
        free(document[x]);
      document[x] = NULL;
    }
    numfiles = 0;
  }
}
