{$A-,I-,X+}
UNIT IOFILES;

(*--------------------------------------------------------------------------
                  (c) copyright 1988-91 Santronics Software
----------------------------------------------------------------------------*)

(*
   This unit contains routines to open single byte stream files, and
   lock and unlock file regions.
*)


interface

uses dos;

Type STREAM = file;

CONST
     _KEEP_MODE  = -1;             (* DO NOT CHANGE FILE MODE IN FOPEN *)
                                   (* share mode DOs 3++ and above *)

     _READONLY   = $00;         _DENYALL    = $10;
     _WRITEONLY  = $01;         _DENYWRITE  = $20;
     _READWRITE  = $02;         _DENYREAD   = $30;
                                _DENYNONE   = $40;

Const LockRegion   = 00;
      UnLockRegion = 01;

function fopen(
                 var fv   : stream;
                     fn   : pathstr;
                     mode : integer
              ) : integer;

function  fclose(var fv : stream) : integer;
Function  ShareLoaded : Boolean;
Function  FileLock(handle : word; action : byte; start,bytes : longint; var ax : integer): Boolean;

implementation

function fopen;
{open untyped file return the dos error code}
var fm : byte;
  begin
    assign(fv,fn);
    fm := filemode;
    if mode <> _KEEP_MODE then filemode := mode;
    reset(fv,1);
    fopen := Ioresult;
    filemode := fm;
  end;

function  fclose(var fv : stream) : integer;
  begin
   close(fv);
   fclose := ioresult;
  end;

Function ShareLoaded : Boolean;
  var reg : registers;

   begin

    reg.ax := $1000;
    Intr($2F,reg);
    ShareLoaded := ((reg.flags and $01) = 0) and (reg.al = $FF);

   end;

(*

Lock or Unlock region of file.

Input         : Handle  - turbo untype file variable handle (filerec(fv).handle)
input         : action  - action to take. See constants above;
input         : start   - beginging file position to lock.
input         : bytes   - number of bytes to lock.
output        : ax      - ax register return value

returns TRUE if lock is successful, False otherwise (check AX)

*)

Function FileLock(handle : word; action : byte; start,bytes : longint; var ax : integer): Boolean;
  var reg : registers;

   begin

    reg.ax := $5C00 + action;
    reg.bx := handle;
    reg.cx := hi(start);
    reg.dx := lo(start);
    reg.si := hi(bytes);
    reg.di := lo(bytes);

    Intr($21,reg);
    FileLock := (reg.flags and $01) = $00;
    ax := reg.ax;

   end;

end.
