/****************************************************************************/
/*                                                                          */
/*            HYPER.S V1.01 TINY LITTLE HYPERTEXT- HELP SYSTEM              */
/*                                                                          */
/*                         FOR TSE PRE RELEASE 1.0                          */
/*                                                                          */
/*                         (C) 1993 Eberhart Adam                           */
/*                                                                          */
/*                        SEE HYPER.DOC FOR DETAILS                         */
/*                                                                          */
/****************************************************************************/


constant rueck = 15                     // Count of steps one can go backwards

string token[64]						// Marked word which will be searched


//// Slightly adapted CompressView (Window width, title and so)


integer compress_hist, compress_options_history
string compress_buffer_name[] = "[<compress>]"


string proc CurrExt()
    return (SplitPath(CurrFilename(), _EXT_))
end


integer proc ListIt(string title, integer width)
    width = width + 4
    if width > Query(SCREENCOLS)
        width = Query(SCREENCOLS)
    endif
    return (List(title, width))
end


proc hCompressView(integer compress_type)
    string expr[65] = '', opts[12] = '',
           line[132]
    integer
        line_no,                // saved CurrLine() for compressed view
        list_no,                // line we exited on
        start_line_no,          // line number we were on
        goto_line_no,
        width,
        mk,
        compress_id,
        current_id = GetBufferId(), maxlen = 78

    if compress_hist == 0       // This must be first time - do initialization.
        compress_hist = GetFreeHistory()
        compress_options_history = GetFreeHistory()
        AddHistoryStr(Query(FINDOPTIONS), compress_options_history)
    endif

    start_line_no = CurrLine()
    if NumLines() == 0
        return ()
    endif

    line_no = 0
    list_no = 0
    goto_line_no = 0
    width = Length(Str(NumLines()))

    if compress_type == 0        // compress_types are [0..1]
        compress_buffer_name = "Contents"
        opts = "ix"
        case CurrExt()
            when ".hhh"
                expr = "{}"
            otherwise
                Warn("Extension not supported")
                return ()
        endcase
    elseif compress_type == 1        // compress_types are [0..1]
        compress_buffer_name = "Topics"
        opts = "ix"
        case CurrExt()
            when ".hhh"
                expr = "{}"
            otherwise
                Warn("Extension not supported")
                return ()
        endcase
    else
        compress_buffer_name = token
        opts = "ix"
        case CurrExt()
            when ".hhh"
                expr = "{"+token+"}"
            otherwise
                Warn("Extension not supported")
                return ()
        endcase
    endif

    compress_id = CreateBuffer(compress_buffer_name)
    if compress_id == 0
        compress_id = GetBufferId(compress_buffer_name)
    endif
    if compress_id == current_id
        Warn("Can't use this buffer")
        return ()
    endif
    if compress_id == 0 or not GotoBufferId(compress_id)
        return ()
    endif

    EmptyBuffer()               // At this point, we are in the compress buffer
    GotoBufferId(current_id)
    PushPosition()
    BegFile()
    if lFind(expr, opts)
        repeat
            line = GetText(1, Sizeof(line))
            line_no = CurrLine()
            if Length(line) > maxlen
                maxlen = Length(line)
            endif
            GotoBufferId(compress_id)
            if not AddLine(Format(line_no:width, ': ', line))
                break
            endif
            if goto_line_no == 1 and line_no > start_line_no
                goto_line_no = CurrLine() - 1
            endif
            GotoBufferId(current_id)
            EndLine()
        until not lRepeatFind()
    endif
    GotoBufferId(compress_id)
    GotoLine(goto_line_no)
    if ListIt(compress_buffer_name, maxlen + width)
        list_no = val(GetText(1, width))
    endif
    AbandonFile()
    PopPosition()
    if list_no
        GotoLine(list_no)
        ScrollToRow(Query(WINDOWROWS)/2)
    endif
end hCompressView



//// Now the control routine for the Help


proc hyper(string helpfile)

	string saved_wordset[32]

	integer taste                           // Actual pressed key
    integer lastx, lasty					// last cursorposition
    integer stepcount = 0					// Counting the bookmarks
    integer bufpoint = 0					// ring buffer pointer

    saved_wordset = Set(WordSet, ChrSet("0-9A-Z_a-z"))
                                            // Who does not like the german
                                            // 'Umlauts' here should delete
                                            // them, but LET THE BELL CHAR
                                            // IN (the last char)
    lastx = Query(MOUSEX)
    lasty = Query(MOUSEY)

    editfile(helpfile)
    OneWindow()
  	UpdateDisplay()                         // Only for good looking
  	hCompressView(0)
    UpdateDisplay()

  	taste = GetKey()
  	while taste <> <Escape>
  		if MouseHotSpot() <> _MOUSE_MARKING_    // As long as the help is
  	      and MouseHotSpot() < _MOUSE_VRESIZE_  // active, the user must not
  		    ProcessHotSpot()                    // split the current window
  		else
            case taste

        	when <LeftBtn>
                if (lastx <> Query(MOUSEX)      // bring the text cursor to
                  or lasty <> Query(MOUSEY))    // the position of the mouse
                    GotoMouseCursor()           // cursor
                    lastx = Query(MOUSEX)
                    lasty = Query(MOUSEY)
        		elseif MarkWord()               // "Double tick" on the marked
        			token = GetMarkedText()     // Topic
                    UnmarkBlock()
                    PlaceMark("a")
        			if Substr(token,1,1) == ""
        			  and Substr(token,2,1) <> ""
        			  and not Find(""+token,"ig")
      					Message(token+" not found")
                    else
                        UnMarkBlock()           // Store starting position
                        PushPosition()          // in the ring buffer
                    	GotoMark("a")
                        PlaceMark(chr(98+bufpoint))
                        PopPosition()
                    	bufpoint = iif(bufpoint < rueck-1, bufpoint + 1, 0)
                    	stepcount = iif(stepcount <rueck, stepcount + 1, rueck)
       				endif
       			endif

            when <Alt LeftBtn>                  // Table of contents
                PlaceMark(chr(98+bufpoint))
            	bufpoint = iif(bufpoint < rueck-1, bufpoint + 1, 0)
            	stepcount = iif(stepcount <rueck, stepcount + 1, rueck)
            	hCompressView(0)

            when <Shift LeftBtn>                // List of topics
                PlaceMark(chr(98+bufpoint))
            	bufpoint = iif(bufpoint < rueck-1, bufpoint + 1, 0)
            	stepcount = iif(stepcount <rueck, stepcount + 1, rueck)
            	hCompressView(1)

			when <RightBtn>                     // jump back
                if stepcount > 0
				    bufpoint = iif(bufpoint > 0, bufpoint -1, rueck-1)
				    stepcount = stepcount - 1
				    GotoMark(chr(98+bufpoint))
                endif

            when <Ctrl LeftBtn>                 // Copy column block
                MouseMarking(_COLUMN_)
                copy()

            when <Alt RightBtn>                 // Compress view of any marked
                if (lastx <> Query(MOUSEX)      // word ("Double tick")
                  or lasty <> Query(MOUSEY))
                    GotoMouseCursor()
                    lastx = Query(MOUSEX)
                    lasty = Query(MOUSEY)
        		elseif MarkWord()
        			token = GetMarkedText()
                    UnMarkBlock()
                    PlaceMark(chr(98+bufpoint))
                	bufpoint = iif(bufpoint < rueck-1, bufpoint + 1, 0)
                	stepcount = iif(stepcount <rueck, stepcount + 1, rueck)
                    hCompressView(2)
                endif
            endcase
        endif

        UpdateDisplay()
        taste = GetKey()
  	endwhile
    AbandonFile()
    Set(WordSet, saved_wordset)
end

<alt h> hyper("hyper.hhh")

