/************************************************************************
  Author:  SemWare (Sammy Mitchell - original idea by by Jim Susoy and
                        Howard Kapustein)
  Date:    October   1992   Initial coding
           April 10, 1993   Cleanup for public release

  Description:

  A couple of macros to give a visual display of active bookmarks.
  Note that you should not mix using the regular bookmark commands with
  these macros, as they will 'stomp' on each others bookmarks.

  Usage notes:

  To use, add these macros to your TSE.S file, and key assignments to
  your TSE.KEY file, and re-bind the editor using the -b switch of sc.

  Example key assignments might be:

  <f11>         mPlaceBookMark()
  <shift f11>   mGotoBookMark()

  !!!NOTE!!! If you do add this to your TSE.S file, remove the procedure
  ListIt from this macro, as it duplicates the ListIt found in the default
  TSE.S.

  Alternatively, add the key assignments to this file, and load the
  macro (as an external macro) as needed via the LoadMacro command
  (<ctrl f10><L> or 'menu->macro->load')
 ************************************************************************/

integer proc ListIt(string title, integer width)
    width = width + 4
    if width > Query(ScreenCols)
        width = Query(ScreenCols)
    endif
    return (List(title, width))
end

// Place a bookmark - abandon the temporary 'visual' list of bookmarks first.
proc loPlaceMark(integer i)
    AbandonFile()
    PopPosition()                       // restore position in file
    PlaceMark(Chr(Asc('a') + i - 1))
    Message("Bookmark placed")
end

// Common routine to build the 'visual' list of bookmarks.
proc mMarkSetup()
    integer i, count, tid
    string s[80]

    PushPosition()                      // save place
    tid = CreateTempBuffer()            // for showing current marks
    // Get the current marks
    count = 1
    i = 1
    while i <= 26
        if GotoMark(Chr(Asc('a') + i - 1))
            // if mark there, add it to list of marks
            s = Format(count:2, ': ',
                SplitPath(CurrFilename(), _NAME_ | _EXT_):-12, ' ',
                CurrLine():6, ' ', GetText(1, 50))
            GotoBufferId(tid)
            AddLine(s)
            count = count + 1
        endif
        i = i + 1
    endwhile
    GotoBufferId(tid)
    BegFile()
end

proc mPlaceBookMark()
    mMarkSetup()

    if NumLines() < 26
        loPlaceMark(NumLines() + 1)
    elseif ListIt("Place Bookmark", Query(ScreenCols))
        loPlaceMark(CurrLine())
    else
        AbandonFile()
        PopPosition()
    endif
end

proc mGotoBookMark()
    integer i

    mMarkSetup()
    i = 0
    if NumLines() == 0
        Warn("No Bookmarks found")
    elseif ListIt("Goto Bookmark", Query(ScreenCols))
        i = CurrLine()
    endif
    AbandonFile()                  // Delete the bookmark buffer
    if i
        KillPosition()
        GotoMark(Chr(Asc('a') + i - 1))
    else
        PopPosition()
    endif
end

