/**************************************************************************
          Ask for Input -- Sequential Questions, With Help Screens
 **************************************************************************/
forward proc                  get_input()
forward menu                  ask_menu()

integer proc                  ask_input()
     Message('TSGREP ' + v)
     options= options_entered           // options is what TSGREP will work with
     /*
          SET DEFAULTS
     */
     if sstring == ''
          sstring = 'proc-or-menu'      // :U: default!
     endif

     if options == ''
          options = 'i'
     endif

     if outfile == ''
          outfile = default_name
     endif

     if infile == 'none.$$$'
          infile = ''
     endif
ask_it:
     if ask_menu()
          if NumFiles() == 1
             AND infile == ''
             AND CurrFileName() == '++unnamed++'
               Warn('No files are loaded. Specify files.')
               goto ask_it
          endif
          return(TRUE)
     else
          return(FALSE)
     endif
     return(FALSE)
end


menu                          ask_menu()
     history
     x = 2
     y = 2
     command = get_input()
     '&Search String' [sstring : 60], ,dontclose
     '&Options'       [options : 60], ,dontclose
     'Search &Files'  [infile  : 60], ,dontclose
     '&Output File'   [outfile : 60], ,dontclose
     '', , Divide
     '&Go!', , closeallbefore
end


proc                          get_input()
    Case MenuOption()
          when 1 Message(or_operator, ' == |;  ',
                         and_operator,' == AND. (Braces are supplied by TSGREP.)')
                 Set(Y1,4)
                 Ask(Format("Search string?" : - Query(ScreenCols)),
                    sstring, sstring_hist_buff)
                 Message('TSGREP ' + v)
                 PushKey(<CursorDown>)
          when 2 Message( '^wix$', '      ',
                          no_line_numbers, '  ',        one_hit_flag, '  ',
                          dont_decode_spacechar, '  ',  dont_write_hits, '  ',
                          no_re_flag, '  ',             dont_load_outfile, '  ',
                          context_flag, 'N ',           files_only_flag
                        )
                 Set(Y1,5)
                 Ask(Format('Search options?': - Query(ScreenCols)),
                    options, options_hist_buff)
                 options_entered = options
                 Message('TSGREP ' + v)
                 PushKey(<CursorDown>)
          when 3 Message(list_file_flag, ' == list file;  ',
                         recurse_flag, ' == search subdirectories')
                 Set(Y1,6)
                 Ask(Format("File(s) OR filespec to search?  [loaded files are always searched]": - Query(ScreenCols)),
                    infile, infile_hist_buff)
                 Message('TSGREP ' + v)
                 PushKey(<CursorDown>)
          when 4
                 Set(Y1,7)
                 Ask(Format('File to create?': - Query(ScreenCols)),
                    outfile, outfile_hist_buff)
                 Message('TSGREP ' + v)
                 PushKey(<CursorDown>)
   endcase
end