/**************************************************************************
          Ask for Input -- Sequential Questions, With Help Screens
 **************************************************************************/
INTEGER proc                  ask_input()
     options = options_entered           // options is what TSGREP will work with
     if options == ''
          options = 'i'
     endif
     if outfile == ''
          outfile = default_name
     endif
     if infile == 'none.$$$'
          infile = ''
     endif

prompt1:
     PopWinOpen( 01,05, Query(ScreenCols), Query(ScreenRows), 2, '',
          Query(OtherWinBorderAttr))              // help screen
     Set(y1,1)
     WriteLine('Your search STRING may be any TSE search string. However:')
     WriteLine('  * You may use  ' + or_operator + ' instead of |.')
     WriteLine('  * You may use ' + space_char + ' instead of space.')
     WriteLine('  * You may use ' + eq_char + ' for =.')
     WriteLine('  * You may use ' + less_than + ' for <.')
     WriteLine('  * You may use ' + greater_than + ' for >.')
     WriteLine('(These are required for command line operation.)')
     WriteLine('')
     WriteLine('If ' + or_operator + ' is not surrounded by }{, TSGREP will supply the braces. So,')
     WriteLine('"menu' + or_operator + 'proc' + or_operator + 'keydef" gets turned into "{menu}|{proc}|{keydef}".')
     WriteLine('All braces you do supply are honored.')
     WriteLine('')
     WriteLine('Use '+ and_operator + ' to mean "and" in the search string. May be only used')
     WriteLine('once in the string. Order is not important; a'+ and_operator + 'b means')
     WriteLine('(a.*b) OR (b.*a) ... and that is exactly how it is implemented.')
     WriteLine('')
     WriteLine('If combining OR with AND, use braces to surround the terms')
     WriteLine('being ORd. For instance: "sort'+ and_operator + 'b{search' + or_operator + 'subtotal}".')
     if NOT
         Ask(Format("Search string?" : - Query(ScreenCols)),
               sstring, sstring_hist_buff)
          PopWinCLose()                      // help screen
          return(FALSE)
     elseif not length(sstring)
          PopWinClose()
          goto prompt1
     else
          PopWinClose()
     endif

prompt2:
     PopWinOpen( 01,05, Query(ScreenCols), Query(ScreenRows), 2, '',
          Query(OtherWinBorderAttr))              // help screen
     Set(y1,1)

     WriteLine('Files currently in the ring are always searched. Files specified at this')
     WriteLine('prompt are searched additionally. The original ring is restored after the')
     WriteLine('searches; no additional files are left loaded.')
     WriteLine('')
     WriteLine('Use ' + file_sep_char + ' as a separator for multiple files, as in "*.q' + file_sep_char + '*.inc' + file_sep_char + 'q:c*.??c".')
     WriteLine('If you use ' + file_sep_char + ' and  a filespec has no drive and path, the ones for the')
     WriteLine('preceding filespec are applied to it. For instance:')
     WriteLine('     i:\usr\*.txt' + file_sep_char + '*.doc' + file_sep_char + 'c:\*.txt' + file_sep_char + '*.doc')
     WriteLine('is processed as')
     WriteLine('     i:\usr\*.txt' + file_sep_char + 'i:\usr\*.doc' + file_sep_char + 'c:\*.txt' + file_sep_char + 'c:\*.doc')
     WriteLine('')
     WriteLine('Files with "' + list_file_flag + '" in any position of the name are treated as list files.')
     WriteLine('List files may contain specific file names, wildcarded filespecs, and')
     WriteLine('additional listfile names. Place one spec per line, starting each in ')
     WriteLine('column 1. You can use multiple list files on the command line or ')
     WriteLine('combine them with other filespecs.')
     WriteLine('')
     WriteLine('Add ' + recurse_flag + ' to the end of a filespec to have TSGREP process')
     Write    ('matching files in all subdirectories of the specified one.')

     Set(y1,1)
     if NOT
         Ask(Format("File(s) OR filespec to search?" : - Query(ScreenCols)),
               infile, infile_hist_buff)
          PopWinCLose()                      // help screen
          goto prompt1
     else
          PopWinClose()
     endif

prompt3:
     PopWinOpen( 01,05, Query(ScreenCols), Query(ScreenRows), 2, '',
          Query(OtherWinBorderAttr))              // help screen
     Set(y1,1)
     WriteLine('Options may be include any TSE search option except "b", "g" AND "+".')
     WriteLine('TSE options you can use include i x w ^ AND $.')
     WriteLine('')
     WriteLine('Default options are "i". If any of these strings are contained in the')
     WriteLine('search string, "x" is automatically added to the options unless "' + no_re_flag + '" is')
     WriteLine('is used as an option: ' + or_operator + ' .* [ '+ and_operator + '.')
     WriteLine('')
     WriteLine('Use ' + no_line_numbers + ' in options to suppress line numbers.')
     WriteLine('    ' + one_hit_flag + ' to stop searching each file after 1 hit found.')
     WriteLine('    ' + dont_decode_spacechar + ' to force reading of "' + space_char + '" in the search STRING as underscores')
     WriteLine('       rather than spaces.')
     WriteLine('    ' + dont_write_hits + ' to NOT write lines with hits to outfile; only list file names.')
     WriteLine('    ' + no_re_flag + ' to overide automatic kick in of regular expression.')
     WriteLine('    ' + dont_load_outfile + ' to not have the output file loaded.')
     WriteLine('    ' + context_flag + 'N for N lines of context, where N = 2-9.')

     Set(y1,1)
     if NOT
         Ask(Format('Search options?': - Query(ScreenCols)),
               options, options_hist_buff)
          PopWinCLose()                      // help screen
          goto prompt2
     else
          PopWinClose()
          options_entered = options
     endif

//prompt4
     PopWinOpen( 01,05, Query(ScreenCols), Query(ScreenRows), 2, '',
          Query(OtherWinBorderAttr))              // help screen
     WriteLine('Outfile is optional; the default is ' + default_name+ '.')
     Set(y1,1)
     if NOT
         Ask(Format('File to create?': - Query(ScreenCols)),
               outfile, outfile_hist_buff)
          PopWinClose()                      // help window
          goto prompt3
     else
          PopWinClose()                       // help window
          return(TRUE)
     endif
     return(TRUE)
end