/*************************************************************************
 * TFORMAT.C  											          Turbo C
 * Tim McDonough
 * June 16, 1991
 *
 * (C) Copyright 1991 by Tim McDonough. All Rights Reserved.
 * Use this program with my good wishes but at your own risk.
 *
 * Everybody has one, right?  I wanted a simple text format program that
 * did nothing more than page number files that were being sent to my
 * laser printer so when I dropped them I could get 'em back in the
 * proper order. "tformat" was born.
 *
 * This was quick and dirty but it works. If you feel the need I may be
 * reached via BIX as tmcdonough or by contacting me at:
 *
 * Cottage Resources Corporation
 * Suite 3-672, 1405 Stevenson Drive
 * Springfield, IL 62703
 * (217) 529-7679
 *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_LINE 56     /* Printable lines of text */
#define START_PAGE 2    /* Page to begin the numbering */
FILE    *f_in,          /* Pointer to the input file */
        *f_out;         /* Pointer to the output file */

char *get_filename( void );
char *convert( char *name );

/*************************************************************************/

int main( int argc, char *argv[] )
{
   int  page_num = START_PAGE,    /* current page number */
        line_count = 0;           /* # of lines printed */

   char buffer,                   /* buffer for file I/O */
        in_name[80],              /* input file name */
        out_name[80];             /* output file name */

  /*
   * Get the input filename from the user or the command line
   * and generate the output filename for the converted file.
   */

   if ( argc > 1 )
   {
      strcpy( in_name, argv[ 1 ] );
   }
   else
   {
      strcpy( in_name, get_filename() );
   }
   strcpy( out_name, convert( in_name ) );

  /*
   * Open the two files. If any errors are encountered, exit the
   * program after printing an error message.
   */

   if ( ( f_in = fopen( in_name, "r" ) ) == NULL )
   {
      printf( "\n** ERROR **  Unable to open '%s'\n", in_name );
      exit( 1 );
   }
   if ( ( f_out = fopen( out_name, "w" ) ) == NULL )
   {
      printf( "\n** ERROR **  Unable to open '%s'\n", out_name );
      fclose( f_in );
      exit( 1 );
   }

  /*
   * Read the input file and write the formatted output to the ".FORMAT"
   * file.
   */

   printf( "\nFormatting '%s'. Output file is '%s'\n\n+", in_name, out_name );
   while ( ( buffer = fgetc( f_in ) ) != EOF )
   {
     /*
      * Look for special cases where a forced page break is present or the
      * end of line is reached.
      */

      if ( ( buffer == '\n' ) || ( buffer == '\f' ) )
      {
         line_count++;
         if ( buffer != '\f' )  /* don't print embedded form feeds */
         {
            fputc( buffer, f_out );
         }

        /*
         * Print the page number after a natural page break or
         * a forced formfeed. Each time a page is processed, a
         * character is printed to the terminal to give an idea
         * of how much of the document has been processed.
         */

         if ( ( line_count == MAX_LINE - 2 ) || ( buffer == '\f' ) )
         {
            fputc( '\f', f_out );
            fputc( '\n', f_out );
            line_count = 0;
            fprintf( f_out, "[%s] Page %0d\n\n", in_name, page_num++ );
            printf( "+" );
         }
      }
      else /* it wasn't a newline or formfeed */
      {
         fputc( buffer, f_out );
      } /* if buffer equals newline or formfeed */
   } /* while not EOF... */

  /*
   * Close the open files and exit.
   */

   fclose( f_in );
   fclose( f_out );
   printf( "\nThe formatted document is %0d pages in length.", page_num - 1 );
   printf( "\n\nDone\n\n" );
   return( 1 );
}


/*************************************************************************
 * get_filename() -- prompts the user for a file name and returns a
 * pointer to the string.
 *************************************************************************/

char *get_filename( void )
{
   char buff[80]; /* Buffer to receive the filename */

   printf( "\nFile to be formatted: " );
   gets( buff );
   return( buff );
}


/*************************************************************************
 * convert() -- strips a file name of its extension and appends a new
 * extension of ".format".
 *************************************************************************/

char *convert( char *name )
{
   char buffer[80],   /* scratch buffer to hold filename */
        *p;           /* pointer to move through filename */

   p = buffer;
   strcpy( buffer, name );

   *p = toupper( *p ); /* Don't forget to convert the first character */

   while ( *p++ != '\0' )
   {
      if ( *p == '.' )
         {
            *p = '\0';
         }
      else
         {
            *p = toupper( *p );
         }
   }
   strcat( buffer, ".OUT" );
   return( buffer );
}
