# This file is an Msub script

# ABBREVIATIONS AND LETTER CASE CONVERSION
#
# You can define a single letter to stand for a regular expression:

!:l=[a-zA-Z]

# Now :l is short for any letter.  Let's define :f to be short for an
# msdos filename, with extension, and without any special characters, that
# would be some letters followed by at . and some more letters:

!:f=:l+".":l+

# That's just a definition, now we need to use it:

:f
\toupper(`)

# The above pair converts filenames to upper case. It reads "search for :f
# (which is short for :l+".":l+ which is short for [a-zA-Z]+"."[a-zA-Z]+)

# The argument of a _function_ such as tolower is enclosed in ()'s.  This
# argument is just ordinary replacement text, in this case a `.  There can
# be more, both in the argument and around the function:

"c:":f
"File name:"\toupper("the "`" file")"."

# This will convert "c:myfile.dat" to "File name:THE MYFILE.DAT FILE."

# Notice that part of "c:myfile.dat" could be matched by the first
# search-replace pair as well; searching for :f alone will certainly find
# "myfile.dat".  But here there is no ambiguity, because the second
# search-replace pair begins matching a little sooner.



# This is the end of the INTRO??.MS scripts.
# Not all MSUB features are covered.
# Those that are not covered here include:
# - sequential substitution (!newpass).
# - backup files.
# - nested scripts (script parts with local options).
# - common context (!precontext and !postcontext).
