	-------------------------------------------------------
	-- An Interactive Program to Help You Learn Euphoria --
	-------------------------------------------------------
include get.e
include graphics.e

constant NTRYS = 3
constant KEYBOARD = 0, SCREEN = 1

procedure get_answer(object correct)
    sequence answer
    atom t

    for i = 1 to NTRYS do
    	answer = get(KEYBOARD)
	puts(SCREEN, '\n')
    	if answer[1] = GET_SUCCESS then
	    if compare(answer[2], correct) = 0 then
	        puts(SCREEN, "Correct!\n\n")
		sound(2000)
		t = time()
		while time() < t+0.1 do
		end while
	 	sound(0)
	        return
 	    elsif i < NTRYS then
		puts(SCREEN, "Try again\n")
		sound(200)
		t = time()
		while time() < t+0.4 do
		end while
		sound(0)
	    end if
	else
	    puts(SCREEN, "syntax error - a Euphoria object is expected\n")
	    while getc(KEYBOARD) != '\n' do
	    end while
        end if    
    end for
    puts(SCREEN, "The correct answer was: ")
    print(SCREEN, correct)
    puts(SCREEN, '\n')
end procedure

procedure part1()
-- evaluating simple expressions
    object x, y

    puts(SCREEN, "Please evaluate the following Euphoria expressions\n")
    puts(SCREEN, "You have 3 guesses.\n\n")

    x = rand(10)
    y = rand(10)
    printf(SCREEN, "%d + %d\n", {x, y})
    get_answer(x + y)

    x = rand(repeat(10, 3))
    y = rand(10)
    print(SCREEN, x)
    puts(SCREEN, " * ")
    print(SCREEN, y)
    puts(SCREEN, '\n')
    get_answer(x * y)

    x = rand(repeat(10, 4)) - 5
    y = rand(repeat(10, 4)) - 5
    print(SCREEN, x)
    puts(SCREEN, " > ")
    print(SCREEN, y)
    puts(SCREEN, '\n')
    get_answer(x > y)    

    x = rand(20)
    y = rand(5)
    puts(SCREEN, "repeat(")
    print(1, x)
    puts(SCREEN, ", ")
    print(1, y)
    puts(SCREEN, ")\n")
    get_answer(repeat(x, y))
    
    x = rand(repeat(25, 3)) + 'a'
    y = rand(repeat(25, 2)) + 'a'
    printf(SCREEN, "\"%s\" & \"%s\"\n", {x, y})
    get_answer(x & y)

    puts(SCREEN, "append(")
    print(SCREEN, x)
    puts(SCREEN, ", ")
    print(SCREEN, y)
    puts(SCREEN, ")\n")
    get_answer(append(x, y))
    
    puts(SCREEN, "what will the value of x be\n")
    puts(SCREEN, "after executing the following statements?\n")
    puts(SCREEN, "x = ")
    x = rand({10, 10, {10, 10, 10, 10}, 20})
    print(SCREEN, x)
    y = rand({20, 20, 20, 20, 20})
    puts(SCREEN, "\ny = ")
    print(SCREEN, y)
    puts(SCREEN, "\nx[3][2..3] = y[4..5]\n")    
    x[3][2..3] = y[4..5]
    get_answer(x)
end procedure

procedure test_program(sequence file_name, object correct)
-- test a program
    integer lout
    sequence answer

    for i = 1 to NTRYS do
    	system("ed " & file_name, 0)
    	while 1 do
    	    system("del ex.err > NUL", 0)
    	    system("ex " & file_name & " > learn.out", 0)
    	    lout = open("ex.err", "r")
    	    if lout = -1 then
	    	exit
	    else
	    	close(lout)
	    	system("ed", 0)	
   	    end if
        end while
        lout = open("learn.out", "r")
    	answer = get(lout)
    	if answer[1] = GET_SUCCESS then
	    if compare(correct, answer[2]) = 0 then
	    	puts(SCREEN, "Congratulations, your program worked!\n")
	    	return
 	    end if
        end if
        puts(SCREEN, "Sorry, your program is not correct - \n")
        puts(SCREEN, 
	"your output is:           (Press Enter to continue)\n")
        system("type learn.out", 1)
	if i < NTRYS then
	    puts(SCREEN, "\nTry again ...\n")
	end if
    end for
end procedure

integer user_prog

procedure comment(sequence line)
    puts(user_prog, "-- " & line & '\n')
end procedure

procedure prog_line(sequence line)
    puts(user_prog, line & '\n')
end procedure

procedure part2a()
-- programming
    user_prog = open("work1.ex", "w")
    comment("Program #1")
    comment("You are now in the Euphoria editor.")
    comment("Write a type-function called special that will only allow")
    comment("a variable to be 3, 17, 52 or 99.")
    comment("Remember that type-functions should return non-zero (TRUE) when")
    comment("an object belongs to the type, and 0 (FALSE) when it does not.")
    comment("The loop at the bottom will call this type function to")
    comment("test it.")
    comment("When you are finished, save your program with Esc s Enter\n")

    prog_line("type special(integer x)")
    comment(" <<<complete it>>>")
    prog_line("    return ")
    prog_line("end type\n\n\n")
    comment("code to test your type ...")
    prog_line("sequence good")
    prog_line("good = {}")
    prog_line("for i = -1000 to 1000 do")
    prog_line("    if special(i) then")
    prog_line("         good = append(good, i)")
    prog_line("    end if")
    prog_line("end for")
    prog_line("? good")
    close(user_prog)
    test_program("work1.ex", {3, 17, 52, 99})
end procedure

procedure part2b()
-- programming
    sequence correct

    user_prog = open("work2.ex", "w")
    comment("Program #2")
    comment("You are now in the Euphoria editor.")
    comment("Write a program that will print a sequence")
    comment("containing the integers from 1 to 100.")
    comment("Your output should look like:")
    comment("{1, 2, 3, 4,  ..., 99, 100}")
    comment("When you are finished, save your program with Esc s Enter\n")
    close(user_prog)

    correct = {}
    for i = 1 to 100 do
	correct = append(correct, i)
    end for
    test_program("work2.ex", correct)
end procedure

procedure part2c()
-- programming
    user_prog = open("work3.ex", "w")
    comment("Program #3")
    comment("You are in the Euphoria editor.")
    comment("Complete the following program so that it will")
    comment("print any company name in the input data with a score of 100.")
    comment("The input list is a sequence of 2-element sequences like:")
    comment("{")
    comment(" {\"IBM\"      , 50},")
    comment(" {\"Microsoft\", 62},")
    comment("    ... etc ...")
    comment("}")
    comment("As you can see, the first element is the name and the second")
    comment("is the score.") 
    comment("Print the qualifying names using: puts(1, name)")
    comment("You do not need a procedure for this, just do it all in-line.")
    comment("You shouldn't have to add more than 10 lines of code.\n")
    prog_line("include get.e\n")
    prog_line("object x")
    prog_line("sequence list")
    prog_line("integer f\n")
    prog_line("f = open(\"learn.dat\", \"r\")")
    prog_line("x = get(f)")
    prog_line("list = x[2] -- the entire input list")
    prog_line("puts(1, '\"')  -- add quotes to help test verifier")
    comment("start of your code ...\n\n\n\n")
    comment("end of your code")
    prog_line("puts(1, \"\\\"\\n\")")
    prog_line("close(f)\n")
    close(user_prog)
    test_program("work3.ex < learn.dat", "Rapid Deployment Software")
end procedure

-- comment out any of these to skip them:
part1()   -- quick questions
part2a()  -- program 1
part2b()  -- program 2 
part2c()  -- program 3

