@echo off
GOTO skipH1

         Add -? or /? as first parameter for short help

         Examples for batchfiles using this file, are the other
         batch-files which are included.

  NOTE:
  -1-
        %temp% must NOT have a trailing BACKSLASH, i.e.
        for example "set temp=F:\" is NOT OK. (The root directory would
        have limitations (Dos-FAT) as regards to maximum number of files/
        directories; hence TEMP should point to a directory other than the
        root anyway. Eg. the autoexec.bat could contain
          ctty nul
          md F:\TEMP
          ctty con
          set temp=F:\TEMP
       ctty nul/con surpress a possible error message, which pops up if the
       directory f:\temp already exists.

       Other than that, one can always save the value of %temp% at the start
       of a batch-file, set a new value without a trailing backslash, and
       restore the original value at the end of the batch-file, of course.
  -2-
       This batch is called by other batch-files.
       It requires having set %doThis%

       Explanations for the SET VARIABLES:

         c.exe %1 %2 %3 %4 %5 %6 %7 %8 -c %batFile% %doThis%

       batfile= name for the batch file c.exe will create (see c.hlp)
               DEFAULT: %temp%\allcexe.bat
               ( note, this will delete a file %temp%\allcexe.bat; also,
                 to later run the %temp% default file-name rather than
                 this file %0, specify the entire path, which is obviously:
                 %temp%\allcexe.bat
               )

       doThis= command which c.exe will write into the %batFile% and which
                %batFile% will consequently run in all matching directories,
                once it is called ( see c.hlp $g >   $l <    $b |  )
               DEFAULT: NONE - i.e. MUST BE SET by the "parent" batch-file

       pathSet= IF Y, then instead of "-c %batFile%" this will be:
                                       "-cS %batFile%" (see c.hlp)
                 (sets %p% %d% path/drive in %batFile%)
               DEFAULT: Y



       ini=
           "initialisation"
           command to be run before C.EXE is run. Usually for C.EXE -i
           DEFAULT: not defined = no ini

       matchEnding=
           command to be run if there ARE matches for %1..%8 found
           DEFAULT: not defined

       endNoMatch=
           command to be run if there are NO matches for %1..%8 found
           DEFAULT: not defined



       SYSTEM VAR:

       COMSPEC=
         This is a "DOS" environment variable which points to
         the command-interpreter (entire path). It is usually set with
         the SHELL= statement in the config.sys (On a Ms-Dos 6.* system
         enter HELP, see config.sys commands info.)

    -3-
        This file provides itself with environment-memory.
       You can skip that if you like to take care of this otherwise.

:skipH1


::-------------------------------------------------------------------
::                                     RECURSION / PROVIDE ENV MEMORY
::-------------------------------------------------------------------
IF %1.=={. GOTO g
%COMSPEC% /e:2096/d/c %0 { %1 %2 %3 %4 %5 %6 %7 %8 %9
GOTO end
:g


::-------------------------------------------------------------------
::                                                doThis, batFile etc.
::-------------------------------------------------------------------
set internalID=%0

shift
::note, before the shift %1 will obviously  always be {

IF %1.==-?. GOTO help
IF %1.==/?. GOTO help


IF %pathSet%.==. set pathSet=Y
::^ Y => C.EXE should set path and directory in the batch-file it creates
::


IF %doThis%.==. echo ...%id% %internalID% ERROR: doThis= NOT SET  (-? for help)
IF %doThis%.==. GOTO end

IF %batFile%.==. set batFile=%temp%\allcexe.bat

::-------------------------------------------------------------------
::                                                                INI
::-------------------------------------------------------------------
IF %ini%.==. GOTO noIni
 echo ...%ini%
 %COMSPEC% /e:2048/c %ini%
  :: eg if "C.EXE . -i"  etc. should be run, to ensure the data-base
  :: file is up-to-date.
  IF NOT errorlevel 1 GOTO noIni
    echo ...%id% %internalID% ERROR with ini: %ini%
    GOTO end
:noIni

::
:: string the parameters - all this does is avoid  some additional
:: blanks which %1 %2 %3 %4 %5 %6 %7 %8 will have between them
:: if eg %2..%8 are not defined - you can perfectly  skip this
:: and use %1..%8 instead
set param=
:param
 set param=%param% %1
 shift
 IF NOT %1.==. GOTO param

::-------------------------------------------------------------------
::                                                              C.EXE
::-------------------------------------------------------------------
IF exist %batFile% del %batFile%


IF %pathSet%.==N. set c=c.exe %param% -c  %batFile% %doThis%
IF %pathSet%.==Y. set c=c.exe %param% -cS %batFile% %doThis%
:: %param% <-> optional: dirs would require to match this
echo ...CALLING: %c%
%c%

set param=

::%c% >nul
::^ IF in -b or -c "batch-mode", the "regular" output of C.EXE can
::  be redirected.
::
::  Eg. to obtain the number of matches in a file you can use:
::    %c% |find /v "...">$.$$$
::  which outputs only lines which do not contain "..." Hence, if the
::  errorlevel is 0, etc. (see testing below) this outputs the number
::  of matches found.
::
::  NOTE that find would however set the errorlevel. In this case you
::  can obviously not use "IF errorlevel"...
::
::  Instead you could after the above find-command write eg.
::    find "e" < $.$$$ >nul
::  and check the error level. C.EXE will write "e11" for errorlevel 11
::  etc. Hence, if C.EXE has set the errorlevel, "find "e" < $.$$$" will
::  end with errorlevel 0; errorlevel 1, if $.$$$ does not contain "e"
::  ...etc...
::
::


:skip1
::-------------------------------------------------------------------
::                                             TEST IF RUN OK etc. >>>>
::-------------------------------------------------------------------
IF NOT EXIST %batFile% GOTO noFileThere

echo ...file: %batFile%

IF errorlevel 12 GOTO errCexe
::^errorlevel is >= 12
IF NOT errorlevel 11 IF errorlevel 1 GOTO errCexe
::^errorlevel is 1..10

GOTO runOK
 :errCexe
  echo ...error with %c%
  IF NOT errorlevel 11 IF errorlevel 1 echo ...DOS Error (eg. file-io 3)
  GOTO end
:runOK

::
:: IF there aren't any matches, C.EXE will set errorlevel to 11
IF errorlevel 11 GOTO noFileThere
 ::-------------------------------------------------------------------
 ::                                                        matchEnding
 ::-------------------------------------------------------------------
 echo ...at least one match found
 IF %matchEnding%.==. GOTO end
 echo ...%matchEnding%
 %COMSPEC% /e:2048/c %matchEnding%
 IF NOT errorlevel 1 GOTO end
 echo ...%id% %internalID% ERROR with: %matchEnding%
 GOTO end


:noFileThere
 IF exist %batFile% GOTO isThere
   echo ...batFile not created: %batFile%
   echo ...eg. invalid or empty drive specified: %1 %2 %3 %4 %5 %6 %7 %8
   GOTO end
  :isThere
   ::-------------------------------------------------------------------
   ::                                                      noMatchEnding
   ::-------------------------------------------------------------------
   echo ...no match or find error, etc.
   echo ...%noMatchEnding%
   IF %noMatchEnding%.==. GOTO end
   %COMSPEC% /e:2048/c %noMatchEnding%%
   IF NOT errorlevel 1 GOTO end
   echo ...%id% %internalID% ERROR with: %noMatchEnding%
   GOTO end


::-------------------------------------------------------------------
::                                                               HELP
::-------------------------------------------------------------------
:help
 cls
 echo %id% %internalID%
 echo.
 echo Uses c.exe, creates a batch file: %%batFile%% which will run %%doThis%%
 echo in all "matching" directories. The "match" is determined by %%1...etc..
 echo This file is written to be used by other batch-files. It wasn't meant
 echo to be run on it's own. (unless all variables are set.. see this file's start)
 echo.
 echo Some reminders for writing these batch-files:
 echo Parameters given; the last parameter must match the full directory
 echo name, eg.: "%internalID% c: bak" will create a batch to run %%doThis%% in
 echo all dirs by the name "BAK" on drive C:
 echo.
 echo -No parameters: entire current drive.
 echo -Only drive as a parameter: entire specified drive.
 echo  other examples:
 echo    . F:   all dirs on drive F: from its current directory downwards
 echo    .      all dirs on current drive from current directory downwards
 echo    . bak  all dirs matching exactly BAK from the current directory
 echo           downwards
 echo.
 echo Note: batch-file names to be entered without .BAT suffix.
 echo More details at the beginning of this file  (also, see file C.HLP)

:end

::-------------------------------------------------------------------
::                                                     RESET ENV VARs
::-------------------------------------------------------------------

set batFile=
set c=
set internalID=
set pathSet=

::(Copyright) Armin Schmitt at 100552.1041@compuserve.com
::Nov-1995
::jC,951107
