(*
{ This program exercises the serial port. }
{ By C. T. Dorcey, of College Park, Md, 25/Aug/86 }
{ It seems to work. }
 program Serial;
*)
  type
    regpack = record
                ax, bx, cx, dx, bp, si, di, ds, es, flags: integer;
              end;
    short_string = string[4];
{---------------------------------------------------------------------------}
{  The DOS call version of this function habitually crashed the system, }
{  and didn't permit the full range of programming options. }
function Init_port( speed, data_bits, stop_bits : integer ): integer;
  const
    baud_clock = 1.843E6;
    num_bits: array[5..8] of byte = ($00, $01, $02, $03);
    stops : array[1..2] of byte = ($00, $04);
    DLAB = $80;
    Serial_0 = $03F8;
    Serial_1 = $03F9;
    Serial_3 = $03FB;
  var
    divider : integer;
    line_control_reg : byte;
  begin
    writeln( 'debug code');
    if (data_bits < 5) or (data_bits > 8) or
       (stop_bits < 1) or (stop_bits > 2) then
      begin
        Init_port := 0;
        Exit;
      end;
                             { first, the baud rate divider }
    divider := Round( baud_clock / 16 / speed );
    writeln( 'divider:', divider, ' ');
    Port[ Serial_3 ] := DLAB;
    Port[ Serial_0 ] := divider mod 256;
    Port[ Serial_1 ] := divider div 256;
                             { now, set the other parameters, ignoring parity }
    Port[ Serial_3 ] := num_bits[ data_bits] + stops[ stop_bits ];
                             { flag success }
    Init_port := 1;
  end;
{---------------------------------------------------------------------------}
function Send_char(out_char: char): integer;
  var
    recpack:            regpack;
    function_code:      integer;
  begin
                             {send a character out on the port}
    function_code := 1;
                             {pack ax for interrupt}
    recpack.ax := function_code shl 8 + Ord( out_char );
    recpack.dx := 0;
    Intr( $14, recpack );
    Send_char := recpack.ax;
  end;
{---------------------------------------------------------------------------}
function Receive_char: integer;
  var
    recpack:            regpack;
    function_code:      integer;
  begin
                             {receive a character from the port}
    function_code := 2;
                             {pack ax for interrupt}
    recpack.ax := function_code shl 8;
    recpack.dx := 0;
    Intr($14, recpack);
    Receive_char := recpack.ax;
  end;
{---------------------------------------------------------------------------}
function Read_status: integer;
  var
    recpack:            regpack;
    function_code:      integer;
  begin
                             {read status from the port}
    function_code := 3;
                             {pack ax for interrupt}
    recpack.ax := function_code shl 8;
    recpack.dx := 0;
    Intr($14, recpack);
    Read_status := recpack.ax;
  end;
{---------------------------------------------------------------------------}
function int_to_hex( number: integer ): short_string;
const
  h_chars : array [0..$F] of char = '0123456789ABCDEF';
var
  temp : short_string;
begin
  temp[4] := h_chars[ number and $000F ];
  temp[3] := h_chars[ (number shr  4) and $000F ];
  temp[2] := h_chars[ (number shr  8) and $000F ];
  temp[1] := h_chars[ (number shr 12) and $000F ];
  int_to_hex := temp;
end;
{---------------------------------------------------------------------------}

(*
{ and now, the Main Program, if desired for debug purposes.
  (it may be commented out to allow Inclusion of functions) }
var
  choice,trash:    integer;
begin
 ClrScr;
 repeat
  GoToXY(1, 1);
  writeln ('0. re-init port');
  writeln ('1. send character');
  writeln ('2. receive character');
  writeln ('3. sense status of port');
  writeln ('4. exit');
  read(choice);  writeln;  ClrEol;
  case choice of
    0: writeln(':', int_to_hex( Init_port( 75, 8, 1 )) );
    1: writeln(':', int_to_hex( Send_char (Chr( $41 ))) );
    2: writeln(':', int_to_hex( Receive_char ) );
    3: writeln(':', int_to_hex( Read_status ) );
  end;
 until Choice = 4;
end.
*)
     