// Names, addresses, phone numbers, and miscellaneous
// compiled with BCPP 4.51, using -mc switch for compact memory model
/*
NAMES -- An Entry Level DataBase Program
 Copyright (C) 1995 KANSYS, Inc.
 This program is free software; you can redistribute it and/or 
 modify it under the terms of the GNU General Public License as 
 published by the Free Software Foundation; either version 2 of 
 the License, or (at your option) any later version.
 This program is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of 
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 General Public License for more details.
 You should have received a copy of the GNU General Public License 
 along with this program; if not, write to the Free Software 
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 Author: Charles E. Hallenbeck, Ph.D.
 KanSys, Inc.
 4301 Wimbledon Terr. #2B
 Lawrence, KS 66047
 Telephone: 913-843-0351
*/
#define VERS "3.5"
#include <alloc.h>
#include <ctype.h>
#include <stdio.h>

#include <conio.h>
#include <dir.h>
#include <stdlib.h>
#include <string.h>
#include <bios.h>
#include <time.h>
typedef struct s1 { char *s; struct s1 *pl, *pr; } s1; 
typedef struct s3 { char m;
s1 *k, *n, *a, *b, *c, *d, *e, *s, *z, *h, *w; 
s1 *t1, *t2, *t3, *t4, *t5, *t6, *t7, *t8, *t9;
struct s3 *pl, *pr, *pp, *pn; } s3;
void editor (void);
void edithelp (void);
void trim (char *);
void deposit (s3 *);
void rebuild (void);
void dumpdata (s3 *, int);
s1 *locate1(s1 *, char *); 
s1 *install1(s1 *, s1 *); 
s3 *locate2(s3 *, char *); 
void prompt (void);
int missing (s3 *);
int prepare1 (char *, char *);
int prepare2 (void);
int prepare3 (void);
int prepare4 (void);
int mygets(char *);
int test1s1(s1 *, char *);
int bottom(void);
int right(int);
void wordleft(int, int);
void nextword(int, int);
void showline(int);
void build(FILE *);
void edithelp();
void mainhelp(char *);
void showins(int);
void showmark(int);
void center(int, char *);
void label(char *);
void label1 (s3 *, int, int, int);
void label2 (s3 *, int, int);
void output(int);
void formline(s1 *, char *);
void formcity(s3 *, char *);
int getsize(s3 *);
s3 *install2(s3 *, s3 *); 
s3 *install3(s3 *, s3 *); 
s1 *s1free(s1 *); 
s3 *s3free(s3 *); 
void delchar(int, int);
void inschar(int, int);
int menu(int);
int menu2(int);
void fields(void);
int field1(int);
int field2(int);
int field3(int);
int field4(int);
void display(s3 *);
s3 *recover(s3 *);
void dropsome(s3 *, int);
void create1(char *);
s1 *create2(char *); 
void count1(s3 *);
void count8(s3 *);
void create3(char *);
void rebuild();
void cancel(s3 *);
void mark1key(s3 *, char *);
void mark2key(s3 *, char *);
void mark1tag(s3 *, char *);
void mark2tag(s3 *, char *);
void mark1mf(s3 *);
void setmax(s3 *);
void mark1lf(s3 *);
void mark1dup(s3 *);
void mark1new(s3 *);
void mark1clr(s3 *);
void mark1rev(s3 *);
void getlist(s3 *);
void getmarks(s3 *);
void setmarks(s3 *);
void status(int, int);
void envelope(s3 *);
void outfield(FILE *, s1 *, int l);
void prompt();
char *calendar(time_t *);
FILE *fp; 
s1 *s1r; // for text strings
s3 *s3r, *s3h, *s3t; /* for records */
char l1[132], l2[132], l3[132], l4[132]; 
int new, old, mrk, svd, lbl, tag, max, lines, mod, prn;
char mx[]="Use arrow keys or Function Keys, press enter or escape";
char my[]="Warning: this demonstration copy will not \"S Save\" any data";
char mz[]="Press ENTER when ready";
long unsigned mem0, mem1;
time_t now;
void main (int argc, char **argv) {
int a, c; 
unsigned k, c1, c2;
char buf[84];
static char fn1[MAXPATH], fn2[MAXPATH], hf[MAXPATH];
struct ffblk ffblk;
char p1[MAXDRIVE], p2[MAXDIR], p3[MAXFILE], p4[MAXEXT];
if (_osmajor<3) { puts("Requires DOS 3.0 or later"); exit(0); }
strcpy(hf, *argv); strlwr (hf);
*(strrchr(hf, '.'))=0;
strcat(hf, ".hlp");
s1r=NULL; s3r=s3h=s3t=NULL;
new=old=mrk=svd=lbl=0;
mem0=coreleft();
time(&now);
clrscr(); gotoxy(14, 1);
printf("NAMES %s: Another Sound Alternative; %s", VERS, calendar(&now));
menu(0); status(0, 0);
while (--argc) { strcpy(fn1, *++argv);
if (strrchr(fn1, '.')==NULL) strcat(fn1, ".nms");
if ((fp=fopen(fn1, "r"))==NULL) 
{ sprintf(buf, "File %s not found", fn1); center(4, buf); }
else { sprintf(buf, "Loading %s", fn1); center(4, buf);
build(fp); fclose(fp); } }
do { do { for (c1=6; c1<26; c1++) { gotoxy(1, c1); clreol(); }
prompt(); k=bioskey(0); c1=k%256; c2=k/256;
if (!c1) switch(c2) {
case 75: menu((c=menu(-1))==1? 9: --c); break;
case 77: menu((c=menu(-1))==9? 1: ++c); break;
default: break; }
else { if (c1==13) c1=menu(-1); switch(tolower(c1)) {
case 'h': menu(1); /* H Help */
case 1: mainhelp(hf);
clrscr(); gotoxy(14, 1);
cprintf("NAMES %s: Another Sound Alternative; %s", VERS, calendar(&now));
menu(0); status(0, 0); center(4, "Exit from Help"); break;
case 'l': menu(2); /* L Load */
case 2: center(4, "Load what file?"); gotoxy(4, 2);
if (!mygets(fn1) && *fn1)
{ if (strrchr(fn1, '.')==NULL) strcat(fn1, ".nms");
c=findfirst(fn1, &ffblk, 0);
if (c) { sprintf(buf, "File %s not found", fn1); center(4, buf); }
while (!c) { fnsplit(fn1, p1, p2, p3, p4);
fnmerge(fn2, p1, p2, NULL, NULL);
strcat(fn2, ffblk.ff_name);
if ((fp=fopen(fn2, "r"))!=NULL)
{ sprintf(buf, "Loading %s", fn2); center(4, buf);
build(fp); fclose(fp); }
c=findnext(&ffblk); } }
else center(4, "Cancel loading"); break;
case 'e': menu(3); /* E Edit */
case 3: editor(); center(4, "Exit from edit"); menu(0); break;
case 'f': menu(4); /* F Find */
case 4: field2(0); do { switch((a=prepare2())) {
case 1: center(4, "Enter the specific key"); gotoxy(3, 2);
if (!mygets(buf) && *buf)
{ trim(buf); strupr(buf); mark1key(s3r, buf); } break;
case 2: center(4, "Enter the key pattern"); gotoxy(3, 2);
if (!mygets(buf) && *buf)
{ trim(buf); strupr(buf); mark2key(s3r, buf); } break;
case 3: center(4, "Enter the specific tag"); gotoxy(3, 2);
if (!mygets(buf) && *buf)
{ trim(buf); strupr(buf); mark1tag(s3r, buf); } break;
case 4: center(4, "Enter the tag pattern"); gotoxy(3, 2);
if (!mygets(buf) && *buf)
{ trim(buf); strupr(buf); mark2tag(s3r, buf); } break;
case 5: mark1mf(s3r); break;
case 6: max=mrk=0; setmax(s3r); mark1lf(s3r); 
status(4, mrk); sprintf(buf, "Longest field is %d", max);
center(4, buf); break;
case 7: mark1dup(s3r); break;
case 8: mark1new(s3r); break;
case 9: mark1clr(s3r); break;
case 10: mark1rev(s3r); break;
default: break; }
mrk=0;
count1(s3r);
status(4, mrk); }
while(a!=27); center(4, "Exit from find"); break;
case 'd': menu(5); /* D Drop */
case 5: switch(prepare3()) {
case 1: center(4, "Dropping all items");
s1r=s1free(s1r); s3r=s3free(s3r); 
s1r=NULL; s3r=s3h=s3t=NULL;
new=old=0; break;
case 2: center(4, "Dropping marked items");
dropsome(s3r, 1); rebuild(); break;
case 3: center(4, "Dropping unmarked items");
dropsome(s3r, 0); rebuild(); break;
default: break; }
status(1, new);
status(2, old);
status(4, mrk);
mem1=coreleft();
status(7, (mem0-mem1)/1024);
status(8, mem1/1024l); center(4, "Exit from drop"); break;
case 'm': menu(6); /* M Mail */
case 6: if (s3r==NULL) center(4, "No labels to write");
else { center(4, "Write labels to what file? (PRN=printer)");
gotoxy(3, 2); if (!mygets(fn1) && *fn1) label(fn1); } break;
case 's': menu(7); /* S Save */
case 7: if (s3r==NULL) center(4, "No data to save");
else { center(4, "Save data to what file?"); gotoxy(3, 2);
if (!mygets(fn1) && *fn1) { a=prepare1(fn1, ".nms");
if (0<a && a<27) { sprintf(buf, "Saving %s", fn1);
center(4, buf);
svd=0;
dumpdata(s3r, a); 
center(4, "Data saved");
status(6, svd);
if (fp!=NULL) fclose(fp); } }
a=0; } break; /* end of S Save */
case 'z': menu(8); /* Z Zoom */
case 8: center(4, "Enter the zoom pattern"); gotoxy(3, 2);
if (!mygets(buf) && *buf)
{ trim(buf); strupr(buf); mark1clr(s3r); mark2key(s3r, buf);
mrk=0; count1(s3r);
status(4, mrk); if (mrk) editor(); } break;
case 'q': case 27: a=menu(9); c1=9; /* Q Quit */
case 9: mod=0; count8(s3r); break; 
default: center(4, 
"Press letter, left arrow, right arrow, or press ENTER to select");
break; } } }
while(c1!=9);
if (mod) center(4,
"Changes have not been saved: Exit from NAMES anyway? Type Y for yes");
else center(4, "Exit from NAMES? Type Y for Yes"); gotoxy(4, 2); }
while(tolower(bioskey(0)%256)!='y');
clrscr();
center(3, "For Sound Alternatives in Software");
center(5, "KANSYS, Inc.");
center(6, "4301 Wimbledon Terr. #2B");
center(7, "Lawrence, KS 66047");
center(9, "Telephone: 913-843-0351"); }
/***/void center(int a, char *c) {
gotoxy(1, a); clreol();
gotoxy(41-strlen(c)/2, a); printf("%s", c); }
/***/int prepare1(char *fn, char *ext) {
static int b;
static unsigned k, c2;
static char buf[84];
strlwr(fn); prn=0; if (!strcmp(fn, "prn")) { prn=1; fp=stdprn; }
else { if (strrchr(fn, '.')==NULL) strcat(fn, ext);
if ((fp=fopen(fn, "r"))==NULL)
sprintf(buf, "File %s does not exist: type Y to create it", fn);
else sprintf(buf, "File %s already exists: type Y to over write it", fn);
center(4, buf); prompt();
if (tolower(bioskey(0)%256)!='y') return (0); 
if (!(fp==NULL)) fclose(fp);
if (strcmp(ext, ".nms") && (fp=fopen(fn, "w"))==NULL)
{ sprintf(buf, "Cannot create file %s", fn);
center(4, buf); return (0); } }
field1(0); showline(9); center(4, mz);
while(1) { gotoxy(13, field1(-1)+8);
k=bioskey(0); c2=k/256;
switch(k%256) { case 0: switch(c2) {
case 59: case 60: case 61: field1(c2-58);
showline(c2-50); center(4, mz); break;
case 72: b=field1(-1); field1(b==1? 3: --b); break;
case 80: b=field1(-1); field1(b==3? 1: ++b); break;
default: c2=0; break; } break;
case 13: return(field1(-1));
case 27: return(27);
default: c2=0; break; }
if (!c2) center(4, mx); }
return(0); }
/***/int prepare2(void) {
static int b;
static unsigned k, c2;
field2(1); showline(9); center(4, mz);
while(1) { gotoxy(13, field2(-1)+8);
k=bioskey(0); c2=k/256;
switch(k%256) { case 0: switch(c2) {
case 59: case 60: case 61: case 62: case 63: case 64: case 65:
case 66: case 67: case 68: field2(c2-58);
showline(c2-50); center(4, mz); break;
case 72: b=field2(-1); field2(b==1? 10: --b); break;
case 80: b=field2(-1); field2(b==10? 1: ++b); break;
default: c2=0; break; } break;
case 13: return(field2(-1));
case 27: return(27);
default: c2=0; break; }
if (!c2) center(4, mx); }
return(0); }
/***/int prepare3(void) {
static int b;
static unsigned k, c2;
field3(0); showline(9); center(4, mz);
while(1) { gotoxy(13, field3(-1)+8);
k=bioskey(0); c2=k/256;
switch(k%256) { case 0: switch(c2) {
case 59: case 60: case 61: field3(c2-58);
showline(c2-50); center(4, mz); break;
case 72: b=field3(-1); field3(b==1? 3: --b); break;
case 80: b=field3(-1); field3(b==3? 1: ++b); break;
default: c2=0; break; } break;
case 13: return(field3(-1));
case 27: return(27);
default: c2=0; break; }
if (!c2) center(4, mx); }
return(0); }
/***/int prepare4(void) {
static int b;
static unsigned k, c2;
center(4, mz); while(1) { gotoxy(13, field4(-1)+8);
k=bioskey(0); c2=k/256;
switch(k%256) { case 0: switch(c2) {
case 59: case 60: case 61: case 62: case 63:
case 64: case 65: field4(c2-58);
showline(c2-50); center(4, mz); break;
case 72: b=field4(-1); field4(b==1? 7: --b); break;
case 80: b=field4(-1); field4(b==7? 1: ++b); break;
default: c2=0; break; } break;
case 13: return(field4(-1));
case 27: return(27);
default: c2=0; break; }
if (!c2) center(4, mx); }
return(0); }
/***/void dumpdata(s3 *r, int a) {
if (r==NULL) return; if (r->k!=NULL)
if (a==1 || (a==2 && r->m&1) || (a==3 && !r->m&1))
if (*(r->k->s))
{ svd++; outfield(fp, r->k, '*');
outfield(fp, r->d, 'D'); outfield(fp, r->e, 'E'); 
outfield(fp, r->n, 'N'); 
outfield(fp, r->a, 'A'); outfield(fp, r->b, 'B'); 
outfield(fp, r->c, 'C'); outfield(fp, r->s, 'S'); 
outfield(fp, r->z, 'Z'); outfield(fp, r->h, 'H'); 
outfield(fp, r->w, 'W'); outfield(fp, r->t1, 'T'); 
outfield(fp, r->t2, 'T'); outfield(fp, r->t3, 'T'); 
outfield(fp, r->t4, 'T'); outfield(fp, r->t5, 'T'); 
outfield(fp, r->t6, 'T'); outfield(fp, r->t7, 'T'); 
outfield(fp, r->t8, 'T'); outfield(fp, r->t9, 'T'); }
if (r->m&8) r->m^=8; dumpdata(r->pl, a); dumpdata(r->pr, a); }
/***/void outfield(FILE *fp, s1 *p, int l) {
if (p!=NULL) fprintf(fp, "%c:%s\n", l, p->s);
else if (l=='D' || l=='E') fprintf(fp, "%c:%s", l, calendar(&now)); }
/***/void label(char *fn) {
static int a, b;
static unsigned c1;
static char buf[84];
if ((a=prepare1(fn, ".lbl"))>0) { field4(0); showline(9);
if ((b=prepare4())>0)
{ if (prn) do { center(4, "Prepare printer and press ENTER or press ESCAPE");
gotoxy(3, 2); c1=bioskey(0)%256; } while (c1!=13 && c1!=27);
else { sprintf(buf, "Writing labels to %s", fn);
center(4, buf); c1=13; }
if (c1==13) { s3h=s3t=NULL; deposit(s3r);
for (s3r=NULL; s3h!=NULL; s3h=s3h->pn) s3r=install3(s3r, s3h); 
lbl=lines=0; label1(s3r, a, b, 0);
output(1); rebuild();
center(4, "Labels written");
status(5, lbl); } }
if (!prn) fclose(fp); } }
/***/void deposit(s3 *r) {
if (r==NULL) return; deposit(r->pr); deposit(r->pl);
if (r->k!=NULL) { r->pn=s3h; s3h=r; r->pl=r->pr=NULL; }
else { free(r); } }
/***/void label1(s3 *r, int a, int b, int c) {
static int d; 
if (r==NULL) return;
if (!c) d=0; label1(r->pl, a, b, c+1); 
if ((a==1 || (a==2 && r->m&1) || (a==3 && !r->m&1)) &&
(b!=4 || getsize(r)<26) && (b!=5 || getsize(r)<36) &&
!missing(r)) label2(r, b, d++);
label1(r->pr, a, b, c+1); }
/***/void label2(s3 *r, int b, int c) {
static int a;
lbl++; switch (b) {
case 1: for (a=0; a<131; a++)
*(l1+a)=*(l2+a)=*(l3+a)=*(l4+a)=32; 
*(l1+131)=*(l2+131)=*(l3+131)=*(l4+131)=0;
formline(r->n, l1); if (r->a!=NULL) formline(r->a, l2);
if (r->b!=NULL) { formline(r->b, l3); formcity(r, l4); }
else formcity(r, l3); output(0); break;
case 2: case 3: if (!(c%2)) { for (a=0; a<131; a++)
*(l1+a)=*(l2+a)=*(l3+a)=*(l4+a)=32; 
*(l1+131)=*(l2+131)=*(l3+131)=*(l4+131)=0; a=0; }
else a=(b==2? 40: 54);
formline(r->n, l1+a); if (r->a!=NULL) formline(r->a, l2+a);
if (r->b!=NULL) { formline(r->b, l3+a); formcity(r, l4+a); }
else formcity(r, l3+a);
if (c%2) output(0); break;
case 4: case 5: switch (c%3) {
case 0: for (a=0; a<131; a++)
*(l1+a)=*(l2+a)=*(l3+a)=*(l4+a)=32; 
*(l1+131)=*(l2+131)=*(l3+131)=*(l4+131)=0; a=0; break;
case 1: a=(b==4? 28: 35); break;
case 2: a=(b==4? 55: 70); break; }
formline(r->n, l1+a); if (r->a!=NULL) formline(r->a, l2+a);
if (r->b!=NULL) { formline(r->b, l3+a); formcity(r, l4+a); }
else formcity(r, l3+a);
if ((c%3)==2) output(0); break;
case 7: if (prn) fprintf(stdprn, "\r\n[%s]", r->k->s);
else fprintf(fp, "\n[%s]", r->k->s);
case 6: if (prn) fprintf(stdprn, "\r\n%s\r\n%s\r\n", r->n->s, r->a->s);
else fprintf(fp, "\n%s\n%s\n", r->n->s, r->a->s);
if (r->b!=NULL) if (prn) fprintf(stdprn, "%s\r\n", r->b->s);
else fprintf(fp, "%s\n", r->b->s);
if (prn) fprintf(stdprn, "%s, %s %s\r\n", r->c->s, r->s->s, r->z->s);
else fprintf(fp, "%s, %s %s\n", r->c->s, r->s->s, r->z->s);
if (r->h!=NULL) if (prn) fprintf(stdprn, "Home: %s\r\n", r->h->s);
else  fprintf(fp, "Home: %s\n", r->h->s);
if (r->w!=NULL) if (prn) fprintf(stdprn, "Work: %s\r\n", r->w->s);
else fprintf(fp, "Work: %s\n", r->w->s);
if (b==7) { if (r->t1!=NULL)
if (prn) fprintf(stdprn, "(%s)\r\n", r->t1->s);
else fprintf(fp, "(%s)\n", r->t1->s);
if (r->t2!=NULL)
if (prn) fprintf(stdprn, "(%s)\r\n", r->t2->s);
else fprintf(fp, "(%s)\n", r->t2->s);
if (r->t3!=NULL)
if (prn) fprintf(stdprn, "(%s)\r\n", r->t3->s);
else fprintf(fp, "(%s)\n", r->t3->s);
if (r->t4!=NULL)
if (prn) fprintf(stdprn, "(%s)\r\n", r->t4->s);
else fprintf(fp, "(%s)\n", r->t4->s);
if (r->t5!=NULL)
if (prn) fprintf(stdprn, "(%s)\r\n", r->t5->s);
else fprintf(fp, "(%s)\n", r->t5->s);
if (r->t6!=NULL)
if (prn) fprintf(stdprn, "(%s)\r\n", r->t6->s);
else fprintf(fp, "(%s)\n", r->t6->s);
if (r->t7!=NULL)
if (prn) fprintf(stdprn, "(%s)\r\n", r->t7->s);
else fprintf(fp, "(%s)\n", r->t7->s);
if (r->t8!=NULL)
if (prn) fprintf(stdprn, "(%s)\r\n", r->t8->s);
else fprintf(fp, "(%s)\n", r->t8->s);
if (r->t9!=NULL)
if (prn) fprintf(stdprn, "(%s)\r\n", r->t9->s);
else fprintf(fp, "(%s)\n", r->t9->s); } break; } }
/***/void formline(s1 *b, char *c) {
static char *a;
for (a=b->s; *a; c++, a++) *c=*a; }
/***/void formcity(s3 *r, char *l) {
static char *a;
for (a=r->c->s; *a; l++, a++) *l=*a; 
*l++=','; l++; 
for (a=r->s->s; *a; l++, a++) *l=*a; 
l++;
for (a=r->z->s; *a; l++, a++) *l=*a; }
/***/void output(int b) {
trim(l1); trim(l2); trim(l3); trim(l4); 
if (prn) fprintf(stdprn, "\r\n%s\r\n%s\r\n%s\r\n%s\r\n\r\n", l1, l2, l3, l4); 
else fprintf(fp, "\n%s\n%s\n%s\n%s\n\n", l1, l2, l3, l4); 
strcpy(l1, " "); strcpy(l2, " "); strcpy(l3, " "); 
strcpy(l4, " "); lines+=6;
if (b) while (lines%66)
{ if (prn) fprintf(stdprn, "\r\n"); else putc('\n', fp); lines++; } }
/***/void trim(char *s) {
while (*s) s++; while (*(s-1)==32) *--s=0; }
/***/void build(FILE *fp) {
char *a, buf[84];
int n;
s3 *p; 
n=0; while (fgets(buf, 80, fp)!=NULL) { // read from file
if (feof (fp)) break;
a=strchr(buf, '\n'); if (a!=NULL) *a=0;
if (coreleft()<512l) { center(4, "Out of memory!"); break; }
if (*(buf+1)==':') { // valid input
for (a=buf+2; *a==' '; a++);
switch (*buf) {
case '*': create3(a); p=locate2(s3r, a); old++; break; 
case 'n': case 'N': p->n=create2(a); break; 
case 'a': case 'A': p->a=create2(a); break; 
case 'b': case 'B': p->b=create2(a); break; 
case 'c': case 'C': p->c=create2(a); break; 
case 'd': case 'D': p->d=create2(a); break; 
case 'e': case 'E': p->e=create2(a); break; 
case 's': case 'S': p->s=create2(a); break; 
case 'z': case 'Z': p->z=create2(a); break; 
case 'h': case 'H': p->h=create2(a); break; 
case 'w': case 'W': p->w=create2(a); break; 
case 't': case 'T': strupr(a);
if (p->t1==NULL) p->t1=create2(a);
else if (p->t2==NULL) p->t2=create2(a);
else if (p->t3==NULL) p->t3=create2(a);
else if (p->t4==NULL) p->t4=create2(a);
else if (p->t5==NULL) p->t5=create2(a);
else if (p->t6==NULL) p->t6=create2(a);
else if (p->t7==NULL) p->t7=create2(a);
else if (p->t8==NULL) p->t8=create2(a);
else if (p->t9==NULL) p->t9=create2(a); break;
default: if (!n) center(4, "Errors found reading data:");
if (++n<20) { gotoxy(1, n+6); clreol();
cprintf("%s", buf); } } }
else { // not valid input
if (!n) center(4, "Errors found reading data:");
if (++n<20) { gotoxy(1, n+6); clreol();
cprintf("%s", buf); } }
buf[0]=0; }
status(2, old);
mem1=coreleft(); status(7, (mem0-mem1)/1024);
status(8, mem1/1024l); }
/***/s1 *locate1(s1 *r, char *s) {
static int a; 
while (*s==' ') s++; 
if (r!=NULL) { a=strcmp(r->s, s); 
if (a<0) r=locate1(r->pr, s); 
else if (a>0) r=locate1(r->pl, s); } return (r); }
/***/s1 *install1(s1 *r, s1 *x) {
static int a; 
if (r==NULL) { r=x; r->pl=r->pr=NULL; }
else { a=strcmp(r->s, x->s); if (a<0) r->pr=install1(r->pr, x); 
else if (a>0) r->pl=install1(r->pl, x); } return (r); }
/***/void create1(char *s) {
static s1 *p; 
while (*s==' ') s++; if (locate1(s1r, s)==NULL)
{ p=(s1 *)malloc(sizeof(s1));
p->s=(char *)malloc(strlen(s)+1); 
strcpy(p->s, s); s1r=install1(s1r, p); } }
/***/s3 *locate2(s3 *r, char *s) {
static int a; 
while (*s==' ') s++; strupr(s); 
if (r!=NULL) { a=strcmp(r->k->s, s); 
if (a<0) r=locate2(r->pr, s); 
else if (a>0) r=locate2(r->pl, s); } return (r); }
/***/s3 *install2(s3 *r, s3 *x) {
if (r==NULL) { r=x; r->pl=r->pr=NULL; }
else if (strcmp(r->k->s, x->k->s)<0) r->pr=install2(r->pr, x); 
else r->pl=install2(r->pl, x); return (r); }
/***/s3 *install3(s3 *r, s3 *x) {
if (r==NULL) { r=x; r->pl=r->pr=NULL; }
else if (strcmp(r->z->s, x->z->s)<0) r->pr=install3(r->pr, x); 
else r->pl=install3(r->pl, x); return (r); }
/***/void create3(char *s) {
static s3 *p; 
while (*s==' ') s++; strupr(s); 
while (locate2(s3r, s)!=NULL) strcat(s, "$");
p=(s3 *)malloc(sizeof(s3)); p->d=p->e=NULL;
p->n=p->a=p->b=NULL;
p->c=p->s=p->z=NULL;
p->h=p->w=NULL; 
p->t1=p->t2=p->t3=NULL;
p->t4=p->t5=p->t6=NULL;
p->t7=p->t8=p->t9=NULL;
p->pl=p->pr=p->pp=p->pn=NULL;
create1(s); p->k=locate1(s1r, s); 
while(*s) s++; p->m=(*--s=='$'? 4: 0);
 s3r=install2(s3r, p); }
/***/void cancel(s3 *r) {
if (r==NULL) return; r->pp=r->pn=NULL;
cancel(r->pl); cancel(r->pr); }
/***/void mark1key(s3 *r, char *buf) {
static char *a, *b;
if (r==NULL) return; mark1key(r->pr, buf); 
for (a=buf, b=r->k->s; *a && *b; a++, b++) if (*a!=*b) break; 
if (*a==*b) r->m|=1; mark1key(r->pl, buf); }
/***/void mark2key(s3 *r, char *buf) {
static char *a, *b;
if (r==NULL) return; mark2key(r->pr, buf); 
for (a=buf, b=r->k->s; *a && *b; a++, b++) if (*a!=*b) break; 
if (!*a) r->m|=1; mark2key(r->pl, buf); }
/***/void mark1tag(s3 *r, char *buf) {
static char *a, *b;
if (r==NULL) return; mark1tag(r->pr, buf); 
if (r->t1!=NULL)
{ for (a=buf, b=r->t1->s; *a && *b; a++, b++) if (*a!=*b) break;
if (*a==*b) r->m|=1; }
if (r->t2!=NULL)
{ for (a=buf, b=r->t2->s; *a && *b; a++, b++) if (*a!=*b) break;
if (*a==*b) r->m|=1; }
if (r->t3!=NULL)
{ for (a=buf, b=r->t3->s; *a && *b; a++, b++) if (*a!=*b) break;
if (*a==*b) r->m|=1; }
if (r->t4!=NULL)
{ for (a=buf, b=r->t4->s; *a && *b; a++, b++) if (*a!=*b) break;
if (*a==*b) r->m|=1; }
if (r->t5!=NULL)
{ for (a=buf, b=r->t5->s; *a && *b; a++, b++) if (*a!=*b) break;
if (*a==*b) r->m|=1; }
if (r->t6!=NULL)
{ for (a=buf, b=r->t6->s; *a && *b; a++, b++) if (*a!=*b) break;
if (*a==*b) r->m|=1; }
if (r->t7!=NULL)
{ for (a=buf, b=r->t7->s; *a && *b; a++, b++) if (*a!=*b) break;
if (*a==*b) r->m|=1; }
if (r->t8!=NULL)
{ for (a=buf, b=r->t8->s; *a && *b; a++, b++) if (*a!=*b) break;
if (*a==*b) r->m|=1; }
if (r->t9!=NULL)
{ for (a=buf, b=r->t9->s; *a && *b; a++, b++) if (*a!=*b) break;
if (*a==*b) r->m|=1; }
mark1tag(r->pl, buf); }
/***/void mark2tag(s3 *r, char *buf) {
static char *a, *b;
if (r==NULL) return; mark2tag(r->pr, buf); 
if (r->t1!=NULL)
{ for (a=buf, b=r->t1->s; *a && *b; a++, b++) if (*a!=*b) break;
if (!*a) r->m|=1; }
if (r->t2!=NULL)
{ for (a=buf, b=r->t2->s; *a && *b; a++, b++) if (*a!=*b) break;
if (!*a) r->m|=1; }
if (r->t3!=NULL)
{ for (a=buf, b=r->t3->s; *a && *b; a++, b++) if (*a!=*b) break;
if (!*a) r->m|=1; }
if (r->t4!=NULL)
{ for (a=buf, b=r->t4->s; *a && *b; a++, b++) if (*a!=*b) break;
if (!*a) r->m|=1; }
if (r->t5!=NULL)
{ for (a=buf, b=r->t5->s; *a && *b; a++, b++) if (*a!=*b) break;
if (!*a) r->m|=1; }
if (r->t6!=NULL)
{ for (a=buf, b=r->t6->s; *a && *b; a++, b++) if (*a!=*b) break;
if (!*a) r->m|=1; }
if (r->t7!=NULL)
{ for (a=buf, b=r->t7->s; *a && *b; a++, b++) if (*a!=*b) break;
if (!*a) r->m|=1; }
if (r->t8!=NULL)
{ for (a=buf, b=r->t8->s; *a && *b; a++, b++) if (*a!=*b) break;
if (!*a) r->m|=1; }
if (r->t9!=NULL)
{ for (a=buf, b=r->t9->s; *a && *b; a++, b++) if (*a!=*b) break;
if (!*a) r->m|=1; }
mark2tag(r->pl, buf); }
/***/void mark1mf(s3 *r) {
if (r==NULL) return; mark1mf(r->pr); 
if (missing(r)) r->m|=1; mark1mf(r->pl); }
/***/void setmax(s3 *r) {
if (r==NULL) return; setmax(r->pr);
if (max<getsize(r)) max=getsize(r); setmax(r->pl); }
/***/void mark1lf(s3 *r) {
if (r==NULL) return; mark1lf(r->pr); 
if (getsize(r)==max) r->m|=1; mark1lf(r->pl); }
/***/void mark1dup(s3 *r) {
static char *a;
if (r==NULL) return; mark1dup(r->pr); 
for (a=r->k->s; *a; a++); if (*--a=='$') r->m|=1;
mark1dup(r->pl); }
/***/void mark1new(s3 *r) {
if (r==NULL) return; mark1new(r->pr); 
if (r->m&2) r->m|=1; mark1new(r->pl); }
/***/void mark1clr(s3 *r) {
if (r==NULL) return; mark1clr(r->pr); 
if (r->m&1) r->m^=1; mark1clr(r->pl); }
/***/void mark1rev(s3 *r) {
if (r==NULL) return; mark1rev(r->pr); 
r->m^=1; mark1rev(r->pl); }
/***/void count1(s3 *r) {
if (r==NULL) return; if (r->m&1) mrk++;
count1(r->pr); count1(r->pl); }
/***/void count8(s3 *r) {
if (r==NULL) return; if (r->m&8) mod++;
count8(r->pr); count8(r->pl); }
/***/int test1s1(s1 *p, char *s) {
if (p==NULL) return (*s? 1: 0); 
return ((p==locate1(s1r, s))? 0: 1); }
/***/s1 *create2(char *s) {
if (!*s) return (NULL); 
create1(s); return (locate1(s1r, s)); }
/***/s1 *s1free(s1 *r) {
if (r==NULL) return (r); 
r->pl=s1free(r->pl); r->pr=s1free(r->pr); 
if (r->s!=NULL) free(r->s); free(r); return (NULL); }
/***/s3 *s3free(s3 *r) {
if (r==NULL) return (r); 
r->pl=s3free(r->pl); r->pr=s3free(r->pr); 
free(r); return (NULL); }
/***/int mygets(char *s) {
static int a, b, c, r;
static char *t;
r=wherey();
b=c=wherex();
*(t=s)=0;
while((a=getche())!=13) { switch(a) {
case 27: *t=0; if (b==c) return(1);
gotoxy(c=b, r); clreol(); break;
case 26: if (b==c) return(3); break;
case 0: if (b==c) return(2); break;
case 8: if (b==c) break;
gotoxy(--c, r);
clreol(); *--s=0; break;
default: *s=a; *(s+1)=0;
gotoxy(c++, r); printf("%s", ++s);
gotoxy(c, r); } }
return(0); }
/***/int menu(int a) {
static char *m[]={"H Help", "L Load", "E Edit", "F Find",
"D Drop", "M Mail", "S Save", "Z Zoom", "Q Quit" };
static int old=-1, max=sizeof(m)/sizeof(char *);
if (a<0) return(old);
if (!a) { for (a=2; a<26; a++) /* clear screen */
{ gotoxy(1, a); if (a!=5) clreol(); }
for (a=0; a<max; a++)
{ gotoxy(a*9+2, 3); cprintf("%s", m[a]); }
a=old=1; }
gotoxy(old*9-7, 3); cprintf("%s", m[old-1]);
directvideo=0; highvideo();
gotoxy(a*9-7, 3); cprintf("%s", m[a-1]);
directvideo=1; lowvideo(); return(old=a); }
/***/int field1(int a) {
static int b;
static char *h="** Function Keys And method of selecting Items **";
static char *m[]={"F1 Select all items regardless of marks",
"F2 Select marked items only",
"F3 Select unmarked items only" };
static int old=-1, max = sizeof(m) / sizeof(char *);
if (a<0) return(old);
if (!a) { for (a=4; a<26; a++) { if (a==5) continue;
gotoxy(1, a); clreol(); }
center(7, h);
for (b=0; b<max; b++)
{ gotoxy(13, b+9); cprintf("%s", m[b]); } old=a=1; }
else { gotoxy(10, old+8); cprintf("%c ", 32); }
gotoxy(10, a+8); cprintf("->"); return(old=a); }
/***/int field2(int a) {
static int b;
static char *h="** Function Keys And method of finding Items **";
static char *m[]={"F1 Find and mark a specific key",
"F2 Find and mark a key pattern",
"F3 Find and mark a specific tag",
"F4 Find and mark a tag pattern",
"F5 Find and mark items with missing fields",
"F6 Find and mark items with longest fields",
"F7 Find and mark items with $ keys",
"F8 Find and mark new items",
"F9 Clear marks from all items",
"F10 Mark all unmarked items and unmark all marked ones" };
static int old=-1, max = sizeof(m) / sizeof(char *);
if (a<0) return(old);
if (!a) { for (a=4; a<26; a++) { if (a==5) continue;
gotoxy(1, a); clreol(); }
center(7, h);
for (b=0; b<max; b++)
{ gotoxy(13, b+9); cprintf("%s", m[b]); } old=a=1; }
else { gotoxy(10, old+8); cprintf("%c ", 32); }
gotoxy(10, a+8); cprintf("->"); return(old=a); }
/***/int field3(int a       ) {
static int b;
static char *h="** Function Keys And Items To Drop **";
static char *m[]={"F1 Drop all items regardless of marks",
"F2 Drop marked items only",
"F3 Drop unmarked items only" };
static int old=-1, max = sizeof(m) / sizeof(char *);
if (a<0) return(old);
if (!a) { for (a=4; a<26; a++) { if (a==5) continue;
gotoxy(1, a); clreol(); }
center(7, h);
for (b=0; b<max; b++)
{ gotoxy(13, b+9); cprintf("%s", m[b]); } old=a=1; }
else { gotoxy(10, old+8); cprintf("%c ", 32); }
gotoxy(10, a+8); cprintf("->"); return(old=a); }
/***/int field4(int a       ) {
static int b;
static char *h="** Function Keys And Mailing Formats";
static char *m[]={"F1 One across by 11 down starting at left margin",
"F2 Two across by 11 down on 8.5 inch paper",
"F3 Two across by 11 down on 11 inch paper",
"F4 Three across by 11 down on 8.5 inch paper",
"F5 Three across by 11 down on 11 inch paper",
"F6 Continuous listing with phone numbers",
"F7 Continuous listing with keys, tags, and phone numbers" };
static int old=-1, max = sizeof(m) / sizeof(char *);
if (a<0) return(old);
if (!a) { for (a=4; a<26; a++) { if (a==5) continue;
gotoxy(1, a); clreol(); }
center(7, h);
for (b=0; b<max; b++)
{ gotoxy(13, b+9); cprintf("%s", m[b]); } old=a=1; }
else { gotoxy(10, old+8); cprintf("%c ", 32); }
gotoxy(10, a+8); cprintf("->"); return(old=a); }
/***/void prompt(void) {
gotoxy(1, 2); printf("->");
clreol(); gotoxy(4, 2);
putchar(0); gotoxy(4, 2); }
/***/void status(int a, int b) {
static char *m[]={"New", "Old", "Sum", "Mrk", "Lbl", "Svd",
"Mem", "Rem" };
static int old[]={0,0,0,0,0,0,0,0};
if (!a) { gotoxy(1, 5); clreol();
old[7]=coreleft()/1024l;
for (a=0; a<8; a++) /* put labels on screen */
{ gotoxy(a*10+2, 5); cprintf("%s=%d%c", m[a], old[a], a<6? 32: 'K'); } }
else if (old[a-1]!=b) { gotoxy(a*10-4, 5);
cprintf("%c%c%c%c", 32, 32, 32, 32);
gotoxy(a*10-8, 5); directvideo=0;
cprintf("%s=%d%c", m[a-1], (old[a-1]=b), (a<7? 32: 'K'));
if (a<3) { old[2]=old[1]+old[0];
gotoxy(26, 5); directvideo=1;
cprintf("%c%c%c%c", 32, 32, 32, 32);
gotoxy(22, 5); directvideo=0;
cprintf("%s=%d", m[2], old[2]); } directvideo=1; } }
/***/void getmarks(s3 *r) {
if (r==NULL) return; getmarks(r->pr); 
if (r->m&1) { r->pn=s3h; s3h=r; if (r->pn==NULL) s3t=r;
else r->pn->pp=r; r->pp=NULL; } getmarks(r->pl); }
/***/void setmarks(s3 *r) {
if (r==NULL) return; r->m|=1;
setmarks(r->pl); setmarks(r->pr); }
/***/int missing(s3 *p) {
if (p->n==NULL || p->c==NULL || p->s==NULL || p->z==NULL)
return(1);
if (*(p->n->s)==0 || *(p->c->s)==0) return(1);
if (*(p->s->s)==0 || *(p->z->s)==0) return(1); return(0); }
/***/int getsize(s3 *p) {
static int a, b;
a=(p->n==NULL? 0: strlen(p->n->s));
b=(p->a==NULL? 0: strlen(p->a->s)); if (a<b) a=b;
b=(p->b==NULL? 0: strlen(p->b->s)); if (a<b) a=b;
b=3+(p->c==NULL? 0: strlen(p->c->s))+
(p->s==NULL? 0: strlen(p->s->s))+
(p->z==NULL? 0: strlen(p->z->s)); return(a<b? b: a); }
/***/void rebuild(void) {
s3h=s3t=NULL; deposit(s3r); 
for (s3r=NULL; s3h!=NULL; s3h=s3h->pn) s3r=install2(s3r, s3h); }
/***/void dropsome(s3 *r, int m) {
if (r==NULL) return; if ((r->m&1)==m) { r->k=NULL;
if (r->m&2) new--; else old--; if (r->m&1) mrk--; }
dropsome(r->pl, m); dropsome(r->pr, m); }
/***/void editor(void) {
static unsigned k, c1, c2;
static int home, end, chg, ins, x, y;
static s3 *p;
home=end=chg=0; s3h=s3t=NULL;
cancel(s3r); getlist(s3r);
menu2(0); showins(ins=1); fields(); p=NULL;
if (mrk) do { p=(p==NULL? s3h: p->pn); }
while (p!=NULL && !(p->m&1)); display(p);
do { k=bioskey(0); c1=k%256; c2=k/256; x=wherex(); y=wherey();
if (!c1) { if (c2!=71) home=0; if (c2!=79) end=0; switch(c2) {
case 15: if (x>18 && y>7) { showline(--y); gotoxy(19, y); } break;
case 59: edithelp();
center(4, "End of Edit Help"); gotoxy(x, y); break;
case 60: if (chg) p=recover(p);
if (p!=NULL) { p->m^=1; status(4, (p->m&1? ++mrk: --mrk));
showmark(p->m&1); } gotoxy(x, y); chg=0; break;
case 61: if (mrk) { if (chg) p=recover(p); chg=0;
do { p=(p==NULL? s3t: p->pp); } while (p!=NULL && !(p->m&1));
display(p); } break;
case 62: if (mrk) { if (chg) p=recover(p); chg=0;
do { p=(p==NULL? s3h: p->pn); } while (p!=NULL && !(p->m&1));
display(p); } break;
case 63: p=recover(p); chg=0;
if (p!=NULL) { center(4, "Drop this item? Press Y for Yes");
prompt(); if (tolower(bioskey(0)%256)=='y')
{ p->k=NULL; if (p->m&1) status(4, --mrk);
if (p->m&2) status(1, --new); else status(2, --old);
p=p->pn; rebuild(); s3h=s3t=NULL; cancel(s3r); getlist(s3r);
display(p); } } break;
case 64: if (chg) p=recover(p); if (p!=NULL) envelope(p);
chg=0; menu2(0); showins(ins); gotoxy(x, y); break;
case 65: display(p); chg=0; break;
case 71: switch(++home) {
case 1: if (y<7) showline(y=7); gotoxy(19, y); break;
case 2: showline(7); gotoxy(19, 7); break;
case 3: if (chg) recover(p);
display(p=NULL); chg=0; break;
default: break; } break;
case 72: if (y>1) gotoxy(x, --y); break;
case 73: if (chg) p=recover(p);
display(p=(p==NULL? s3t: p->pp)); chg=0; break;
case 75: if (x>1) gotoxy(--x, y); break;
case 77: if (x<80) gotoxy(++x, y); break;
case 79: switch(++end) {
case 1: if (y<7) y=7; x=right(y); gotoxy(x, y); break;
case 2: y=bottom(); x=right(y); showline(y); gotoxy(x, y); break;
default: break; } break;
case 80: if (y<25) gotoxy(x, ++y); break;
case 81: if (chg) p=recover(p);
display(p=(p==NULL? s3h: p->pn)); chg=0; break;
case 82: ins^=1;  showins(ins); gotoxy(x, y); break;
case 83: if (x>18 && y>6) { delchar(x, y); chg=1; } break;
case 115: wordleft(x, y); x=wherex(); y=wherey(); break;
case 116: nextword(x, y); x=wherex(); y=wherey(); break;
default: break; } }
else { home=end=0; switch(c1) { /* ASCII chars */
case 8: if (x>19 && y>6) { gotoxy(--x, y); delchar(x, y); chg=1; } break;
case 9: if (x>18 && y>6 && y<25) { showline(++y); gotoxy(19, y); } break;
case 13: if (x>18 && y>6)
{ clreol(); showline(y<25? ++y: y); gotoxy(x=19, y); chg=1; } break;
case 27: if (chg) recover(p); break;
default: if (c1>31 && x>18 && y>6 && x<80 && y<26)
{ if (ins) inschar(x, y); putchar(c1); chg=1; } break; } } }
while (c1!=27); }
/***/void getlist(s3 *r) {
if (r==NULL) return; getlist(r->pr); 
r->pn=s3h; s3h=r; if (r->pn==NULL) s3t=r;
else r->pn->pp=r; r->pp=NULL; getlist(r->pl); }
/***/void display(s3 *p) {
static int a;
gotoxy(1, 4); clreol();
for (a=7; a<26; a++) { gotoxy(19, a); clreol(); }
time(&now); gotoxy(19, 7);
if (p==NULL) cprintf("%s", calendar(&now));
else cprintf ("%s", (p->d==NULL? calendar(&now): p->d->s));
gotoxy(19, 8); if (p==NULL) cprintf("%s", calendar(&now));
else cprintf ("%s", (p->e==NULL? calendar(&now): p->e->s));
if (p==NULL) { showmark(0); showline(9); gotoxy(19, 9); return; }
if (p->k!=NULL) { gotoxy(19, 9); printf ("%s", p->k->s); }
if (p->n!=NULL) { gotoxy(19, 10); printf ("%s", p->n->s); }
if (p->a!=NULL) { gotoxy(19, 11); printf ("%s", p->a->s); }
if (p->b!=NULL) { gotoxy(19, 12); printf ("%s", p->b->s); }
gotoxy(19, 13); if (p->c!=NULL) printf ("%s", p->c->s);
if (p->s!=NULL) printf(", %s", p->s->s);
if (p->z!=NULL) { gotoxy(19, 14); cprintf ("%s", p->z->s); }
if (p->h!=NULL) { gotoxy(19, 15); cprintf ("%s", p->h->s); }
if (p->w!=NULL) { gotoxy(19, 16); cprintf ("%s", p->w->s); }
if (p->t1!=NULL) { gotoxy(19, 17); cprintf ("%s", p->t1->s); }
if (p->t2!=NULL) { gotoxy(19, 18); cprintf ("%s", p->t2->s); }
if (p->t3!=NULL) { gotoxy(19, 19); cprintf ("%s", p->t3->s); }
if (p->t4!=NULL) { gotoxy(19, 20); cprintf ("%s", p->t4->s); }
if (p->t5!=NULL) { gotoxy(19, 21); cprintf ("%s", p->t5->s); }
if (p->t6!=NULL) { gotoxy(19, 22); cprintf ("%s", p->t6->s); }
if (p->t7!=NULL) { gotoxy(19, 23); cprintf ("%s", p->t7->s); }
if (p->t8!=NULL) { gotoxy(19, 24); cprintf ("%s", p->t8->s); }
if (p->t9!=NULL) { gotoxy(19, 25); cprintf ("%s", p->t9->s); }
showmark(p->m&1); gotoxy(19, 7); }
/***/s3 *recover(s3 *p) {
static int a, a1, a2[64], x, y;
static char *b, *b1, b2[64];
static s3 *s;
gettext(19, 9, 80, 9, a2); /* key field on screen */
for (a=0, b=b2; a<62; a++, b++) *b=a2[a]%256; *b=0;
while (*(b-1) && *(b-1)<33) *--b=0; /* drop trailing blanks */
for (b=b2; *b && *b<33; b++); /* drop leading blanks */
if (!*b) return(p); strupr(b); s=locate2(s3r, b);
if (s!=NULL && s!=p) { x=wherex(); y=wherey();
center(4, "This key already exists: type Y to update its fields");
prompt(); if (tolower(bioskey(0)%256)=='y') p=s;
gotoxy(1, 4); clreol(); gotoxy(x, y); }
if (p==NULL || p!=s) { create3(b); p=locate2(s3r, b);
s3h=s3t=NULL; cancel(s3r);
getlist(s3r); status(1, ++new); p->m|=2; }
for (a1=7; a1<26; a1++) { if (a1==9) continue;
if (a1==8) { strcpy(b=b2, calendar(&now)); while(*b) b++; }
else { gettext(19, a1, 80, a1, a2); /* other fields on screen */
for (a=0, b=b2; a<62; a++, b++) *b=a2[a]%256; *b=0; }
while (*(b-1) && *(b-1)<33) *--b=0; /* drop trailing blanks */
for (b=b2; *b && *b<33; b++); /* drop leading blanks */
if (a1>16) strupr(b);
switch (a1) { /* lines 7-25 */
case 7: p->d=create2(b); break;
case 8: p->e=create2(b); break;
case 10: p->n=create2(b); break;
case 11: p->a=create2(b); break;
case 12: p->b=create2(b); break;
case 13: b1=strrchr(b2, ',');
if (b1!=NULL) { *b1++=0; while(*b1==' ') b1++; }
p->s=(b1==NULL? NULL: create2(b1));
p->c=create2(b); break;
case 14: p->z=create2(b); break;
case 15: p->h=create2(b); break;
case 16: p->w=create2(b); break;
case 17: p->t1=create2(b); break;
case 18: p->t2=create2(b); break;
case 19: p->t3=create2(b); break;
case 20: p->t4=create2(b); break;
case 21: p->t5=create2(b); break;
case 22: p->t6=create2(b); break;
case 23: p->t7=create2(b); break;
case 24: p->t8=create2(b); break;
case 25:  p->t9=create2(b); break; 
default: break; } }
p->m|=8; return(p); }
/***/void delchar(int x, int y) {
static int b[64];
if (x==80) putchar(' ');
else { gettext(x+1, y, 80, y, b); puttext(x, y, 79, y, b); } }
/***/void inschar(int x, int y) {
static int b[64];
if (x<80) { gettext(x, y, 79, y, b); puttext(x+1, y, 80, y, b); } }
/***/int menu2(int a) {
static char *m[]={"F1 Help", "F2 Mark", "F3 Last", "F4 Next",
"F5 Drop", "F6 Type", "F7 Undo" };
static int old=-1, max=sizeof(m)/sizeof(char *);
if (a<0) return(old);
if (!a) { for (a=2; a<5; a++) /* clear screen */
{ gotoxy(1, a); clreol(); }
for (a=0; a<max; a++)
{ gotoxy(a*9+2, 3); cprintf("%s", m[a]); }
a=old=1; }
gotoxy(old*9-7, 3); cprintf("%s", m[old-1]);
directvideo=0; highvideo();
gotoxy(a*9-7, 3); cprintf("%s", m[a-1]);
directvideo=1; lowvideo(); return(old=a); }
/***/void fields(void) {
static char *m[]={"Created",
"Changed",
"Key",
"Name",
"Address",
"Address",
"City, State",
"ZIP, Postal Code",
"Home phone",
"Work phone",
"Tag #1",
"Tag #2",
"Tag #3",
"Tag #4",
"Tag #5",
"Tag #6",
"Tag #7",
"Tag #8",
"Tag #9" };
static int a;
for (a=6; a<26; a++) /* clear lower screen */
{ gotoxy(1, a); clreol(); }
for (a=7; a<26; a++) /* make row labels */
{ gotoxy(1, a); cprintf("%s:", m[a-7]); }
gotoxy(19, 7); }
/***/void edithelp(void) {
static char *m[] = { /* edit help messages */
"Press spacebar for help with edit keys, or press escape",
"F1 Gets this list of edit help messages",
"F2 Marks an unmarked screen or unmarks one that is marked",
"F3 Jumps to the previous marked display screen if any",
"F4 Jumps to the following marked display screen if any",
"F5 Drops the display screen from memory",
"F6 Types the displayed name and address directly on an envelope",
"F7 Cancels any changes and refreshes the current screen",
"PAGE UP: Goes to the previous display screen if any",
"PAGE DOWN: Goes to the following display screen if any",
"ARROW KEYS: Moves the cursor anywhere on the screen",
"Screen lines 1 to 6 and columns 1 to 18 are write protected areas",
"Data may be entered only on screen lines 7 to 25 columns 19 to 80",
"CONTROL LEFT ARROW: Moves left one word",
"CONTROL RIGHT ARROW: Moves right one word",
"INS: Switches between Insert and Overstrike editor modes",
"BACKSPACE: Deletes the character to the left of the cursor position",
"DEL: Deletes the character at the cursor position",
"HOME: Goes to the left edge of the current entry field",
"HOME HOME: Goes to the left edge of the first entry field on the screen",
"HOME HOME HOME: Goes to the 'KEY' field of a blank entry screen",
"END: Goes to the right edge of the current entry field",
"END END: Goes just below the last used entry field on the screen",
"ENTER: Advances one field after clearing the rest of the current line",
"TAB: Advances one field without changing the current line",
"SHIFT TAB: Goes back one field without changing the current line",
"ESCAPE: Exits from the Editor and goes back to the Main Menu",
"CTRL-ALT-DEL: The ultimate act of desparation and frustration!" };
static int a, b, max=sizeof(m)/sizeof(char *);
for (a=0; a<max; a++) { center(4, m[a]);
do { b=bioskey(0)%256; if (b==27) return; } while(b!=32); } }
/***/void mainhelp(char *fn) {
static FILE *fp;
static int a, b, sn, nl, nm, np;
static char c[84], *p;
static char *m1="Cannot find help file %s\n";
static char *m2="N=Next screen, P=Previous screen, Q=Quit, S# =  screen #";
if ((fp=fopen(fn, "r"))==NULL)
{ sprintf(c, m1, fn); center(4, c); return; }
for (nm=0; fgets(c, 82, fp)!=NULL; nm++);
strcpy(c, "s1");
a='s';
do { switch(a) {
case 's': case 'p': fclose(fp); fp=fopen(fn, "r");
if (a=='s') { sn=1; sscanf(c+1, "%d", &sn);
np=(sn<2? 0: 24*--sn); }
else if (np) np-=24;
for (nl=0; nl<np; nl++) fgets(c, 82, fp);
case 'n': clrscr();
for (np=nl, b=0; b<24 && nl<nm; b++, nl++)
{ fgets(c, 82, fp);
if ((p=strchr(c, '\n'))!=NULL) *p=NULL; puts(c); } break;
default: puts(m2); break; }
printf("N,P,Q,S#: ");
gets(c); a=tolower(*c); }
while (a!='q'); fclose(fp); }
/***/void envelope(s3 *p) {
static int a, b;
static char buf[84];
do { center(4, "Prepare printer and press ENTER or press ESCAPE");
prompt(); if ((a=bioskey(0)%256)==27) return;
if (a!=13) continue;
{ for (b=0; b<80; b++) *(buf+b)=32;
formline(p->n, buf+40);
*(buf+79)=0; trim(buf);
fprintf(stdprn, "\r\n\r\n%s\r\n", buf);
for (b=40; b<80; b++) *(buf+b)=32;
if (p->a!=NULL) formline(p->a, buf+40); *(buf+79)=0; trim(buf);
fprintf(stdprn, "%s\r\n", buf);
for (b=40; b<80; b++) *(buf+b)=32;
if (p->b!=NULL) { formline(p->b, buf+40); *(buf+79)=0; trim(buf);
fprintf(stdprn, "%s\r\n", buf);
for (b=40; b<80; b++) *(buf+b)=32; }
formcity(p, buf+40); *(buf+79)=0; trim(buf);
fprintf(stdprn, "%s\r\n\x0c", buf); } }
while(a!=13); }
/***/void showins(int m) {
gotoxy(74, 3); printf("%s %s", "Ins", (m? "on ": "off")); }
/***/void showmark(int m) {
gotoxy(65, 3); printf("%s %s", "Mark", (m? "on ": "off")); }
/***/int bottom(void) {
static int a;
for (a=25; a>6; a--) if (right(a)!=19) break;
return(a<25? a+1: a); }
/***/int right(int y) {
static int a, b;
for (a=80; a>18; a--) { gettext(a, y, a, y, &b);
if ((b%=256)!=32) break; }
return(a<80? a+1: a); }
/***/void wordleft(int x, int y) {
static int a;
while(1) { if (!--x) { x=80; if (!--y) return; }
gettext(x, y, x, y, &a); if (a%256!=32) break; }
while(1) { if (!--x) break; gettext(x, y, x, y, &a);
if (a%256==32) break; }
gotoxy(++x, y); }
/***/void nextword(int x, int y) {
static int a;
while(1) { gettext(x, y, x, y, &a); if (a%256==32) break;
x%=80; x++; if (x==1) y++; if (y>25) return; }
while(1) { gettext(x, y, x, y, &a); if (a%256!=32) break;
x%=80; x++; if (x==1) y++; if (y>25) return; }
gotoxy(x, y); }
/***/void showline(int y) {
static char b[82];
static int x, a;
for (x=0; x<80; x++) { gettext(x+1, y, x+1, y, &a); b[x]=a%256; }
b[x=80]=0;  while(--x) if (b[x]==32) b[x]=0; else break;
gotoxy(1, y); printf("%s", b); }
/***/char *calendar(time_t *t) {
static char s[25];
strcpy (s, ctime(t)); strcpy (s+11, s+20); return (s); }


