TARGET=XMSNETX.EXE

LIST
	print "DISABLE KEYBOARD RESET PATCH\n\n"
	print "This patch resolves a problem unique to the NetWare shell v3.26 where the\n"
	print "keyboard will be reset if you send a message to yourself.\n"

VERIFY
	va = search (B0 FF E6 60 checksum 2f5 )
	if (va) then
		print "\n"
		print "$TARGET needs to be patched (has 'out' instruction at offset ",va,").\n"
	else
		print "\n"
		print "$TARGET does not have the instruction which causes the problem.\n\n"
		print "Could not find the requested pattern in $TARGET.  The shell is either\n"
		print "already patched or is the wrong version.  This patch needs to be applied\n"
		print "only to version 3.26 (920319) of the NetWare DOS shell.\n"
	stop
	endif

APPLY
	print "\n"
	print "Applying send error patch from XMSXKB.PAT to $TARGET. \n"
	vb = search (B0 FF E6 60 checksum 2f5)
	if (vb) then
		patch vb (90 90 90 90 checksum 240)
		write
		print "\n"
		print "$TARGET has been patched and will no longer reset keyboard!\n"
		stop
	endif
