{$I COPYRGHT.INC}

(*---------------------------------------------------------------------------*
   This unit contains the nice line-editor
 *---------------------------------------------------------------------------*)

Unit NiceLine;
Interface
Uses Dos,
     Bin_DB,
     Header,
     Multi,
     KeyDefs,
     MyIO,
     Timer;

Const BufferSize = $10;

Type Status = (Ready_Status,TimeOut_Status);


Function LineEditor(     Prompt : String;
                     Var Line   : String;
                         MaxLen : Byte;
                         Time   : Word):Status;


Implementation

Procedure Cursor_On;
Var regs : Registers;
Begin
Regs.Ah:=$01;
Regs.Ch:=$06;
Regs.Cl:=$07;
Intr($10,Regs);
End;

Procedure Cursor_Off;
Var regs : Registers;
Begin
Regs.Ah:=$01;
Regs.Ch:=$16;
Regs.Cl:=$0;
Intr($10,Regs);
End;

Procedure Cursor_Half;
Var regs : Registers;
Begin
Regs.Ah:=$01;
Regs.Ch:=$04;
Regs.Cl:=$07;
Intr($10,Regs);
End;

Type KeyBoardBuffer = Array[0..BufferSize-1] of String[80];

Var  KBBuf    : KeyBoardBuffer;
     KBPtr    : Byte;
     OldKB    : Byte;


Var Cursor      : Byte;
    Ins         : Boolean;
    Continue    : Boolean;

Function LineEditor(     Prompt : String;
                     Var Line   : String;
                         MaxLen : Byte;
                         Time   : Word):Status;

Var Len         : Byte;
    Stop        : Boolean;
    GotKey      : Boolean;
    Key         : Char;
    Ext         : Boolean;
    OldCursor   : Byte;
    TimeOut     : TimerObject;

Procedure Show(Prompt,Line : String; Cursor,MaxLen : Byte);
Var MemX : Byte;
Begin
Cursor_Off;
If Length(Line)>MaxLen
   Then Line[0]:=Chr(MaxLen);

My_Write(#13+Prompt);
MemX:=My_WhereX-1;
My_Write(Line);

My_ClrEol;
My_GotoXy(MemX+Cursor,My_WhereY);
If Ins
   Then Cursor_On
   Else Cursor_Half;
End;


Begin
If Not Continue
   Then Begin
        Cursor:=1;
        Ins:=True;
        End;
Continue:=False;
Len:=Length(Line);
Stop:=False;
OldKB:=KBPtr;
If Time=0
   Then Time:=MaxInt;
TimeOut.SetTimer(Time);

Repeat
  Show(Prompt,Line,Cursor,MaxLen);
  Repeat
   Ext:=True;
   GotKey:=False;
   If My_KeyPressed
      Then Begin
           Key:=My_ReadKey;
           If Key=#00
              Then Key:=My_ReadKey
              Else Ext:=False;
           GotKey:=True;
           End;
    If TimeOut.TimeUp
       Then Begin
            LineEditor:=TimeOut_Status;
            Continue:=True;
            Exit;
            End;
  Until GotKey;

  Case Ext Of
    False : Begin
            Case Key Of
             #13 : Begin
                   LineEditor:=Ready_Status;
                   Stop:=True;
                   KBPtr:=OldKB;
                   KBBuf[KBPtr]:=Line;
                   KBPtr:=(KbPtr+1) Mod BufferSize;
                   End;
             ^Y,
             #27 : Begin
                   Line:='';
                   Cursor:=1;
                   Len:=0;
                   End;
             #8  : Begin
                   If Cursor>1
                      Then Begin
                           Delete(Line,Cursor-1,1);
                           Dec(Cursor);
                           End;

                   End;
             Else  Begin
                   If Length(Line)<MaxLen
                      Then Begin
                           If Cursor>Length(Line)
                              Then Line:=Line+Key
                              Else Begin
                                   If Ins
                                      Then Insert(Key,Line,Cursor)
                                      Else Line[Cursor]:=Key;
                                   End;
                           Inc(Cursor);
                           End;
                   End;
            End; {Case}
            End;

    True  : Begin
            Case Key Of
             InsK     : Ins:=Not Ins;
             DelK     : Begin
                        If Cursor<Length(Line)
                           Then Delete(Line,Cursor,1);
                        End;
             EndK     : Cursor:=Length(Line)+1;
             HomeK    : Cursor:=1;
             CEndK    : Line[0]:=Chr(Cursor-1);
             F3       : Begin
                        KBPtr:=(OldKB+(BufferSize-1)) Mod BufferSize;
                        Line:=KBBuf[KBPtr];
                        Cursor:=Length(Line)+1;
                        End;
             ArrUp    : Begin
                        KBPtr:=(KBPtr+(BufferSize-1)) Mod BufferSize;
                        Line:=KBBuf[KBPtr];
                        Cursor:=Length(Line)+1;
                        End;
             ArrDn    : Begin
                        KBPtr:=(KBPtr+1) Mod BufferSize;
                        Line:=KBBuf[KBPtr];
                        Cursor:=Length(Line)+1;
                        End;
             ArrLft   : If Cursor>1 Then Dec(Cursor);
             ArrRt    : If Cursor<(Length(Line)+1) Then Inc(Cursor);
             CArrLft  : Begin
                        If Cursor>1
                           Then Begin
                                Dec(Cursor);
                                While (Cursor>1) And (Line[Cursor-1]<>' ') Do
                                  Dec(Cursor);
                                End;
                        End;
             CArrRt   : Begin
                        If Cursor<Length(Line)
                           Then Begin
                                Inc(Cursor);
                                While (Cursor<(Length(Line)+1)) And (Line[Cursor-1]<>' ') Do
                                  Inc(Cursor);
                                End;
                        End;
            End;
            End;
  End; {Case}
Until Stop;
Show(Prompt,Line,Cursor,MaxLen);
My_WriteLn('');
Cursor_On;
End;

Begin
Fillchar(KBBuf,SizeOf(KBBuf),#00);
KBPtr:=0;
OldKB:=0;
Cursor:=0;
Continue:=False;
Ins:=True;
End.
