{$I COPYRGHT.INC}

(*---------------------------------------------------------------------------*
  Routines which are used during debugging.
 *---------------------------------------------------------------------------*)

Unit Debug_do;
Interface
Uses BIN_DB,
     MyIO,
     Misc,
     Multi,
     LowLevel,
     Header,
     Norm_do;

(*---------------------------------------------------------------------------*
  Show the contents of a record. Can search on name or n #<number>
 *---------------------------------------------------------------------------*)
Procedure DEBUG_ShowRecord(Current : ContextType; InpStr : String);

(*---------------------------------------------------------------------------*
  Fix a record which is messed up for whatever reason.
 *---------------------------------------------------------------------------*)
Procedure DEBUG_Fix(Current : ContextType; InpStr : String);

Implementation

Procedure DEBUG_Fix(Current : ContextType; InpStr : String);
Var ObjNr : Integer;
Begin
ObjNr:=Str2ObjNr(Current,InpStr);
If ObjNr=NOTHING
   Then Begin
        My_WriteLn('Sorry, item is not here.');
        Exit;
        End;
Current.DB.ReadObj(ObjNr);
My_WriteLn('Name: '+Current.DB.ObjRec.Name);
If My_YesNo('Sure? ','N')='N'
   Then Exit;

Lock('Fixing Object');
Current.DB.ReadObj(ObjNr);
With Current.DB.ObjRec Do
 Begin
 Next:=Nothing;
 ObjType  :=Thing_Type;;
 Owner    :=Current.Player;
 Location :=Current.Player;
 Exits    :=Current.Player;
 Attr_Flags:=0;
 Room_Flags:=0;
 GenFlags :=0;
 End;
Current.DB.UpdateObj(ObjNr);
MoveTo(ObjNr,Current.Player);
UnLock;
End;

Procedure DEBUG_ShowRecord(Current : ContextType; InpStr : String);
Var ObjNr : Integer;
    Err   : Integer;
Begin
If InpStr=''
   Then Exit;

ObjNr:=Str2ObjNr(Current,InpStr);
If (ObjNr>=FileSize(Current.DB.ObjFile)) Or
   (ObjNr=NOTHING)
   Then begin
        My_WriteLn('Sorry, record doesn''t exist');
        Exit;
        End;

Current.DB.ReadObj(ObjNr);
Current.DB.WriteRecord;
End;

End.
