{$I COPYRGHT.INC}

(*---------------------------------------------------------------------------*
   This unit contains all the routines nessecary to create a new world
 *---------------------------------------------------------------------------*)

Unit NewWorld;
interface
Uses Dos,
     MyIO,
     Misc,
     Header;

Procedure CreateNewWorld(Name : ComStr);

Implementation

Procedure CleanRecord(Var Rec: ObjRecord);
Begin
FillChar(Rec,SizeOf(Rec),#00);
With Rec Do
 Begin
 Name       :='';
 Password   :='';
 Key        :='';
 Location   :=-1;
 Contents   :=-1;
 Exits      :=-1;
 Next       :=-1;
 Owner      :=-1;
 Garbage    :=-1;
 End;
End;


Procedure CreateNewWorld(Name : ComStr);
Var Rec : ObjRecord;
    Out : File of ObjRecord;
    Ply : File of Integer;
    Nr  : Integer;
    Ini : Text;
    Tmp : File;
Begin
  If Pos('.',Name)>0
     Then Name:=Copy(Name,1,Pos('.',Name));

  Assign(Out,Name+'.IDX');
  Rewrite(Out);
  If IoResult<>0
     Then Begin
          My_WriteLn('Cannot create IDX file.');
          Halt;
          End;

  CleanRecord(Rec);
  With Rec Do
   Begin
   Name     := 'Eden';
   Password := '';
   Key      := '';
   Location := -1;
   Exits    := -1;
   Next     := -1;
   Pennies  :=  0;
   Contents :=  1;
   Owner    :=  1;
   ObjType  := Room_Type;
   End;
  Write(Out,Rec);

  CleanRecord(Rec);
  With Rec Do
   Begin
   Name     := 'God';
   Password := 'Potrzebie';
   Key      := '';
   Location :=  0;
   Exits    :=  0;
   Next     := -1;
   Pennies  :=  MaxInt;
   Contents := -1;
   Owner    :=  1;
   ObjType  := Player_Type;
   ObjLevel := God_Level;
   GenFlags := Male_Gender;
   End;
  Write(Out,Rec);
  Close(Out);

  If IoResult<>0
     Then My_WriteLn('World creation failed on '+NAME+'.IDX');


  Assign(Ply,Name+'.PLY');
  Rewrite(Ply);
  Nr:=1;
  Write(Ply,Nr);
  Close(Ply);
  If IoResult<>0
     Then My_WriteLn('World creation failed on '+Name+'.PLY');

  Assign(Tmp,Name+'.DAT');
  Rewrite(Tmp);
  Close(Tmp);
  If IoResult<>0
     Then My_WriteLn('World creation failed on '+NAME+'.DAT');

  Assign(Ini,Name+'.INI');
  Rewrite(Ini);
  WriteLn(Ini,'<Shared Path>');
  WriteLn(Ini,'<ASCII Editor>');
  Close(Ini);
  If IoResult<>0
     Then;
  My_WriteLn('');
  My_WriteLn('Now edit the '+Name+'.INI file and restart MyMUD again.');
  My_WriteLn('You can login with the name "God" and the password "Potrzebie".');
  Halt;
End;

End.