{$I COPYRGHT.INC}

(*---------------------------------------------------------------------------*
   This unit contains all the macro support routines
 *---------------------------------------------------------------------------*)

Unit Macro;
Interface
Uses Header,
     bin_DB,
     MyIO,
     Multi,
     Misc,
     LowLevel,
     BoolExpr;

Procedure Macro_Let(Current : ContextType;InpStr : String);
Procedure Macro_Random(Current : ContextType;InpStr : String);
Procedure Macro_ShowFile(Current : ContextType; InpStr : String);
Procedure Macro_SayAll(Current : ContextType; InpStr : String);
Procedure Macro_SayUser(Current : ContextType; InpStr : String);
Procedure Macro_Pennies(Current : ContextType;InpStr : String);

Implementation

Procedure Macro_Let(Current : ContextType;InpStr : String);
Var ObjNr : Integer;
    VarNr : Byte;
    Value : String[20];
    VarStr: String[20];
Begin
If InpStr=''
   Then Begin
        My_WriteLn('Syntax error: &LET <Var>=<ObjNr>');
        Exit;
        End;

Current.DB.ReadObj(Current.Player);

If Not SplitCommand(InpStr,VarStr,Value)
   Then Begin
        VarNr:=Str2Nr(VarStr);
        If VarNr=0
           Then My_WriteLn('<Var> should be between 1 and 9')
           Else Current.DB.ObjRec.Storage[VarNr]:=-1;
        Exit;
        End;

VarNr:=Str2Nr(VarStr);
ObjNr:=Str2ObjNr(Current,Value);
If ObjNr=NOTHING
   Then ObjNr:=Str2Nr(Value);

Lock('Storage');
Current.DB.ReadObj(Current.Player);
Current.DB.ObjRec.Storage[VarNr]:=ObjNr;
Current.DB.UpdateObj(Current.Player);
Unlock;
End;

Procedure Macro_Random(Current : ContextType;InpStr : String);
Var BNr   : Integer;
    LNr   : Integer;
    Break : String[20];
    Limit : String[20];
Begin
If (InpStr='')
   Then Begin
        My_WriteLn('Syntax error: &RANDOM <Limit>[=<Breakpoint>]');
        Exit;
        End;

If Not SplitCommand(InpStr,Limit,Break)
   Then Begin
        Current.DB.ReadObj(Current.Player);
        Current.DB.ObjRec.Storage[0]:=Random(Str2Nr(InpStr));
        Exit;
        End;


BNr:=Str2Nr(Break);
LNr:=Str2Nr(Limit);
If ((BNr*LNr)=0) Or
   (BNr>LNr)
   Then Begin
        My_WriteLn('Break and limit value should be >0 and Limit>Break');
        Exit;
        End;
If Random(LNr)>BNr
   Then MacroString:='';
End;

Procedure Macro_ShowFile(Current : ContextType; InpStr : String);
Begin
InpStr:=ChangePathTo(InpStr,TextPath);

If Not ExistFile(InpStr)
   Then Begin
        MacroString:='';
        Exit;
        End;
ShowFile(InpStr);
End;

Procedure Macro_Pennies(Current : ContextType;InpStr : String);
Var Gain : Integer;
    Err  : Integer;
Begin
If InpStr=''
   Then Begin
        MacroString:='';
        Exit;
        End;
Val(InpStr,Gain,Err);
If Err<>0 Then Gain:=0;
Lock('Updating pennies');
Current.DB.ReadObj(Current.Player);
Inc(Current.DB.ObjRec.Pennies,Gain);
Current.DB.UpdateObj(Current.Player);
Unlock;
End;

Procedure Macro_SayUser(Current : ContextType; InpStr : String);
Begin
If InpStr<>''
   Then My_WriteLn(InpStr);
End;

Procedure Macro_SayAll(Current : ContextType; InpStr : String);
Begin
If InpStr<>''
   Then SayToAllHere(Current,InpStr);
End;

End.
