{$I COPYRGHT.INC}

(*--------------------------------------------------------------------------*
  This unit contains the general definitions for MyMUD
 *--------------------------------------------------------------------------*)
Unit Header;
Interface
Uses Dos;

Const MudName      = 'MyMUD';
      MudVersion   = '2.1';

Const CompileDate = '21 Jan 1995';

Const Room_Type          = 0;      { Define an object as a ROOM      }
      Thing_Type         = 1;      { Define an object as a THING     }
      Exit_Type          = 2;      { Define an object as a EXIT      }
      Player_Type        = 3;      { Define an object as a PLAYER    }
      Drone_Type         = 4;      { Define an object as a DRONE     }

      Guest_Level        = 0;      { Lowest liveform/level        }
      Player_Level       = 1;      { Normal players               }
      Builder_Level      = 2;      { Extra Creational commands    }
      Wizard_Level       = 3;      { More special commands        }
      God_Level          = 4;      { Only one who can make wizards}


{ Sex Types }
      No_Gender          = $00;
      Neuter_Gender      = $01;
      Female_Gender      = $02;
      Male_Gender        = $03;


{ Room_Flags: Room types }
      Temple_Room          = $0001; { Items can be sacreficed     }
      Haven_Room           = $0002; { User is save from killing   }
      Shop_Room            = $0004; { Items can be sold           }
      Loud_Room            = $0008; { Other can hear whispers..   }

{ Attr_Flags }
      Link_Ok_Flag         = $0001;
      Sticky_Flag          = $0002;
      Teleport_Ok_Flag     = $0004;
      Invisible_Flag       = $0008;
      For_Sale_Flag        = $0010;
      ChOwn_Ok_Flag        = $0020;

{ System Flags }
      Macro_Flag           = $0001;


      SAY_TOKEN      = '"';
      POSE_TOKEN     = ':';
      WHISPER_TOKEN  = '>';
      USE_TOKEN      = '/';

      MACRO_ESC      = '%';  {  %n %N    Username                 }
                             {  %s %S    he/she/it    He/She/It   }
                             {  %o %O    him/her/it   Him/Her/It  }
                             {  %p %P    his/her/its  His/Her/Its }
                             {  %m       * match replacement      }

      NOTHING              = -1;

      PENNY_RATE           = 10;
      MAX_PENNIES          = 10000;
      MAX_OBJECT_ENDOWMENT = 1000;

      LevelNames : Array[Guest_Level..God_Level] Of String[10] =
                   (
                    'Guest  ',
                    'Player ',
                    'Builder',
                    'Wizard ',
                    'God    '
                   );

      ReadOnly           = $00;
      WriteOnly          = $01;
      ReadWrite          = $02;

      ShareCompatible    = $00;
      ShareDenyAll       = $10;
      ShareDenyWrite     = $20;
      ShareDenyRead      = $30;
      ShareDenyNone      = $40;

      Inheritance        = $80;

      Highlight          = #27'[0;1;37m';
      LowLight           = #27'[0;37m';
      InverseLight       = #27'[0;7m'#27'[2K';


      DescMax            = 2*1024; { Maximal size of a LongRec.Length }

Type LongRec    = Record  { filepointer and length of a longtekst }
       Start    : LongInt;
       Length   : Word;
     End;

     GenderType = (None,Neuter,Female,Male);
     TextRecord = Array[0..DescMax] Of Char;
     NameString = String[20];
     PassString = String[40];

     ObjRecord    = Record
       Name       : String;      { Object name                          }
       Password   : PassString;  { Password for players                 }
       Key        : PassString;  { Boolean key                          }

       Location   : Integer;     { Current location                     }
       Contents   : Integer;     { Start of contents list               }
       Exits      : Integer;     { Start of exits list                  }
       Next       : Integer;     { continue list                        }
       Owner      : Integer;     { Recordnumber of owner                }
       Pennies    : Integer;     { Value/amound of pennies              }

       ObjType    : Byte;        { Thing, room, exit, player, Drone     }
       ObjLevel   : Byte;        { Toad,player,builder,wizard,god       }

       GenFlags   : LongInt;     { System flags                         }

       Desc       : LongRec;     { Pointer to long description          }

       Fail       : LongRec;     { Pointer to fail string               }
       Success    : LongRec;     { Pointer to Success string            }
       OFail      : LongRec;     { Pointer to fail for others           }
       OSuccess   : LongRec;     { Pointer to succes for others         }

       Macro      : LongRec;     { Macro language recs                  }

       Sex        : Byte;        { Sex of a player                      }
       Room_Flags : LongInt;     { Room attributes                      }
       Attr_Flags : LongInt;     { Thing attributes                     }

       Garbage    : Integer;     { Start of Garbage chain               }
       Finger     : LongRec;     { Info record for @FINGER command      }

       Storage    : Array[0..9] of Integer; { Variables for macros      }

       Filler   : Array[1..83] of Byte;
     End;

Var HomeDir : PathStr;
    ProgName: String[8];
    Dum     : String[10];

    MemMatch     : String; { Memory for RegExpr info between LowLevel and Out_Proc }
    LastSentence : String; { Last usertyped sentence }
    MacroString  : String; { Macro string, commands sep. by ^ }
    InMacro      : Boolean;{ Running a macro now?             }

Implementation

Begin { Grab the HOMEDIR }
MacroString:='';
LastSentence:='';
MemMatch:='';

HomeDir:=ParamStr(0);
FSplit(HomeDir,HomeDir,ProgName,Dum);
If GetEnv(ProgName)<>''
   Then HomeDir:=GetEnv(ProgName);
HomeDir:=FExpand(HomeDir);
If HomeDir[Length(HomeDir)]<>'\'
   Then HomeDir:=HomeDir+'\';
End.
