{$I COPYRGHT.INC}

(*----------------------------------------------------------------------------*

  Game Verbs and commands

 *---------------------------------------------------------------------------*)



Unit VerbList;
Interface
Uses MyIO;

Type VerbTypes = (
{ The normal commands }

                  UnKnown      , Say_T        , Whisper_T    , News_T       ,
                  WNews_T      , Rob_T        , Give_T       , Score_T      ,
                  Help_T       , Goto_T       , Home_T       , Look_T       ,
                  Inv_T        , Get_T        , Drop_T       , Quit_T       ,
                  WhoOn_T      , Version_T    , Kill_T       , Time_T       ,
                  Page_T       , Exam_T       , LHelp_T      , Use_T        ,
{ Meta key's }
                  Changename_M , Create_M     , ShoutAll_M   , SetFlag_M    ,
                  Home_M       , Stats_M      , ShutDown_M   , ChangePass_M ,
                  SetLock_M    , Unlock_M     , Desc_M       , SetHome_M    ,
                  Fail_M       , Success_M    , OFail_M      , OSuccess_M   ,
                  RaiseLev_M   , LowerLev_M   , Note_M       , Destroy_M    ,
                  Chown_M      , Dig_M        , Open_M       , Action_M     ,
                  Find_M       , Teleport_M   , Macro_M      , Info_M       ,
                  Finger_M     , Edit_M       ,
{ Debugging aids }

                  ShowRec_D    , Fix_D,
{ Macro tools }
                  Set_Mc       , Random_Mc    , If_Mc       ,Show_MC        ,
                  Say_MC       , SayAll_Mc    , Pennies_MC  ,

{ Specials }
                  Wait_At_At
                 );
Type  VerbString = String[20];


Function Verb2Key(V : VerbString;Level : Byte):VerbTypes;
Procedure ShowHelp(Level : Byte);

Implementation
Uses Header;

Type  VerbRecord = Record
                    Verb  : VerbString;
                    VType : VerbTypes;
                    Level : Byte;
                   End;

Const MaxVerb = 72;
      Verbs : Array[0..MaxVerb] of VerbRecord =
              (
          (Verb:'?'           ;VType:Help_T      ;Level: Guest_Level   ),

          (Verb:'WNEWS'       ;VType:WNews_T     ;Level: Wizard_Level  ),
          (Verb:'WHO'         ;Vtype:WhoOn_T     ;Level: Guest_Level   ),
          (Verb:'WHISPER'     ;Vtype:Whisper_T   ;Level: Player_Level  ),
          (Verb:'VERSION'     ;VType:Version_T   ;Level: Guest_Level   ),
          (Verb:'USE'         ;VType:Use_T       ;Level: Player_Level  ),
          (Verb:'TIME'        ;VType:Time_T      ;Level: Guest_Level   ),
          (Verb:'THROW'       ;VType:Drop_T      ;Level: Player_Level  ),
          (Verb:'TAKE'        ;Vtype:Get_T       ;Level: Player_Level  ),
          (Verb:'SCORE'       ;VType:Score_T     ;Level: Guest_Level   ),
          (Verb:'SAY'         ;VType:Say_T       ;Level: Guest_Level   ),
          (Verb:'SACRIFICE'   ;Vtype:Drop_T      ;Level: Player_Level  ),
          (Verb:'ROB'         ;VType:Rob_T       ;Level: Player_Level  ),
          (Verb:'READ'        ;VType:Look_T      ;Level: Guest_Level   ),
          (Verb:'QUIT'        ;Vtype:Quit_T      ;Level: Guest_Level   ),
          (Verb:'PAGE'        ;VType:Page_T      ;Level: Player_Level  ),
          (Verb:'NEWS'        ;VType:News_T      ;Level: Guest_Level   ),
          (Verb:'LOOK'        ;VType:Look_T      ;Level: Guest_Level   ),
          (Verb:'KILL'        ;Vtype:Kill_T      ;Level: Player_Level  ),
          (Verb:'INVENTORY'   ;Vtype:Inv_T       ;Level: Guest_Level   ),
          (Verb:'INV'         ;Vtype:Inv_T       ;Level: Guest_Level   ),
          (Verb:'I'           ;Vtype:Inv_T       ;Level: Guest_Level   ),
          (Verb:'HOME'        ;VType:Home_T      ;Level: Player_Level  ),
          (Verb:'HELP'        ;VType:LHelp_T     ;Level: Guest_Level   ),
          (Verb:'GOTO'        ;VType:Goto_T      ;Level: Guest_Level   ),
          (Verb:'GO'          ;VType:Goto_T      ;Level: Guest_Level   ),
          (Verb:'GIVE'        ;VTYpe:Give_T      ;Level: Player_Level  ),
          (Verb:'GET'         ;Vtype:Get_T       ;Level: Player_Level  ),
          (Verb:'EXAMINE'     ;VType:Exam_T      ;Level: Guest_Level   ),
          (Verb:'EXA'         ;VType:Exam_T      ;Level: Guest_Level   ),
          (Verb:'DROP'        ;Vtype:Drop_T      ;Level: Player_Level  ),
          (Verb:'DATE'        ;VType:Time_T      ;Level: Guest_Level   ),

          (Verb:'@WALL'       ;VType:ShoutAll_M  ;Level: Wizard_Level  ),
          (Verb:'@UNLOCK'     ;Vtype:Unlock_M    ;Level: Player_Level  ),
          (Verb:'@TELEPORT'   ;VType:Teleport_M  ;Level: Wizard_Level  ),
          (Verb:'@SUCCESS'    ;VType:Success_M   ;Level: Player_Level  ),
          (Verb:'@SHUTDOWN'   ;VType:ShutDown_M  ;Level: GOD_Level     ),
          (Verb:'@SETHOME'    ;VType:SetHome_M   ;Level: Builder_Level ),
          (Verb:'@SET'        ;VType:SetFlag_M   ;Level: Builder_Level ),
          (Verb:'@PROMOTE'    ;VType:RaiseLev_M  ;Level: Wizard_Level  ),
          (Verb:'@PASSWORD'   ;VType:ChangePass_M;Level: Player_Level  ),
          (Verb:'@OSUCCESS'   ;VType:OSuccess_M  ;Level: Player_Level  ),
          (Verb:'@OPEN'       ;VType:Open_M      ;Level: Builder_Level ),
          (Verb:'@OFAIL'      ;VType:OFail_M     ;Level: Player_Level  ),
          (Verb:'@NOTE'       ;Vtype:Note_M      ;Level: Player_Level  ),
          (Verb:'@NAME'       ;VType:ChangeName_M;Level: Builder_Level ),
          (Verb:'@MAGIC'      ;VType:Macro_M     ;Level: Wizard_Level  ),
          (Verb:'@LOCK'       ;VType:SetLock_M   ;Level: Player_Level  ),
          (Verb:'@INFO'       ;VType:Info_M      ;Level: Player_Level  ),
          (Verb:'@HOME'       ;Vtype:Home_M      ;Level: Player_Level  ),
          (Verb:'@HOME'       ;VType:Home_M      ;Level: Builder_Level ),
          (Verb:'@FINGER'     ;VType:Finger_M    ;Level: player_Level  ),
          (Verb:'@FIND'       ;VType:Find_M      ;Level: Builder_Level ),
          (Verb:'@FAIL'       ;VType:Fail_M      ;Level: Player_Level  ),
          (Verb:'@EDITFILE'   ;VType:Edit_M      ;Level: Wizard_Level  ),
          (Verb:'@DIG'        ;VType:Dig_M       ;Level: Builder_Level ),
          (Verb:'@DESTROY'    ;VType:Destroy_M   ;Level: Builder_Level ),
          (Verb:'@DESCRIBE'   ;VType:Desc_M      ;Level: Player_Level  ),
          (Verb:'@DESC'       ;VType:Desc_M      ;Level: Player_Level  ),
          (Verb:'@DEGRADE'    ;VType:LowerLev_M  ;Level: Wizard_Level  ),
          (Verb:'@CREATE'     ;VType:Create_M    ;Level: Wizard_Level  ),
          (Verb:'@CHOWN'      ;VType:Chown_M     ;Level: Builder_Level ),
          (Verb:'@ACTION'     ;VType:Action_M    ;Level: Builder_Level ),

          (Verb:'&SHOWFILE'   ;VType:Show_MC     ;Level: Guest_Level   ),
          (Verb:'&SET'        ;VType:Set_MC      ;Level: Guest_Level   ),
          (Verb:'&SAYALL'     ;VType:SayAll_MC   ;Level: Guest_Level   ),
          (Verb:'&SAY'        ;VType:Say_MC      ;Level: Guest_Level   ),
          (Verb:'&RANDOM'     ;VType:Random_MC   ;Level: Guest_Level   ),
          (Verb:'&PENNIES'    ;VType:Pennies_MC  ;Level: Guest_Level   ),
          (Verb:'&IF'         ;VType:IF_MC       ;Level: Guest_Level   ),

          (Verb:'#STATS'      ;VType:Stats_M     ;Level: Wizard_Level  ),
          (Verb:'#REC'        ;VType:ShowRec_D   ;Level: Wizard_Level  ),
          (Verb:'#FIX'        ;VType:Fix_D       ;Level: Wizard_Level  )
        );

Function Verb2Key(V : VerbString;Level : Byte):VerbTypes;
Var Tmp : Integer;
Begin
Tmp:=MaxVerb;
While (Tmp>=0) and (Verbs[Tmp].Verb<>V) Do
 Dec(Tmp);
If (Tmp<0) or (Verbs[Tmp].Level>Level)
   Then Verb2Key:=UnKnown
   Else Verb2Key:=Verbs[Tmp].VType;
End;

Procedure ShowHelp(Level : Byte);
Var Cnt      : Word;
    LastType : VerbTypes;
    Tmp      : VerbString;
Begin
My_WriteLn('Quicklist commands:');
My_WriteLn('');
LastType:=UnKnown;
For Cnt:=1 To MaxVerb Do
  If (Level>=Verbs[Cnt].Level) And
    (Verbs[Cnt].VType<>LastType)
    Then Begin
         Fillchar(Tmp,SizeOf(Tmp),#32);
         Move(Verbs[Cnt].Verb,Tmp,Length(Verbs[Cnt].Verb)+1);
         Tmp[0]:=#20;
         My_Write(Tmp);
         LastType:=Verbs[Cnt].VType;
         End;
My_WriteLn('')
End;


End.
