{ ========================================================================== }
{ Strs.pas - accesses Str procedure for use as a           ver 7.0, 06-21-93 }
{            function.                                                       }
{ Inline code keeps function from having to copy the string twice and thus   }
{ increasing speed.  Functions save code in the long run.                    }
{  Copyright (C) 1993 James H. LeMay, All rights reserved.                   }
{ ========================================================================== }

UNIT Strs;

INTERFACE

function StrL   (L: longint):                       string;
function StrLF  (L: longint; Field: integer):       string;
function StrR   (R: real):                          string;
function StrRF  (R: real; Field: integer):          string;
function StrRFD (R: real; Field,Decimals: integer): string;


IMPLEMENTATION

function StrL; { (L: longint): string; }
var  Result: ^string;
begin
Inline(                  { Typical code: }
  $89/$EC/               { mov  sp,bp      ; Drop Result }
  $16/                   { push ss         ; Result segment }
  $FF/$76/$0A);          { push [bp+$0A]   ; Result offset ($08 for near) }
  str (L,Result^);
end;

function StrLF; { (L: longint; Field: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$0C);
  str (L:Field,Result^);
end;

function StrR; { (R: real): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$0C);
  str (R,Result^);
end;

function StrRF; { (R: real; Field: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$0E);
  str (R:Field,Result^);
end;

function StrRFD; { (R: real; Field,Decimals: integer): string; }
var  Result: ^string;
begin
  Inline ($89/$EC/$16/$FF/$76/$10);
  str (R:Field:Decimals,Result^);
end;

END.
