{ ========================================================================== }
{ PullStat.pas - User Statistics for pull-down menus.      ver 7.0, 06-21-93 }
{                                                                            }
{ This file contains all the data for GetUserPullStats, GetOverrideStats and }
{ CheckGlobalKeys to configure the menus.                                    }
{   Copyright (c) 1988,1993 James H. LeMay, All rights reserved.             }
{ ========================================================================== }

{$i pulldefs.inc }

UNIT PullStat;

INTERFACE

{ ------------------ Set up your window names here in order: --------------- }
{ This is optional, but it sure helps you in not only understanding the
  program, but also makes it unquestionably easier to rearrange.             }

type
  MainMenuNames = (NoMainMenu,FilesMenu,ColorMenu,AutoPartsMenu,EnterDataMenu,
                   OptionsMenu,UtilitiesMenu,IRSmenu,QuitMenu);

  {$ifdef UseSubMenuCode }
  SubMenuNames  = (NoSubMenu,TiresMenu,RadioMenu,UpdateMenu,DateMenu,
                   BrandsMenu);
  {$endif }

  {$ifdef UseDataEntryCode }
  DataWndwNames = (NoDW,BytesDW,WordsDW,IntegersDW,LongIntsDW,RealsDW,HexDW,
                   CharsDW,StringsDW,PathDW,FileMaskDW,SeatsDW,PriceDW,
                   MonthDW,DayDW,YearDW,YearsDW);
  {$endif }

  {$ifdef UseHelpWndwCode }
  HelpWndwNames = (NoHW,WorkWndwHW,TopLineHW,FilesMenuHW,DirMenuHW,
                   BrandsMenuHW,EnterDataMenuHW,IRSmenuHW,DateMenuHW,
                   UpdateMenuHW,ExecChoiceHW,SingleChoiceHW,MultipleChoiceHW,
                   NumericHW,TextHW);
  HelpLineNames = (NoHL,               { HL - HelpLine;  L  - Last }
                   HLw1,HLw2,HLw3,HLw4,HLw5,HLw6, { Work window }
                   HLw7,HLw8,HLw9,HLw10,HLw11,HLwL,
                   HLt1,HLtL,                     { Top menu }
                   HLb1,HLb2,HLb3,HLb4,HLb5,HLbL, { Brands submenu }
                   HLf1,HLf2,HLf3,HLf4,HLf5,      { Files submenu }
                   HLf6,HLf7,HLf8,HLf9,HLf10,HLfL,
                   HLdir1,HLdir2,HLdir3,HLdir4,HLdir5,  { Directory submenu }
                   HLdir6,HLdir7,HLdir8,HLdir9,HLdirL,
                   HLe1,HLe2,HLe3,HLe4,HLe5,      { Enter data submenu }
                   HLe6,HLe7,HLe8,HLe9,HLe10,
                   HLe11,HLe12,HLe13,HLe14,HLeL,
                   HLi1,HLi2,HLiL,                { IRS menu }
                   HLd1,HLd2,HLd3,HLdL,           { Date submenu }
                   HLu1,HLu2,HLuL,                { Update submenu }
                   HLx1,HLx2,HLxL,                { eXecute choice menu }
                   HLs1,HLs2,HLsL,                { Single choice menu }
                   HLm1,HLm2,HLmL,                { Multiple choice menu }
                   HLn1,HLn2,HLn3,HLn4,HLn5,HLn6,HLnL,       { Numeric data }
                   HLtx1,HLtx2,HLtx3,HLtx4,HLtx5,HLtx6,HLtxL);  { Text data }
  {$endif UseHelpWndwCode }

  {$ifdef UseMsgLineCode }
  MsgLineNames = (NoML,WorkML,TopML,AltML,MainML,SubML,DW_ML,DE_ML,
                  SeqML,HelpML,ProcML,DirML);
  {$endif UseMsgLineCode }

const
  FileName: string[12] = 'pulldemo.exe';

{ Careful! - Always test your last main menu, submenu, data window, and help
  window for run-time error!  It makes sure you have allotted enough memory
  with your constants.  The compiler cannot check it with these typed
  scalars. }

procedure GetUserPullStats;
procedure GetOverrideStats;
procedure CheckGlobalKeys;


IMPLEMENTATION

uses
  Crt,Qwik,Wutil,Wndw,Pull,PullDir;

procedure GetMainMenu (Name: MainMenuNames);
begin
  MRI := ord (Name);
  TopMenu := MainMenu^[MRI];
end;

procedure SaveMainMenu;
begin
  MainMenu^[MRI] := TopMenu;
end;

{$ifdef UseSubMenuCode }
procedure GetSubMenu (Name: SubMenuNames);
begin
  MRI := ord (Name);
  TopMenu := SubMenu^ [MRI];
end;

procedure SaveSubMenu;
begin
  SubMenu^[MRI] := TopMenu;
end;
{$endif }

{$ifdef UseHelpWndwCode }
procedure SetHelpLines (Name: HelpWndwNames; First,Last: HelpLineNames);
begin
  HelpWndw[ord(Name)].FirstLine := ord(First);
  HelpWndw[ord(Name)].LastLine  := ord(Last);
end;
{$endif }

{ =========================== EXEC PROCEDURES ============================== }
{ Place procedures for execution by menu pointers, ProcPtr, here.            }
{ They MUST be set to FAR calls.                                             }
{ -------------------------------------------------------------------------- }

procedure DummyProc; far;
begin
  {$ifdef UseMsgLineCode }
  ShowMsg (ord(ProcML));
  {$endif UseMsgLineCode }
  Delay (1000)
end;

procedure GotoDir; far;
begin
  PullDown:=true;
  MoreCmdSeq:='D';
end;

procedure DoDir; far;
begin
  { Use (FileName,FileName) to initially Hilite a close match. }
  { Use (FileName,'') to start at default. }
  PullDirectory (FileName,FileName);
end;

procedure SetQuit; far;
begin
  PopToWorkWndw := true;
  Quit := true;
end;

procedure ProcessThenPop; far;
begin
  { Here's how to process and then pop the menus. }
  DummyProc;
  PopToWorkWndw := true;
end;

procedure PopThenProcess; far;
begin
  { Here's how to pop first and then process. }
  if Popped then DummyProc;
end;

procedure PopProcessAndPull; far;
begin
  { Here's how to pop the menus first, process and then pull the same }
  { menus back again which is good for updating the work window. }
  if Popped then DummyProc;
  PullDown := true;
end;

procedure PopNumOfLevels; far;
begin
  { Here's how to pop by a number of levels so that part of the menus will }
  { remain displayed while going to another submenu. }
  PopLevels  := 1;
  PullDown   := true;
  MoreCmdSeq := 'Y';
end;

procedure PopToNewMenu; far;
begin
  { Here's how to go to a completely different menu. }
  PopToTop   := true;
  PullDown   := true;
  MoreCmdSeq := 'AR';
end;

procedure DateMenu1; far;
begin
  PullDown   := true;
  MoreCmdSeq := 'D';
end;

procedure DateMenu2; far;
begin
  PullDown   := true;
  MoreCmdSeq := 'Y';
end;

procedure DateMenu3; far;
begin
  PopLevels := 1;
end;

{ ======================== GetUserPullStats ================================ }
{ The major configurations for all menus go here.  The program first clears  }
{ all RECORD values to $00.  The values below will set new values. Therefore,}
{ setting RECORD values to "false" or the like is not necessary.             }
{ -------------------------------------------------------------------------- }

procedure GetUserPullStats;
begin
  DefaultLinkDir := Right; { This is the preferrable location for submenus
                             located relative to the main menu.  Use Right
                             or Left for slide-up or Down for slide under. }
  LocationWarning := true; { If true and a Submenu won't fit, a message is
                             displayed.  If false, you can override the
                             location without the message. }

  { ------------------ Set up your colors and borders here: ---------------- }
  TopLineAttr   := Black+LightGrayBG;
  TopLineHattr  := White+BlackBG;

  MainMenuBattr := Black+LightGrayBG;
  MainMenuHattr := LightGray+BlackBG;
  MainMenuLattr := White+LightGrayBG;
  MainMenuWattr := Black+LightGrayBG;
  MainMenuCattr := Black+LightGrayBG;
  Brdr[UserBrdr1].BrdrArray := '͸͵ѳ';
  MainMenuBrdr  := UserBrdr1;

  {$ifdef UseSubMenuCode }
  SubMenuWattr  := Black+CyanBG;
  SubMenuBattr  := Black+CyanBG;
  SubMenuBrdr   := SingleBrdr;
  {$endif UseSubMenuCode }

  if VideoMode=7 then
    begin
      TopLineLattr := TopLineAttr;
      {$ifdef UseSubMenuCode }
      SubMenuHattr := Black    +LightGrayBG;
      SubMenuLattr := White    +BlackBG;
      SubMenuCattr := LightGray+BlackBG;
      {$endif UseSubMenuCode }
    end
  else
    begin
      TopLineLattr := Red  +LightGrayBG;
      {$ifdef UseSubMenuCode }
      SubMenuHattr := White+BlueBG;
      SubMenuLattr := White+CyanBG;
      SubMenuCattr := Blue +CyanBG;
      {$endif UseSubMenuCode }
    end;

  {$ifdef UseHelpWndwCode }
  HelpWndwWattr := Black+GreenBG;
  HelpWndwBattr := Black+LightGrayBG;
  HelpWndwBrdr  := HdoubleBrdr;
  HelpWndwModes := ZoomMode+ShadowRight+ShadowTrans+CursorOffMode;
  HelpBottomRow := CRTrows-4;
  {$endif UseHelpWndwCode }

  {$ifdef UseMsgLineCode }
  MsgLineAttr   := Black+GreenBG;
  MsgLineHattr  := White+GreenBG;
  if QvideoMode=Mono then
       KeyStatusAttr := LightGrayBG
  else KeyStatusAttr := Blue+LightGrayBG;
  ErrMsgAttr    := Yellow+RedBG;
  MsgLineRow    := CRTrows;
  {$endif UseMsgLineCode }


  { ------------------------- Top Menu defaults ---------------------------- }
  TopLineRow := 2;      { Top line menu to appear on row 2 }
  MPulled    := 3;      { Main menu title to be HiLited when F10 is pressed. }
  MoreCmdSeq := 'ATB';  { Sequence of command letter(s) as if keyed in. }
                        { This will be the default menu(s) pulled. }
  PullDown   := false;  { Set this true if you want the command sequence}
                        {  to pull down the menus at startup. }

  { ------------------- Set up your MainMenu records here: ----------------- }
  MainMenuRow := 3;     { First row of Main menus to appear on screen row 3 }

  with TopMenu do
  begin

    GetMainMenu (FilesMenu);
    MenuMode:=SingleChoice;           SingleFlagLine:=5;
    Title:='~Files';
    Line[1]:='~Path...';              LineMode[1]:=ToDataWndw;
                                      LinkNum [1]:=ord(PathDW);
    Line[2]:='~Mask for directory';   LineMode[2]:=ToDataWndw;
                                      LinkNum [2]:=ord(FileMaskDW);
                                      ProcPtr [2]:=GotoDir;
    Line[3]:='~Directory';            LineMode[3]:=ToUserWndw;
                                      ProcPtr [3]:=DoDir;
    Line[4]:='';    LineMode[4]:=Comment;
    Line[5]:='~Split';
    Line[6]:='Make ~backup';
    Line[7]:='Text ~out';
    Line[8]:='';                      LineMode[8]:=Partition;
    Line[9]:='~Help comment';         LineMode[9]:=Comment;
    DefaultLine := 3;
    MsgLineNum  := ord(MainML);
    HelpWndwNum := ord(FilesMenuHW);
    SaveMainMenu;

    GetMainMenu (ColorMenu);
    MenuMode:=SingleChoice;           SingleFlagLine:=2;
    Title:='~Color';
    Line[1]:='~Blue';
    Line[2]:='~Green';
    Line[3]:='~Orange';               LineMode[3] := NoChoice;
    Line[4]:='~Yellow';
    Line[5]:='~Red';
    Line[6]:='~Cyan';
    Line[7]:='~Ultraviolet';
    DefaultLine := 5;
    MsgLineNum  := ord(MainML);
    HelpWndwNum := ord(SingleChoiceHW);
    SaveMainMenu;

    GetMainMenu (AutoPartsMenu);
    MenuMode:=MultipleChoice;
    Title:='~AutoParts';
    Line[1]:='~Tires';          LineMode[1]:=ToSubMenu;
                                LinkNum [1]:=ord(TiresMenu);
    Line[2]:='~Radio';          LineMode[2]:=ToSubMenu;
                                LinkNum [2]:=ord(RadioMenu);
    Line[3]:='~Seats...';       LineMode[3]:=ToDataWndw;
                                LinkNum [3]:=ord(SeatsDW);
    Line[4]:='~Mirrors';        Flagged[4]:=true;
    Line[5]:='~Locks';
    Line[6]:='~HiBeams';         Flagged[6]:=true;
    Line[7]:='~Wheels';
  { DefaultLine := 1; }       { This is the default }
    MsgLineNum  := ord(MainML);
    HelpWndwNum := ord(MultipleChoiceHW);
    SaveMainMenu;

    GetMainMenu (EnterDataMenu);
    MenuMode:=MultipleChoice;
    Title:='~EnterData';
    Line[1]:='~Byte...';        LineMode[1]:=ToDataWndw;
                                LinkNum [1]:=ord(BytesDW);
    Line[2]:='~Word...';        LineMode[2]:=ToDataWndw;
                                LinkNum [2]:=ord(WordsDW);
    Line[3]:='~Integer...';     LineMode[3]:=ToDataWndw;
                                LinkNum [3]:=ord(IntegersDW);
    Line[4]:='~LongInt...';     LineMode[4]:=ToDataWndw;
                                LinkNum [4]:=ord(LongIntsDW);
    Line[5]:='~Real...';        LineMode[5]:=ToDataWndw;
                                LinkNum [5]:=ord(RealsDW);
    Line[6]:='~Hex...';         LineMode[6]:=ToDataWndw;
                                LinkNum [6]:=ord(HexDW);
    Line[7]:='~Character...';   LineMode[7]:=ToDataWndw;
                                LinkNum [7]:=ord(CharsDW);
    Line[8]:='~String...';      LineMode[8]:=ToDataWndw;
                                LinkNum [8]:=ord(StringsDW);
    DefaultLine := 2;
    MsgLineNum  := ord(MainML);
    HelpWndwNum := ord(EnterDataMenuHW);
    SaveMainMenu;

    GetMainMenu (OptionsMenu);
    MenuMode:=MultipleChoice;
    Title:='~Options';
    Line[1]:='~Dual drive';
    Line[2]:='~Hard disk';      Flagged[2]:=true;
    Line[3]:='~Extended Mem';
    Line[4]:='~CGA';            Flagged[4]:=true;
    Line[5]:='~VGA';
    Line[6]:='~KeyBoard';
    Line[7]:='~Price limit...'; LineMode[7]:=ToDataWndw;
                                LinkNum [7]:=ord(PriceDW);
    MsgLineNum  := ord(MainML);
    HelpWndwNum := ord(MultipleChoiceHW);
    SaveMainMenu;

    GetMainMenu (UtilitiesMenu);
  { MenuMode:=ExecChoice; }     { This is the default }
    Title:='~Utilities';
    Line[1]:='~Copy   files';   ProcPtr[1] := DummyProc;
    Line[2]:='~Delete files';   ProcPtr[2] := DummyProc;
    Line[3]:='~List   file';    ProcPtr[3] := DummyProc;
    Line[4]:='~Edit   file';    ProcPtr[4] := DummyProc;
    Line[5]:='~Find   file';    ProcPtr[5] := DummyProc;
    Line[6]:='~Rename file';    ProcPtr[6] := DummyProc;
    Line[7]:='~Sort   files';   ProcPtr[7] := DummyProc;
    DefaultLine := 2;
    MsgLineNum  := ord(MainML);
    HelpWndwNum := ord(ExecChoiceHW);
    SaveMainMenu;

    GetMainMenu (IRSmenu);
  { MenuMode:=ExecChoice; }     { This is the default }
    Title:='~IRSaccounting';
    Line[1]:='~Date';           LineMode[1]:=ToSubMenu;
                                LinkNum [1]:=ord(DateMenu);
    Line[2]:='~Cost';           ProcPtr [2]:=DummyProc;
    Line[3]:='~Revenue';        ProcPtr [3]:=DummyProc;
    Line[4]:='~Taxes';          ProcPtr [4]:=DummyProc;
    Line[5]:='~Insurance';      ProcPtr [5]:=DummyProc;
    Line[6]:='~Update';         LineMode[6]:=ToSubMenu;
                                LinkNum [6]:=ord(UpdateMenu);
    Line[7]:='~Years...';       LineMode[7]:=ToDataWndw;
                                LinkNum [7]:=ord(BytesDW);
                                ProcPtr [7]:=DummyProc;
    MsgLineNum  := ord(MainML);
    HelpWndwNum := ord(IRSmenuHW);
    SaveMainMenu;

    GetMainMenu (QuitMenu);
  { MenuMode:=ExecChoice; }     { This is the default }
    Title:='~Quit';
    Line[1]:='~Stay';
    Line[2]:='~Quit';            ProcPtr[2] := SetQuit;
    BackToDefault:=true;
    MsgLineNum  := ord(MainML);
    HelpWndwNum := ord(ExecChoiceHW);
    SaveMainMenu;

  { ----------------------- Set up your SubMenus here: --------------------- }
  { Careful! -- indexes to SubMenus must be numbered in order of level; i.e.,}
  { ALL SubMenus first, ALL SubSubMenus second, ALL SubSubSubMenus, ... etc. }

    {$ifdef UseSubMenuCode }

    GetSubMenu (TiresMenu);
    MenuMode:=SingleChoice;     SingleFlagLine:=5;
    Line[1]:='~Brands';         LineMode[1]:=ToSubMenu;
                                LinkNum[1] :=ord(BrandsMenu);
    Line[2]:='~Radials';
    Line[3]:='~Knobbies';
    Line[4]:='~Track';
    Line[5]:='~Snow';
    Line[6]:='~All-Weather';
    Line[7]:='~4-ply';
    MsgLineNum  := ord(SubML);
    HelpWndwNum := ord(SingleChoiceHW);
    SaveSubMenu;

    GetSubMenu (RadioMenu);
    MenuMode:=MultipleChoice;
    Line[1]:='~FM Stereo';      Flagged[1]:=true;
    Line[2]:='~AM Radio';       Flagged[2]:=true;
    Line[3]:='~Tape player';
    Line[4]:='~Compact Disc';
    DefaultLine := 4;
    MsgLineNum  := ord(SubML);
    HelpWndwNum := ord(MultipleChoiceHW);
    SaveSubMenu;

    GetSubMenu (DateMenu);
  { MenuMode:=ExecChoice; }     { This is the default }
    Line[1]:='~Month...';       LineMode[1]:=ToDataWndw;
                                LinkNum [1]:=ord(MonthDW);
                                ProcPtr [1]:=DateMenu1;
    Line[2]:='~Day...';         LineMode[2]:=ToDataWndw;
                                LinkNum [2]:=ord(DayDW);
                                ProcPtr [2]:=DateMenu2;
    Line[3]:='~Year...';        LineMode[3]:=ToDataWndw;
                                LinkNum [3]:=ord(YearDW);
                                ProcPtr [3]:=DateMenu3;
    BackToDefault := true;
    MsgLineNum  := ord(SubML);
    HelpWndwNum := ord(DateMenuHW);
    SaveSubMenu;

    GetSubMenu (UpdateMenu);
  { MenuMode:=ExecChoice; }     { This is the default }
    Line[1]:='~1 process';                ProcPtr[1] := DummyProc;
    Line[2]:='~2 process and pop';        ProcPtr[2] := ProcessThenPop;
    Line[3]:='~3 pop and process';        ProcPtr[3] := PopThenProcess;
    Line[4]:='~4 pop, process, pull';     ProcPtr[4] := PopProcessAndPull;
    Line[5]:='~5 pop, pull to Years';     ProcPtr[5] := PopNumOfLevels;
    Line[6]:='~6 pop, pull Radio';        ProcPtr[6] := PopToNewMenu;
    DefaultLine := 4;
    MsgLineNum  := ord(SubML);
    HelpWndwNum := ord(UpdateMenuHW);
    SaveSubMenu;

  { Here's a SubSubMenu: }
    GetSubMenu (BrandsMenu);
    MenuMode:=SingleChoice;     SingleFlagLine:=2;
    Line[1]:='~Michelin';
    Line[2]:='~General';
    Line[3]:='~Firestone';
    Line[4]:='~Bridgestone';
    Line[5]:='~Rollingstone';
    DefaultLine := 3;
    MsgLineNum  := ord(SubML);
    HelpWndwNum := ord(BrandsMenuHW);
    SaveSubMenu;

    {$endif UseSubMenuCode }

  end;  { with TopMenu }

  { ---------------------- Set up your Help Windows here: ------------------ }
  { HelpWndw[1] is reserved for the Work window. }
  { HelpWndw[2] is reserved for the top menu. }

  {$ifdef UseHelpWndwCode }
  HelpMsgLineNum := ord(HelpML);     { Standard message for a Help window }
  SetHelpLines (WorkWndwHW      ,HLw1 ,HLwL);
  SetHelpLines (TopLineHW       ,HLt1 ,HLtL);
  SetHelpLines (FilesMenuHW     ,HLf1 ,HLfL);
  SetHelpLines (DirMenuHW       ,HLdir1,HLdirL);
  SetHelpLines (EnterDataMenuHW ,HLe1 ,HLeL);
  SetHelpLines (BrandsMenuHW    ,HLb1 ,HLbL);
  SetHelpLines (IRSmenuHW       ,HLi1 ,HLiL);
  SetHelpLines (DateMenuHW      ,HLd1 ,HLdL);
  SetHelpLines (UpdateMenuHW    ,HLu1 ,HLuL);
  SetHelpLines (ExecChoiceHW    ,HLx1 ,HLxL);
  SetHelpLines (SingleChoiceHW  ,HLs1 ,HLsL);
  SetHelpLines (MultipleChoiceHW,HLm1 ,HLmL);
  SetHelpLines (NumericHW       ,HLn1, HLnL);
  SetHelpLines (TextHW          ,HLtx1,HLtxL);

  { ------------------ Set up your Help Lines here: ------------------------ }
  HelpLine[ord(HLw1)]:='              WELCOME TO PULL70.ZIP';
  HelpLine[ord(HLw2)]:='To move the data entry highlight to the desired';
  HelpLine[ord(HLw3)]:='field, use the following keys:';
  HelpLine[ord(HLw4)]:='  '#27'/'#26'            - Left/Right';
  HelpLine[ord(HLw5)]:='  '^X'/'^Y'            - Up/Down nearest cursor';
  HelpLine[ord(HLw6)]:='  Home/Ctrl '#27'    - First one on the row.';
  HelpLine[ord(HLw7)]:='  End /Ctrl '#26'    - Last one on the row';
  HelpLine[ord(HLw8)]:='  PgUp/Ctrl-Home - First in sequence';
  HelpLine[ord(HLw9)]:='  PgDn/Ctrl-End  - Last  in sequence';
  HelpLine[ord(HLw10)]:='  Tab/Shift Tab  - next in sequence';
  HelpLine[ord(HLw11)]:='Return key edits the current value.';
  HelpLine[ord(HLwL)]:='Any non-extended key will begin editing the field.';

  HelpLine[ord(HLt1)]:='Move cursor and press return OR type a command';
  HelpLine[ord(HLtL)]:='letter.  ESC to return to the Work window.';

  HelpLine[ord(HLb1)]:='Notice the number of levels for the menus.  This';
  HelpLine[ord(HLb2)]:='menu is a "Single Choice" menu, but you can choose';
  HelpLine[ord(HLb3)]:='from 1 of 3 menu modes:';
  HelpLine[ord(HLb4)]:='  1. ExecChoice     - process only';
  HelpLine[ord(HLb5)]:='  2. SingleChoice   - flag and process';
  HelpLine[ord(HLbL)]:='  3. MultipleChoice - toggle flag and process';

  HelpLine[ord(HLf1)]:='This is a "Single Choice" menu, but there are ';
  HelpLine[ord(HLf2)]:='5 of the 8 possible line modes used here:';
  HelpLine[ord(HLf3)]:='* 1. Choice     - interact with other menu choices';
  HelpLine[ord(HLf4)]:='  2. ExecOnly   - process but do not flag';
  HelpLine[ord(HLf5)]:='  3. NoChoice   - temporarily disabled';
  HelpLine[ord(HLf6)]:='* 4. Comment    - bypassed by highlight';
  HelpLine[ord(HLf7)]:='* 5. Partition  - mid-menu border';
  HelpLine[ord(HLf8)]:='* 6. ToDataWndw - pulls data entry window';
  HelpLine[ord(HLf9)]:='  7. ToSubMenu  - pulls next submenu level';
  HelpLine[ord(HLf10)]:='* 8. ToUserWndw - like ExecOnly plus menu symbol';
  HelpLine[ord(HLfL)]:='Any combination of the seven works!';

  HelpLine[ord(HLe1)]:='Each data entry window can be tailored to any type';
  HelpLine[ord(HLe2)]:='of data:';
  HelpLine[ord(HLe3)]:='  1. Byte     - 0..255';
  HelpLine[ord(HLe4)]:='  2. Word     - 0..65535';
  HelpLine[ord(HLe5)]:='  3. ShortInt - -128..127';
  HelpLine[ord(HLe6)]:='  4. Integer  - -32768..32767';
  HelpLine[ord(HLe7)]:='  5. LongInt  - -2147483647..2147483647';
  HelpLine[ord(HLe8)]:='  6. Real     - any format';
  HelpLine[ord(HLe9)]:='  7. UserNums - user defined numbers, like hex';
  HelpLine[ord(HLe10)]:='  8. Char    - one character';
  HelpLine[ord(HLe11)]:='  9. String  - any length';
  HelpLine[ord(HLe12)]:='Data entry will check validity, range, and user-';
  HelpLine[ord(HLe13)]:='defined limits.   Sets will limit data entry to';
  HelpLine[ord(HLe14)]:='valid characters only.  Field length and labels';
  HelpLine[ord(HLeL)]:='are also user-defined.';

  HelpLine[ord(HLi1)]:='This is an "Execute Choice" menu.  But sure to see';
  HelpLine[ord(HLi2)]:='the example of sequential data entry on "Date" and';
  HelpLine[ord(HLiL)]:='menu control on "Update".';

  HelpLine[ord(HLd1)]:='This is an "Execute Choice" menu, but there are no';
  HelpLine[ord(HLd2)]:='"choice" lines.  Instead, the lines are all data';
  HelpLine[ord(HLd3)]:='entry lines that have been made to allow either';
  HelpLine[ord(HLdL)]:='random or sequential access.  Start with "Month".';

  HelpLine[ord(HLu1)]:='This is an "Execute Choice" menu.  This one will';
  HelpLine[ord(HLu2)]:='show you a few of the possibilities of actually';
  HelpLine[ord(HLuL)]:='controlling the menus themselves.';

  HelpLine[ord(HLx1)]:='        This is an "Execute Choice" menu.';
  HelpLine[ord(HLx2)]:='         Notice that there are no flags.';
  HelpLine[ord(HLxL)]:='   "'^P'" means linked SubMenu; "..." - DataWndw.';

  HelpLine[ord(HLs1)]:='         This is a "Single Choice" menu.';
  HelpLine[ord(HLs2)]:='          Notice there''s only one flag.';
  HelpLine[ord(HLsL)]:='   "'^P'" means linked SubMenu; "..." - DataWndw.';

  HelpLine[ord(HLm1)]:='        This is a "Multiple Choice" menu.';
  HelpLine[ord(HLm2)]:='              Notice several flags.';
  HelpLine[ord(HLmL)]:='   "'^P'" means linked SubMenu; "..." - DataWndw.';

  HelpLine[ord(HLdir1)]:='Directory can optionally default to a closely';
  HelpLine[ord(HLdir2)]:='matching name, if any, in the file name entry';
  HelpLine[ord(HLdir3)]:='field.  Pressing CR replaces the name.  Cursor and';
  HelpLine[ord(HLdir4)]:='letter keys move the highlight:';
  HelpLine[ord(HLdir5)]:='  Letter key  - find name with same first letter';
  HelpLine[ord(HLdir6)]:='  '^X'/'^Y'         - move up/down';
  HelpLine[ord(HLdir7)]:='  Home/End    - move to upper/lower file name';
  HelpLine[ord(HLdir8)]:='  PgUp/PgDn   - move up/down a page';
  HelpLine[ord(HLdir9)]:='  ^Home/^End  - move to top/bottom file name';
  HelpLine[ord(HLdirL)]:='  ^PgUp/^PgDn - move to top/bottom page';

  HelpLine[ord(HLn1)]:='This is a data entry field for numbers. Only valid';
  HelpLine[ord(HLn2)]:='numbers and symbols can be typed.  Full editing';
  HelpLine[ord(HLn3)]:='capability:';
  HelpLine[ord(HLn4)]:='  1. WordStar keys: ^A,^S,^D,^F,^G,^H,^R,^Y,^U';
  HelpLine[ord(HLn5)]:='  2. Cursor keys:   Home/End, Left/Right Arrow,';
  HelpLine[ord(HLn6)]:='     Ctrl-Left/Right Arrow, and Ins/Del.';
  HelpLine[ord(HLnL)]:='  3. Use ^R or ^U to restore original data.';

  HelpLine[ord(HLtx1)]:='This is a data entry field for text.  With the use';
  HelpLine[ord(HLtx2)]:='of sets, only valid letters can be typed.  Full';
  HelpLine[ord(HLtx3)]:='editing capability:';
  HelpLine[ord(HLtx4)]:='  1. WordStar keys: ^A,^S,^D,^F,^G,^H,^R,^Y,^U';
  HelpLine[ord(HLtx5)]:='  2. Cursor keys:   Home/End, Left/Right Arrow,';
  HelpLine[ord(HLtx6)]:='     Ctrl-Left/Right Arrow, and Ins/Del.';
  HelpLine[ord(HLtxL)]:='  3. Use ^R or ^U to restore original data.';
  {$endif UseHelpWndwCode }


  { ------------------ Set up your Message Lines here: --------------------- }
  { Concatenations here allow source to print on 80 col printer.             }
  { All messages up to HelpMsg are reserved.                                 }
  { "~" toggles highlight attribute. }

  {$ifdef UseMsgLineCode }
  MsgLine[ord(WorkML)]:=' ~F1~-help  ~F2~-pull  ~F10~-top';
  MsgLine[ord(TopML)] :=' ~F1~-help  ~F2~-pop   ~LTR~-cmd  ~ESC~-return  '+
                        '        ~'^[^Z'~ hilight            ~CR~-select';
  MsgLine[ord(AltML)] :=' ~Alt-F~-Files  ~Alt-D~-Directory  ~Alt-P~-Path '+
                        '                           ~Alt-X~-Exit';
  MsgLine[ord(MainML)]:=' ~F1~-help  ~F2~-pop   ~LTR~-cmd  ~ESC~-return  '+
                        '        ~'^[^Z'~ menus  ~'^X^Y'~-hilight  ~CR~-select';
  MsgLine[ord(SubML)] :=' ~F1~-help  ~F2~-pop   ~LTR~-cmd  ~ESC~-return  '+
                        '                  ~'^X^Y'~-hilight  ~CR~-select';
  MsgLine[ord(DW_ML)] :=' ~F1~-help  ~F2~-pop   ~F10~-top  ~ESC~-restore '+
                        '                              ~CR~-enter';
  MsgLine[ord(DE_ML)] :=' ~F1~-help  ~F2~-pull  ~F10~-top  ~ESC~-restore '+
                        '                              ~CR~-enter';
  MsgLine[ord(SeqML)] :=' ~F1~-help  ~F2~-pull  ~F10~-top              '+
                        '                              ~CR~-edit';
  MsgLine[ord(HelpML)]:=' ~F1~-return         ~LTR~-cmd  ~ESC~-return';
  MsgLine[ord(ProcML)]:=' Processing ...';
  MsgLine[ord(DirML)] :=' ~F1~-help  ~F2~-pop   ~F10~-top  ~ESC~-return  '+
                        '              ~LTR/'^X^Y'~-hilight  ~CR~-select';
  {$endif UseMsgLineCode }

end;  { procedure GetUserPullStats }

{ =========================== GetOverrideStats ============================= }
{ You can OVERRIDE the automatic Colors, Sizes, and Locations here.          }
{ -------------------------------------------------------------------------- }

procedure GetOverrideStats;
begin
  with DirectoryMenu do
    begin
      Title   := 'Directory';       { Optional }
      MenuLines := CRTrows-7;
      Row  := 4;
      Rows := CRTrows-5;
      with MainMenu^[ord(FilesMenu)] do
        DirectoryMenu.Col := Col+Cols-2;
      Cols   := 16;
      Battr  := BrownBG;
      Wattr  := BrownBG;
      if QvideoMode=Mono then
           Hattr := LightGrayBG
      else Hattr := Yellow;
      Border := SubMenuBrdr;
      LinkDir := Right;
      MsgLineNum  := ord(DirML);
      HelpWndwNum := ord(DirMenuHW);
    end;

  {$ifdef UseSubMenuCode }
  with SubMenu^[ord(BrandsMenu)] do
    begin
      Wattr := Black+BrownBG;
      Battr := Black+BrownBG;
      if QVideoMode<>Mono then
        begin
          Hattr := Yellow+BlackBG;
          Lattr := Yellow+BrownBG;
        end;
    end;
  {$endif UseSubMenuCode }

end;

{ ========================= CHECK GLOBAL KEYS ============================== }
{ This procedure gives you the option to add global keys similar to IDE such }
{ as Alt-R or Alt-F3.  This is for extended keys only.                       }
{ -------------------------------------------------------------------------- }

const
  AltF    = #33;    { Files menu }
  AltC    = #46;    { Colors menu }
  AltA    = #30;    { AutoParts menu }
  AltE    = #18;    { EnterData menu }
  AltO    = #24;    { Options menu }
  AltU    = #22;    { Utilities menu }
  AltI    = #23;    { IRSaccounting menu }
  AltQ    = #16;    { Quit menu }
  AltD    = #32;    { Directory menu }
  AltP    = #25;    { Path Data entry }
  AltX    = #45;    { Immediately exit program }
  Alt1    = #120;   { For Work Window 1 }
  Alt2    = #121;   { For Work Window 2 }

procedure SetWorkWndw (WN: WindowNames);
begin
  PullDown        := false;
  PopToWorkWndw   := true;
  TopWorkWndwName := WN;
end;

{ -- Any of the keys can be modified. PopKey and TopKey1 are defined in }
{ -- PullVars.inc. }
procedure CheckGlobalKeys;
begin
  PullDown := true;
  case Key of
    PopKey:  begin PullDown:=false; PopToWorkWndw:=true; end; { F2 }
    TopKey1: PopToTop:=true;                                  { F10 }
    AltF:    SetCmdSeq ('F');
    AltC:    SetCmdSeq ('C');
    AltA:    SetCmdSeq ('A');
    AltE:    SetCmdSeq ('E');
    AltO:    SetCmdSeq ('O');
    AltU:    SetCmdSeq ('U');
    AltI:    SetCmdSeq ('I');
    AltQ:    SetCmdSeq ('Q');
    AltD:    SetCmdSeq ('FD');
    AltP:    SetCmdSeq ('FP');
    AltX:    SetQuit;
  else
    PullDown := false;
  end
end;

BEGIN
  CallGetUserPullStats := GetUserPullStats;
  CallGetOverrideStats := GetOverrideStats;
  CallCheckGlobalKeys  := CheckGlobalKeys;
END.
