{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Sample Application                           	     	*}
{*                                                                    *}
{*		 for Borland Pascal v7.0 and Turbo Pascal for Windows v1.5   		*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{*		 You are free to use, modify, reproduce and distribute the      *}
{*		 Sample Files (and/or any modified version) in any way you      *}
{*		 find useful.						                                        *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application    := Basic MWCC Window

	Files          := MWCCWin.pas

	Units Required := MWCC and MWCC.dll

	Tabs           := 2

	Screen         := 800 * 600

	Date           := June, 1993.

	The TMWCCWindow object is a very versatile window. The least thing it does is draw
	a raised border around the client area. By changing the bitmap name or the boolean
	values in the InitMainWindow method you can give the client area a BWCC or MWCC
	pattern, add an SFX style frame or prevent the window from being resized. If you
	don't plan to add an SFX style frame you could either use ws_EX_DlgModalFrame
	(Attr.ExStyle) or not use a frame at all.

	Warning - Don't overide any inherited methods (not listed here) without first consulting
	          the documentation.

***}

program MWCCWin;

uses WinTypes, WinProcs, MWCC,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

	AppName : PChar = 'NewMWCCWindow';

type

	PNewMWCCApplication = ^TNewMWCCApplication;
	TNewMWCCApplication = object(TApplication)
		procedure InitMainWindow; virtual;
	end;

	PNewMWCCWindow = ^TNewMWCCWindow;
	TNewMWCCWindow = object(TMWCCWindow)
		constructor Init(AParent: PWindowsObject; AName, ABmp: PChar);
	  destructor Done; virtual;
	  function GetClassName : PChar; virtual;
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure Paint(PaintDC : hDC; var PS : TPaintStruct); virtual;
	end;

{********** TNewMWCCApplication **********}

procedure TNewMWCCApplication.InitMainWindow;
begin
	MainWindow := New(PNewMWCCWindow, Init(nil, 'MWCC Window', nil));
end;

{********** TNewMWCCWindow **********}

constructor TNewMWCCWindow.Init(AParent: PWindowsObject; AName, ABmp: PChar);
begin
	TMWCCWindow.Init(AParent, AName, ABmp);
	Attr.Style := Attr.Style;
	Attr.X := GetSystemMetrics(sm_CXScreen) div 4;
	Attr.Y := (GetSystemMetrics(sm_CYScreen) div 4);
	Attr.W := GetSystemMetrics(sm_CXScreen) div 2;
	Attr.H := (GetSystemMetrics(sm_CYScreen) div 2);
  {IsSizeable := False;}
  {SFXFrame := True;}
end;

destructor TNewMWCCWindow.Done;
begin
	TMWCCWindow.Done;
end;

function TNewMWCCWindow.GetClassName;
begin
  GetClassName := AppName;
end;

procedure TNewMWCCWindow.GetWindowClass(var AWndClass: TWndClass);
begin
	TMWCCWindow.GetWindowClass(AWndClass);
end;

procedure TNewMWCCWindow.SetUpWindow;
begin
	TMWCCWindow.SetUpWindow;
end;

procedure TNewMWCCWindow.Paint(PaintDC : HDC; var PS: TPaintStruct);
begin
	TMWCCWindow.Paint(PaintDC, PS);
end; 

{********** Main program **********}

var
	MWCCApp: TNewMWCCApplication;
begin
  MWCCApp.Init(AppName);
  MWCCApp.Run;
  MWCCApp.Done;
end.
