{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Custom Control Library                           		*}
{*                                                                    *}
{*		 Version 1.01                                                 		*}
{*                                                                    *}
{*     Object Windows Library Extension for Borland Pascal v7.0       *}
{*                                                                    *}
{*     and Turbo Pascal for Windows v 1.5                             *}
{*                                                                    *}
{*		 Wintools Unit : Miscellaneous Functions and Procedures         *}
{*                                                                    *}
{**********************************************************************}

{*** Tabs := 2 ***}

unit WinTools;

{$C Moveable Demandload Discardable}

{********** Interface **********}

interface

uses WinTypes, WinProcs;

procedure CenterOverClient (ParentWnd, Wnd: HWnd);

procedure CenterOverWindow (ParentWnd, Wnd: HWnd);

procedure CenterOverScreen (Wnd: HWnd);

{********** Implementation **********}

implementation

procedure CenterOverClient (ParentWnd, Wnd: HWnd);
var
	CRect, WinRect: TRect;
	CPt           : TPoint;
	lStyle        : LongInt;
	X, Y, W, H, XScreen, YScreen : Integer;
begin
	XScreen := GetSystemMetrics (sm_CXScreen);
	YScreen := GetSystemMetrics (sm_CYScreen);
	GetClientRect(ParentWnd, CRect);
	with CRect do
	begin
		CPt.X := Left;
		CPt.Y := Top;
		W     := Right;
		H     := Bottom;
	end;
	lStyle := GetWindowLong(Wnd, gwl_Style);
	if lStyle = lStyle and (not ws_Child) and (not ws_ChildWindow) then
		ClientToScreen(ParentWnd, CPt);
	GetWindowRect (Wnd, WinRect);
	with WinRect do
	begin
		X := CPt.X + (W - (Right - Left)) div 2;
		Y := CPt.Y + (H - (Bottom - Top)) div 2;
		if X < 0 then X := 0;
		if (X + (Right - Left)) > XScreen then X := XScreen - (Right - Left);
		if Y < 0 then Y := 0;
		if (Y + (Bottom - Top)) > YScreen then Y := YScreen - (Bottom - Top);
	end;
	SetWindowPos(Wnd, 0, X, Y, 0, 0, swp_NoSize or swp_NoZOrder);
end;

procedure CenterOverWindow (ParentWnd, Wnd: HWnd);
var
	WinRect : TRect;
	X1, Y1, W1, H1, X2, Y2, XScreen, YScreen : Integer;
begin
	XScreen := GetSystemMetrics (sm_CXScreen);
	YScreen := GetSystemMetrics (sm_CYScreen);
	GetWindowRect(ParentWnd, WinRect);
	with WinRect do
	begin
		X1 := Left;
		Y1 := Top;
		W1 := Right - Left;
		H1 := Bottom - Top ;
	end;
	GetWindowRect (Wnd, WinRect);
	with WinRect do
	begin
		X2 := X1 + ((W1 - (Right - Left)) div 2);
		Y2 := Y1 + ((H1 - (Bottom - Top)) div 2);
		if X2 < 0 then X2 := 0;
		if (X2 + (Right - Left)) > XScreen then X2 := XScreen - (Right - Left);
		if Y2 < 0 then Y2 := 0;
		if (Y2 + (Bottom - Top)) > YScreen then Y2 := YScreen - (Bottom - Top);
	end;
	SetWindowPos(Wnd, 0, X2, Y2, 0, 0, swp_NoSize or swp_NoZOrder);
end;

procedure CenterOverScreen (Wnd: HWnd);
var
	WinRect: TRect;
	X, Y, W, H, XScreen, YScreen : Integer;
begin
	XScreen := GetSystemMetrics (sm_CXScreen);
	YScreen := GetSystemMetrics (sm_CYScreen);
	GetWindowRect (Wnd, WinRect);
	with WinRect do
	begin
		X := Left;
		Y := Top;
		W := Right - X;
		H := Bottom - Y;
 end;
 SetWindowPos(Wnd, 0, (XScreen - W) div 2, (YScreen - H) div 2, 0, 0, swp_NoSize or swp_NoZOrder);
end;

begin
end.

