@echo off
REM  Installation script for Windev on Windows 3.1 or NT.

if not "%1" == "" goto install
@echo Usage: INSTALL destination-directory
goto end

:install
if not "%windir%" == "" goto setos
set windir=C:\WINDOWS

:setos
set destdir=%1\windev
if exist windevpj.pif goto setwin3
@echo Installing Windev for Windows NT
set os=nt
goto mkdirs

:setwin3
@echo Installing Windev for Windows 3.1
set os=win3

:mkdirs
mkdir %destdir%
mkdir %destdir%\%os%

REM --- O/S specific, common named files.
echo Copying to %destdir%\%os% ...
echo readme.txt...
copy readme.txt %destdir%\%os%
if not exist %destdir%\%os%\readme.txt goto copyerr
echo windev.exe...
copy windev.exe %destdir%\%os%
if not exist %destdir%\%os%\windev.exe goto copyerr
if exist windev.reg copy windev.reg %destdir%\%os%

if "%os%" == "nt" goto ntfiles
REM --- Windows 3 specific files.
echo stbar.dll...
copy stbar.dll %destdir%\%os%
if not exist %destdir%\%os%\stbar.dll goto copyerr
echo Copying windevpj.pif to %windir%
copy windevpj.pif %windir%
if not exist %windir%\windevpj.pif goto copyerr
if exist %windir%\system\ctl3d.dll goto shared
echo Copying ctl3d.dll to %windir%\system
copy ctl3d.dll %windir%\system
goto shared

:ntfiles
REM --- Windows NT specific files.
echo projexec.exe...
copy projexec.exe %destdir%\%os%
if not exist %destdir%\%os%\projexec.exe goto copyerr
if exist %windir%\system\ctl3d32.dll goto shared
echo Copying ctl3d32.dll to %windir%\system
copy ctl3d32.dll %windir%\system

:shared
REM --- Common files.
echo Copying to %destdir% ...
echo windev.hlp...
copy windev.hlp %destdir%
if not exist %destdir%\windev.hlp goto copyerr
echo license.txt...
copy license.txt %destdir%
if not exist %destdir%\license.txt goto copyerr
echo changes.txt...
copy changes.txt %destdir%
if not exist %destdir%\changes.txt goto copyerr
echo features.wri...
copy features.wri %destdir%
if not exist %destdir%\features.wri goto copyerr

@echo ---------------------------------------------------------
@echo Windev has been successfully installed in %destdir%
@echo Please read %os%\readme.txt before starting use.
@echo Use Program Manager to add windev.exe to a program group.
@echo ---------------------------------------------------------
goto end

:copyerr
@echo File copy error, abandoning installation.

:end
