///////////////////////////////////////////////////////////////////////////////
//
// WinDialog - Sample showing the support of dialog boxes created with WinDialog 
//
// 93/03/20    Snke Cordts
//
///////////////////////////////////////////////////////////////////////////////

#include <windows.h>

#include "NWDialog.h"

  // Prototypes
BOOL CALLBACK _export SampleDialogproc (HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);


///////////////////////////////////////////////////////////////////////////////
// Function: WinMain
//
// Description: Program entry point
///////////////////////////////////////////////////////////////////////////////
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{

    int nReturn;
    DLGPROC dlgProc=(DLGPROC)MakeProcInstance((FARPROC)SampleDialogproc, hInstance);

    nReturn=dlgDialogBox(hInstance, "MICROSFT.FRM", NULL, dlgProc);

    FreeProcInstance((FARPROC)dlgProc);
    return(nReturn);
}

///////////////////////////////////////////////////////////////////////////////
// Function: SampleDialogproc
//
// Description: Callbackfunction of the dialogbox
///////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK _export SampleDialogproc (HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
    switch (msg)
    {
    case WM_COMMAND:
	switch(wParam)
	{
	case IDOK:
	case IDCANCEL:
	    dlgEndDialog(hDlg, wParam==IDOK);
	    break;
	}
	return (TRUE);
    }
    return (FALSE);
}

