///////////////////////////////////////////////////////////////////////////////
//
// WinDialog - Advanced sample showing the support of dialog boxes created 
//             with WinDialog 
//
// 93/03/20    Soenke Cordts
//
///////////////////////////////////////////////////////////////////////////////

#include <windows.h>

#include "NWDialog.h"

  // Definitions
#define MAXSTRINGLEN 255
#define IDD_IMG_AUTHOR   100
#define IDD_TX_AUTHOR    101
#define IDD_LB_AUTHOR    102
typedef struct tagAUTHOR
{
    char szImage[MAXSTRINGLEN];
    char szAuthor[MAXSTRINGLEN];
}AUTHOR;

  // Variables
static HINSTANCE _hInst;

  // Prototypes
BOOL CALLBACK _export AuthorDialogproc (HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);


///////////////////////////////////////////////////////////////////////////////
// Function: WinMain
//
// Description: Program entry point
///////////////////////////////////////////////////////////////////////////////
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{

    int nReturn;
    DLGPROC dlgProc=(DLGPROC)MakeProcInstance((FARPROC)AuthorDialogproc, hInstance);
    _hInst = hInstance;

    nReturn=dlgDialogBox(hInstance, "AUTHOR.FRM", NULL, dlgProc);

    FreeProcInstance((FARPROC)dlgProc);
    return(nReturn);
}

///////////////////////////////////////////////////////////////////////////////
// Function: AuthorDialogproc
//
// Description: Callbackfunction of the dialogbox
///////////////////////////////////////////////////////////////////////////////
BOOL CALLBACK _export AuthorDialogproc (HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
    static AUTHOR Author[8]=
		{{"AUTHOR1.BMP", "Ernest Hemingway"},
		 {"AUTHOR2.BMP", "Willi Heinrich"},
		 {"AUTHOR3.BMP", "Samuel Beckett"},
		 {"AUTHOR4.BMP", "Margret Mitchell"},
		 {"AUTHOR5.BMP", "Guenther Grass"},
		 {"AUTHOR6.BMP", "Erich Maria Remarque"},
		 {"AUTHOR7.BMP", "Wiliam Faulkner"}};
    int    i;


    switch (msg)
    {
    case WM_INITDIALOG:
	  // fill listbox with names of the authors
	for(i=0; i<(sizeof(Author)/sizeof(AUTHOR)); i++)
	    SendDlgItemMessage(hDlg, IDD_LB_AUTHOR, LB_ADDSTRING, 0, (LPARAM)(LPSTR)Author[i].szAuthor);
	SendDlgItemMessage(hDlg, IDD_LB_AUTHOR, LB_SETCURSEL, 0, 0L);
	break;
    case WM_SETCURSOR:
	  // move dialog box only, if not in listbox
	if((HWND)wParam==GetDlgItem(hDlg, IDD_LB_AUTHOR))
	    break;
	if(HIWORD(lParam)==WM_LBUTTONDOWN)
	{
	      // move dialog to new position
	   SendMessage(hDlg, WM_SYSCOMMAND, SC_MOVE | 0x0002, 0L);
	   return(TRUE);
	}
	if(LOWORD(lParam)==HTCLIENT)
	{
	   SetCursor(LoadCursor(_hInst, "HAND"));
	   return(TRUE);
	}
	break;

    case WM_COMMAND:
	switch(wParam)
	{
	case IDD_LB_AUTHOR:
	      // show new image and new name of author
	    if(HIWORD(lParam)==LBN_SELCHANGE)
	    {
		GLOBALHANDLE gh=GlobalAlloc(GHND, MAXSTRINGLEN);
		i = (UINT)SendMessage((HWND)LOWORD(lParam), LB_GETCURSEL, 0, 0L);
		  // set new name
		SetDlgItemText(hDlg, IDD_TX_AUTHOR, Author[i].szAuthor);
		if(gh)
		{
		    LPSTR lpszAuthor=GlobalLock(gh);
		    HWND  hwndImage=GetDlgItem(hDlg, IDD_IMG_AUTHOR);

		      // load new image into image control
		    lstrcpy(lpszAuthor, Author[i].szImage);
		    GlobalUnlock(gh);
		    SendMessage(hDlg, WM_PAINTBITMAP, 0, MAKELPARAM(hwndImage, gh));
		    GlobalFree(gh);
		}
	    }
	    break;
	case IDCANCEL:
	    dlgEndDialog(hDlg, wParam==IDOK);
	    break;
	}
	return(TRUE);
    }
    return(FALSE);
}

