#define Uses_TApplication
#define Uses_TEvent
#define Uses_MsgBox
#include <tv.h>
#include "PrintApp.h"
#include <io.h>

PrintQueue* TPrintApp::printQueue = 0;

TPrintApp::TPrintApp() :
		TProgInit(initStatusLine, initMenuBar, initDeskTop),
		TPrintAppInit(initPrintQueue)
	{
	printQueue = (createPrintQueue != 0) ? createPrintQueue() : 0;
	}

void TPrintApp::shutDown()
	{
	delete printQueue;
	printQueue = 0;
	TApplication::shutDown();
	}

void TPrintApp::idle()
	{
	TApplication::idle();
	if(printQueue != 0)
		printQueue->print();
	}

Boolean TPrintApp::valid(ushort cmd)
	{
	if(cmd == cmQuit && printQueue != 0 && printQueue->currentJob() != 0)
		{
		if(messageBox("Still printing - cancel all printing?", mfYesNoCancel|mfWarning) == cmYes)
			{
			printQueue->killAll();
			return True;
			}
		else
			return False;
		}
	else
		return TApplication::valid(cmd);
	}

void TPrintApp::handleEvent(TEvent& event)
	{
	TApplication::handleEvent(event);
	if(event.what == evCommand && event.message.command == cmAddPrintJob)
		{
		PrintJob* pj = (PrintJob*) event.message.infoPtr;
		if(pj != 0 && pj->complete())
			{
			delete pj;
			pj = 0;
			}
		if(pj != 0 && printQueue != 0 && printQueue->insert(pj))
			clearEvent(event);
		else
			delete pj;
		}
	}

PrintQueue* TPrintApp::initPrintQueue()
	{
	return new TPrintQueue;
	}

int TPrintQueue::printString(const char* str, int length) const
	{
	return write(4, str, length);
	}
