/**************************************************************************
*  WinDosIO.h
*  These functions allow standard IO compatability when executing under
*  Microsoft Windows 3.0. They represent the complete interface to the
*  Graubart-Cervone WinDosIO library.
*  Copyright 1991, Graubart-Cervone Software
***************************************************************************/
#if !defined(WINDOSIO_H )
#define WINDOSIO_H

#define _NOCURSOR      0
#define _SOLIDCURSOR   1
#define _NORMALCURSOR  2
#define _USERCURSOR    99


struct text_info {
    unsigned char winleft;
    unsigned char wintop;
    unsigned char winright;
    unsigned char winbottom;
    unsigned char attribute;
    unsigned char normattr;
    unsigned char currmode;
    unsigned char screenheight;
    unsigned char screenwidth;
    unsigned char curx;
    unsigned char cury;
};

enum text_modes { LASTMODE=-1, BW40=0, C40, BW80, C80, MONO=7, C4350=64 };




enum graphics_errors {		/* graphresult error return codes */
	grOk		   =   0,
	grNoInitGraph	   =  -1,
	grNotDetected	   =  -2,
	grFileNotFound	   =  -3,
	grInvalidDriver    =  -4,
	grNoLoadMem	   =  -5,
	grNoScanMem	   =  -6,
	grNoFloodMem	   =  -7,
	grFontNotFound	   =  -8,
	grNoFontMem	   =  -9,
	grInvalidMode	   = -10,
	grError 	   = -11,   /* generic error */
	grIOerror	   = -12,
	grInvalidFont	   = -13,
	grInvalidFontNum   = -14,
	grInvalidVersion   = -18,
	grMSParameter	   = -40,
	grMSImage	   = -41,
	grMSNoOutput	   = -42,
	grMSClipped	   = -43,
	grMSParmAltered    = -44
};

enum graphics_drivers { 	/* define graphics drivers */
	DETECT, 		/* requests autodetection */
	CGA, MCGA, EGA, EGA64, EGAMONO, IBM8514,	/* 1 - 6 */
	HERCMONO, ATT400, VGA, PC3270,			/* 7 - 10 */
	CURRENT_DRIVER = -1
};

enum graphics_modes {		/* graphics modes for each driver */
    CGAC0      = 0,  /* 320x200 palette 0; 1 page	*/
    CGAC1      = 1,  /* 320x200 palette 1; 1 page	*/
    CGAC2      = 2,  /* 320x200 palette 2: 1 page	*/
    CGAC3      = 3,  /* 320x200 palette 3; 1 page	*/
    CGAHI      = 4,  /* 640x200 1 page			*/
    MCGAC0     = 0,  /* 320x200 palette 0; 1 page	*/
    MCGAC1     = 1,  /* 320x200 palette 1; 1 page	*/
    MCGAC2     = 2,  /* 320x200 palette 2; 1 page	*/
    MCGAC3     = 3,  /* 320x200 palette 3; 1 page	*/
    MCGAMED    = 4,  /* 640x200 1 page			*/
    MCGAHI     = 5,  /* 640x480 1 page			*/
    EGALO      = 0,  /* 640x200 16 color 4 pages	*/
    EGAHI      = 1,  /* 640x350 16 color 2 pages	*/
    EGA64LO    = 0,  /* 640x200 16 color 1 page 	*/
    EGA64HI    = 1,  /* 640x350 4 color  1 page 	*/
    EGAMONOHI  = 0,  /* 640x350 64K on card, 1 page - 256K on card, 4 pages */
    HERCMONOHI = 0,  /* 720x348 2 pages 		*/
    ATT400C0   = 0,  /* 320x200 palette 0; 1 page	*/
    ATT400C1   = 1,  /* 320x200 palette 1; 1 page	*/
    ATT400C2   = 2,  /* 320x200 palette 2; 1 page	*/
    ATT400C3   = 3,  /* 320x200 palette 3; 1 page	*/
    ATT400MED  = 4,  /* 640x200 1 page			*/
    ATT400HI   = 5,  /* 640x400 1 page			*/
    VGALO      = 0,  /* 640x200 16 color 4 pages	*/
    VGAMED     = 1,  /* 640x350 16 color 2 pages	*/
    VGAHI      = 2,  /* 640x480 16 color 1 page 	*/
    PC3270HI   = 0,  /* 720x350 1 page			*/
    IBM8514LO  = 0,  /* 640x480 256 colors		*/
    IBM8514HI  = 1   /*1024x768 256 colors		*/
};

/* Colors for setpalette and setallpalette */

#if	!defined(__COLORS)
#define __COLORS

enum COLORS {
    BLACK,		    /* dark colors */
    BLUE,
    GREEN,
    CYAN,
    RED,
    MAGENTA,
    BROWN,
    LIGHTGRAY,
    DARKGRAY,		    /* light colors */
    LIGHTBLUE,
    LIGHTGREEN,
    LIGHTCYAN,
    LIGHTRED,
    LIGHTMAGENTA,
    YELLOW,
    WHITE
};
#endif

enum CGA_COLORS {
    CGA_LIGHTGREEN     = 1,		/* Palette C0 Color Names	*/
    CGA_LIGHTRED       = 2,
    CGA_YELLOW	       = 3,

    CGA_LIGHTCYAN      = 1,		/* Palette C1 Color Names	*/
    CGA_LIGHTMAGENTA   = 2,
    CGA_WHITE	       = 3,

    CGA_GREEN	       = 1,		/* Palette C2 Color Names	*/
    CGA_RED	       = 2,
    CGA_BROWN	       = 3,

    CGA_CYAN	       = 1,		/* Palette C3 Color Names	*/
    CGA_MAGENTA        = 2,
    CGA_LIGHTGRAY      = 3
};


enum EGA_COLORS {
    EGA_BLACK		 =  0,	    /* dark colors */
    EGA_BLUE		 =  1,
    EGA_GREEN		 =  2,
    EGA_CYAN		 =  3,
    EGA_RED		 =  4,
    EGA_MAGENTA 	 =  5,
    EGA_BROWN		 =  20,
    EGA_LIGHTGRAY	 =  7,
    EGA_DARKGRAY	 =  56,     /* light colors */
    EGA_LIGHTBLUE	 =  57,
    EGA_LIGHTGREEN	 =  58,
    EGA_LIGHTCYAN	 =  59,
    EGA_LIGHTRED	 =  60,
    EGA_LIGHTMAGENTA	 =  61,
    EGA_YELLOW		 =  62,
    EGA_WHITE		 =  63
};

enum line_styles {		/* Line styles for get/setlinestyle */
	SOLID_LINE   = 0,
	DOTTED_LINE  = 1,
	CENTER_LINE  = 2,
	DASHED_LINE  = 3,
	USERBIT_LINE = 4,	/* User defined line style */
	DASHDOT_LINE = 5,
	DASHDOTDOT_LINE = 6
};

enum line_widths {		/* Line widths for get/setlinestyle */
	NORM_WIDTH  = 1,	/* WinDosIO allows any line thickness */
	THICK_WIDTH = 3,	/* Mneumonics for compatability only */
};

enum font_names {
	DEFAULT_FONT	= 0,	/* 8x8 bit mapped font */
	TRIPLEX_FONT	= 1,	/* "Stroked" fonts */
	SMALL_FONT	= 2,
	SANS_SERIF_FONT = 3,
	GOTHIC_FONT	= 4,
	MICROSTYLE_FONT = 99
};

#define HORIZ_DIR	0	/* left to right */
#define VERT_DIR	1	/* bottom to top */

#define USER_CHAR_SIZE	0	/* user-defined char size */

enum fill_patterns {		/* Fill patterns for get/setfillstyle */
	EMPTY_FILL,		/* fills area in background color */
	SOLID_FILL,		/* fills area in solid fill color */
	LINE_FILL,		/* --- fill */
	LTSLASH_FILL,		/* /// fill */
	SLASH_FILL,		/* /// fill with thick lines */
	BKSLASH_FILL,		/* \\\ fill with thick lines */
	LTBKSLASH_FILL, 	/* \\\ fill */
	HATCH_FILL,		/* light hatch fill */
	XHATCH_FILL,		/* heavy cross hatch fill */
	INTERLEAVE_FILL,	/* interleaving line fill */
	WIDE_DOT_FILL,		/* Widely spaced dot fill */
	CLOSE_DOT_FILL, 	/* Closely spaced dot fill */
	USER_FILL		/* user defined fill */
};

enum putimage_ops {		/* BitBlt operators for putimage */
	COPY_PUT,		/* MOV */
	XOR_PUT,		/* XOR */
	OR_PUT, 		/* OR  */
	AND_PUT,		/* AND */
	NOT_PUT 		/* NOT */
};

enum text_just {		/* Horizontal and vertical justification
				   for settextjustify */
	LEFT_TEXT	= 0,
	CENTER_TEXT	= 1,
	RIGHT_TEXT	= 2,

	BOTTOM_TEXT	= 0,
     /* CENTER_TEXT	= 1,  already defined above */
	TOP_TEXT	= 2
};


#define MAXCOLORS 15
#define MAXPAGES  4

struct palettetype {
	unsigned char size;
	signed char colors[MAXCOLORS+1];
};

struct linesettingstype {
	int linestyle;
	unsigned upattern;
	int thickness;
};

struct textsettingstype {
	int font;
	int direction;
	int charsize;
	int horiz;
	int vert;
};

struct fillsettingstype {
	int pattern;
	int color;
};

struct pointtype {
	int x, y;
};

struct viewporttype {
	int left, top, right, bottom;
	int clip;
};

struct arccoordstype {
	int x, y;
	int xstart, ystart, xend, yend;
};

struct CWS {
	char far *cwsTitle;
	unsigned long cwsFlags;
	short cwsLeft;
	short cwsTop;
	short cwsXSize;
	short cwsYSize;
};



#if !defined( __DEFS_H )
#include <_defs.h>
#endif

#ifndef NULL
#include <_null.h>
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned size_t;
#endif

/* Definition of the file position type
*/
typedef long    fpos_t;


/* Definition of the control structure for streams
*/
typedef struct  {
        int             level;          /* fill/empty level of buffer */
        unsigned        flags;          /* File status flags          */
        char            fd;             /* File descriptor            */
        unsigned char   hold;           /* Ungetc char if no buffer   */
        int             bsize;          /* Buffer size                */
        unsigned char   _FAR *buffer;   /* Data transfer buffer       */
        unsigned char   _FAR *curp;     /* Current active pointer     */
        unsigned        istemp;         /* Temporary file indicator   */
        short           token;          /* Used for validity checking */
}       FILE;                           /* This is the FILE object    */

/* Bufferisation type to be used as 3rd argument for "setvbuf" function
*/
#define _IOFBF  0
#define _IOLBF  1
#define _IONBF  2

/*  "flags" bits definitions
*/
#define _F_RDWR 0x0003                  /* Read/write flag       */
#define _F_READ 0x0001                  /* Read only file        */
#define _F_WRIT 0x0002                  /* Write only file       */
#define _F_BUF  0x0004                  /* Malloc'ed Buffer data */
#define _F_LBUF 0x0008                  /* line-buffered file    */
#define _F_ERR  0x0010                  /* Error indicator       */
#define _F_EOF  0x0020                  /* EOF indicator         */
#define _F_BIN  0x0040                  /* Binary file indicator */
#define _F_IN   0x0080                  /* Data is incoming      */
#define _F_OUT  0x0100                  /* Data is outgoing      */
#define _F_TERM 0x0200                  /* File is a terminal    */

/* End-of-file constant definition
*/
#define EOF (-1)            /* End of file indicator */

/* Number of files that can be open simultaneously
*/
#if __STDC__
#define FOPEN_MAX 18        /* Able to have 18 files (20 - stdaux & stdprn) */
#else
#define FOPEN_MAX 20        /* Able to have 20 files */
#define SYS_OPEN  20
#endif

#define FILENAME_MAX 80

/* Default buffer size use by "setbuf" function
*/
#define BUFSIZ  512         /* Buffer size for stdio */

/* Size of an arry large enough to hold a temporary file name string
*/
#define L_ctermid   5       /* CON: plus null byte */
#define P_tmpdir    ""      /* temporary directory */
#define L_tmpnam    13      /* tmpnam buffer size */

/* Constants to be used as 3rd argument for "fseek" function
*/
#define SEEK_CUR    1
#define SEEK_END    2
#define SEEK_SET    0

/* Number of unique file names that shall be generated by "tmpnam" function
*/
#define TMP_MAX     0xFFFF

/* Standard I/O predefined streams
*/

#if !defined( _RTLDLL )
extern  FILE    _Cdecl _streams[];
extern  unsigned    _Cdecl _nfile;

#define stdin   (&_streams[0])
#define stdout  (&_streams[1])
#define stderr  (&_streams[2])

#if !__STDC__
#define stdaux  (&_streams[3])
#define stdprn  (&_streams[4])
#endif

#else

#ifdef __cplusplus
extern "C" {
#endif
FILE far * far __getStream(int);
#ifdef __cplusplus
}
#endif

#define stdin   __getStream(0)
#define stdout  __getStream(1)
#define stderr  __getStream(2)
#define stdaux  __getStream(3)
#define stdprn  __getStream(4)

#endif


#ifdef __cplusplus
extern "C" {
#endif

/* Stdio functions which are not redefined in the WinDosIO DLL */
int     _Cdecl _FARFUNC sprintf(char _FAR *__buffer, const char _FAR *__format, ...);
int     _Cdecl _FARFUNC sscanf(const char _FAR *__buffer,
                      const char _FAR *__format, ...);

char   _FAR *_Cdecl _FARFUNC strerror(int __errnum);
FILE   _FAR *_Cdecl _FARFUNC tmpfile(void);
char   _FAR *_Cdecl _FARFUNC tmpnam(char _FAR *__s);
int     _Cdecl _FARFUNC vfprintf(FILE _FAR *__stream, const char _FAR *__format,
                        void _FAR *__arglist);
int     _Cdecl _FARFUNC vfscanf(FILE _FAR *__stream, const char _FAR *__format,
                        void _FAR *__arglist);
int     _Cdecl _FARFUNC vsprintf(char _FAR *__buffer, const char _FAR *__format,
                        void _FAR *__arglist);
int     _Cdecl _FARFUNC vsscanf(const char _FAR *__buffer, const char _FAR *__format,
                        void _FAR *__arglist);
int     _CType unlink(const char _FAR *__path);

#if !__STDC__
int     _Cdecl _FARFUNC fcloseall(void);
FILE   _FAR *_Cdecl _FARFUNC fdopen(int __handle, char _FAR *__type);
int     _Cdecl _FARFUNC fputchar(int __c);
FILE   _FAR * _Cdecl _fsopen (const char _FAR *__path, const char _FAR *__mode,
                  int __shflag);
int     _Cdecl rmtmp(void);
char   _FAR * _Cdecl _FARFUNC tempnam(char _FAR *__dir, char _FAR *__pfx);

#define fileno(f)       ((f)->fd)
#endif

#ifdef  __cplusplus
}
#endif




#ifdef __cplusplus
extern "C" {
#endif
int main(int argc, char *argv[]);
int cdecl far printf(const char far *formatString,...);
int cdecl far cprintf(const char far *formatString,...);
int cdecl far vprintf(const char far *formatString, void far *pArguments);
int cdecl far scanf(const char far *formatString,...);
int cdecl far cscanf(const char far *formatString,...);
int cdecl far vscanf(const char far *formatString, void far *pArguments);
int cdecl far puts(const char far *str);
int cdecl far cputs(const char far *str);
void cdecl far gotoxy(int x, int y);
void cdecl far window(int left, int top, int right, int bottom);
void cdecl far gettextinfo(struct text_info far *t);
int cdecl far gettext(int left,int top, int right, int bottom, void far *dest);
int cdecl far puttext(int left, int top, int right, int bottom, void far *src);
int cdecl far movetext(int left, int top, int right, int bottom,
						int destleft, int desttop);
void cdecl far highvideo(void);
void cdecl far lowvideo(void);
void cdecl far normvideo(void);
int cdecl far wherey(void);
int cdecl far wherex(void);
void cdecl far clreol(void);
void cdecl far insline(void);
void cdecl far delline(void);
void cdecl far scrolldownwindow(int rows, int left, int top, int right,
					int bottom);
void cdecl far scrollupwindow(int rows, int left, int top, int right,
					int bottom);
void cdecl far textmode(int newmode);
void cdecl far _setcursortype(int cur_t);
int cdecl far ungetch(int ch);
int cdecl far getch(void);
int cdecl far getche(void);
char far * cdecl far gets(char far *s);
char far * cdecl far cgets(char far *s);
char far * cdecl far getpass(char far *s);
void cdecl far clrscr(void);
int cdecl far putch(int c);
int cdecl far kbhit(void);
void cdecl far textattr(int newattr);
void cdecl far textbackground(int newcolor);
void cdecl far textcolor(int newcolor);
void cdecl far ReturnToApplication(int retCode);
int cdecl far ReturnToWindows(void);
int pascal far WinDosIO(short type, unsigned short wParam,
						 unsigned long lParam);
/* Graphics functions */
void cdecl far initgraph(int far * graphdriver, int far * graphmode,
				 char far *path);
void cdecl far detectgraph(int far *graphdriver, int far *graphmode);
int cdecl far registerbgifont(void (far *)(void));
int cdecl far registerbgidriver(void (far *)(void));
int cdecl far installuserdriver(char far *, int huge (*)(void));
unsigned cdecl far setgraphbufsize(unsigned);
int cdecl far installuserfont(char *);
void cdecl far restorecrtmode(void);
void cdecl far setgraphmode(int);
int cdecl far getgraphmode(void);
int cdecl far graphresult(void);
void cdecl far graphdefaults(void);
char far * cdecl far getdrivername(void);
char far * cdecl far getmodename(int mode_number);
void cdecl far getmoderange(int graphdriver, int far *lomode, int far *himode);
int cdecl far getmaxmode(void);
char far * cdecl far grapherrormsg(int errorcode);
void cdecl far setvisualpage(int page);
void cdecl far setactivepage(int page);
void cdecl far cleardevice(void);
void cdecl far closegraph(void);
void cdecl far setcolor(int color);
void cdecl far setbkcolor(int color);
int cdecl far getbkcolor(void);
int cdecl far getcolor(void);
int cdecl far getmaxx(void);
int cdecl far getmaxy(void);
int cdecl far getx(void);
int cdecl far gety(void);
void cdecl far putpixel(int x, int y, int color);
unsigned cdecl far getpixel(int x, int y);
unsigned cdecl far imagesize(int left, int top, int right, int bottom);
void cdecl far getimage(int left, int top, int right, int bottom,
				 void far *bitmap);
void cdecl far putimage(int left, int top, void far *bitmap, int op);
void cdecl far outtextxy(int x, int y, char far *textString);
void cdecl far outtext(char far *textString);
void cdecl far gettextsettings(struct textsettingstype far *textSettings);
int cdecl far textheight(char far *textstring);
int cdecl far textwidth(char far *textstring);
void cdecl far settextjustify(int horiz, int vert);
void cdecl far settextstyle(int font, int direction, int charsize);
void cdecl far setusercharsize(int multx, int divx, int multy, int divy);
void cdecl far moveto(int x, int y);
void cdecl far moverel(int x, int y);
void cdecl far lineto(int x, int y);
void cdecl far line(int x1, int y1, int x2, int y2);
void cdecl far linerel(int x, int y);
void cdecl far setlinestyle(int linestyle, unsigned upattern, int thickness);
void cdecl far setwritemode(int mode);
void cdecl far getlinesettings(struct linesettingstype far *lineinfo);
void cdecl far floodfill(int x, int y, int border);
void cdecl far rectangle(int left, int top, int right, int bottom);
void cdecl far circle(int x, int y, int radius);
void cdecl far arc(int x, int y, int stangle, int endangle, int radius);
void cdecl far getarccoords(struct arccoordstype far *arccoords);
void cdecl far fillellipse(int x, int y, int xradius, int yradius);
void cdecl far ellipse(int x, int y, int stangle, int endangle, 
					int xradius, int yradius);
void cdecl far sector(int x, int y, int stangle, int endangle, 
					int xradius, int yradius);
void cdecl far fillpoly(int numpoints, int far *polypoints);
void cdecl far drawpoly(int numpoints, int far *polypoints);
void cdecl far getaspectratio(int far *xasp, int far *yasp);
void cdecl far setaspectratio(int xasp, int yasp);
void cdecl far setviewport(int top, int left, int right, int bottom, int clip);
void cdecl far getviewsettings(struct viewporttype far *viewport);
void cdecl far clearviewport(void);
void cdecl far pieslice(int x, int y, int stangle, int endangle, int radius);
void cdecl far setfillstyle(int pattern, int color);
void cdecl far getfillpattern(char far *pattern);
void cdecl far getfillsettings(struct fillsettingstype far *fillInfo);
void cdecl far setfillpattern(char far *pattern, int color);
int cdecl far getmaxcolor(void);
int cdecl far getpalettesize(void);
struct palettetype far * cdecl far getdefaultpalette(void);
void cdecl far getpalette(struct palettetype far *palette);
void cdecl far setpalette(int colornum, int color);
void cdecl far setallpalette(struct palettetype far *palette);
void cdecl far bar(int left, int top, int right, int bottom);
void cdecl far bar3d(int left, int top, int right, int bottom, int depth,
						int topflag);
void cdecl far delay(unsigned milliseconds);
void cdecl far sleep(unsigned seconds);
/* Stdio functions */
void cdecl far  clearerr(FILE far *stream);
int cdecl far fclose(FILE far *stream);
int cdecl far fflush(FILE far *stream);
int cdecl far flushall(void);
int cdecl far fgetc(FILE far *stream);
int cdecl far fgetpos(FILE far *stream, fpos_t far *pos);
char far * cdecl far fgets(char far *s, int n, FILE far *stream);
int cdecl far fprintf(FILE far *stream, const char far *format, ...);
int cdecl far fscanf(FILE far *stream, const char far *format,...);
int cdecl far fputc(int c, FILE far *stream);
int cdecl far fputs(const char far *s, FILE far *stream);
size_t cdecl far fread(void far *ptr, size_t size, size_t n,FILE far *stream);
FILE far * cdecl far freopen(const char far *path, const char far *mode,
							 FILE far *stream);
int cdecl far fscanf(FILE far *stream, const char far *format, ...);
int cdecl far fseek(FILE far *stream, long offset, int whence);
int cdecl far fsetpos(FILE far *stream, const fpos_t far *pos);
long cdecl far ftell(FILE far *stream);
FILE far * cdecl far fopen(const char far *filename, const char far *mode);
size_t cdecl far fwrite(const void far *ptr, size_t size, size_t n,
				 FILE far *stream);
#undef ferror
#undef feof
int cdecl far ferror(FILE far *stream);
int cdecl far feof(FILE far *stream);
void cdecl far perror(const char far *s);
#undef getchar
#undef putchar
#undef getc
#undef putc
#define getchar() fgetc(stdin)
#define getc(s) fgetc(s)
#define putchar(c) fputc(c,stdout)
#define putc(c,s) fputc(c,s)

#ifndef _REG_DEFS
#define _REG_DEFS

struct WORDREGS {
    unsigned int    ax, bx, cx, dx, si, di, cflag, flags;
};

struct BYTEREGS {
    unsigned char   al, ah, bl, bh, cl, ch, dl, dh;
};

union   REGS    {
    struct  WORDREGS x;
    struct  BYTEREGS h;
};

struct  SREGS   {
    unsigned int    es;
    unsigned int    cs;
    unsigned int    ss;
    unsigned int    ds;
};

struct  REGPACK {
    unsigned    r_ax, r_bx, r_cx, r_dx;
    unsigned    r_bp, r_si, r_di, r_ds, r_es, r_flags;
};

#endif	/* _REG_DEFS */



int cdecl far intdos( union REGS far *__inregs,
                           union REGS far *__outregs );
int cdecl far intdosx( union REGS far *__inregs,
                            union REGS far *__outregs,
                            struct SREGS far *__segregs );
int cdecl far int86(int intno, union REGS far *inregs,
			       union REGS far *outregs);
int cdecl far int86x(int intno, union REGS far *inregs,
			 union REGS far *outregs, struct SREGS far *segregs);
int cdecl far bdos(int dosfun, unsigned dosdx, unsigned dosal);
int cdecl far bdosptr(int dosfun, void far *argument, unsigned dosal);
int cdecl far bioskey(int cmd);
void cdecl far sound(unsigned frequency);
void cdecl far nosound(void);
int cdecl far allocmem(unsigned size, unsigned far *segp);
int cdecl far freemem(unsigned segx);
int cdecl far setblock(unsigned segx, unsigned newsize);
unsigned long cdecl far coreleft(void);
int cdecl far brk(void far *);
void far * cdecl far sbrk(int);
int cdecl far heapcheck(void);
int cdecl far heapcheckfree(unsigned int);
int cdecl far heapchecknode(void far *);
int cdecl far heapfillfree(unsigned int);
int cdecl far heapwalk(void far *);

#ifdef  __cplusplus
}
#endif



/* Microsoft Graphics functions */
/************************************************************************
*  Structures for Microsoft runtime compatability
*************************************************************************/
#ifndef _GRAPH_T_DEFINED

/* structure for _getvideoconfig() as visible to user */
struct videoconfig {
        short numxpixels;       /* number of pixels on X axis */
        short numypixels;       /* number of pixels on Y axis */
        short numtextcols;      /* number of text columns available */
        short numtextrows;      /* number of text rows available */
        short numcolors;        /* number of actual colors */
        short bitsperpixel;     /* number of bits per pixel */
        short numvideopages;    /* number of available video pages */
        short mode;             /* current video mode */
        short adapter;          /* active display adapter */
        short monitor;          /* active display monitor */
        short memory;           /* adapter video memory in K bytes */
};

/* return value of _setlogorg(), etc. */
struct xycoord {
        short xcoord;
        short ycoord;
};

/* structure for text position */
struct rccoord {
        short row;
        short col;
};

/* Information on the current font */
struct _fontinfo {
	int type;
	int ascent;
	int pixwidth;
	int pixheight;
	int avgwidth;
	char filename[80];
	char facename[32];
};

#define _GRAPH_T_DEFINED

#endif


/* SETUP AND CONFIGURATION */


/* arguments to _setvideomode() */
#define _DEFAULTMODE    -1      /* restore screen to original mode */
#define _TEXTBW40       0       /* 40 x 25 text, 16 grey */
#define _TEXTC40        1       /* 40 x 25 text, 16/8 color */
#define _TEXTBW80       2       /* 80 x 25 text, 16 grey */
#define _TEXTC80        3       /* 80 x 25 text, 16/8 color */
#define _MRES4COLOR     4       /* 320 x 200, 4 color */
#define _MRESNOCOLOR    5       /* 320 x 200, 4 grey */
#define _HRESBW         6       /* 640 x 200, BW */
#define _TEXTMONO       7       /* 80 x 25 text, BW */
#define _HERCMONO       8       /* 720 x 348, BW for HGC */
#define _MRES16COLOR    13      /* 320 x 200, 16 color */
#define _HRES16COLOR    14      /* 640 x 200, 16 color */
#define _ERESNOCOLOR    15      /* 640 x 350, BW */
#define _ERESCOLOR      16      /* 640 x 350, 4 or 16 color */
#define _VRES2COLOR     17      /* 640 x 480, BW */
#define _VRES16COLOR    18      /* 640 x 480, 16 color */
#define _MRES256COLOR   19      /* 320 x 200, 256 color */
#define _MAXRESMODE	30	/* Choose maximum resolution */


/* videoconfig adapter values */
/* these manifest constants can be used to determine the type of monitor in */
/* use, using either simple comparisons or the bitwise-AND operator (&) */
#define _MDPA       0x0001      /* Monochrome Display Adapter (MDPA) */
#define _CGA        0x0002      /* Color Graphics Adapter     (CGA)  */
#define _EGA        0x0004      /* Enhanced Graphics Adapter  (EGA)  */
#define _VGA        0x0008      /* Video Graphics Array       (VGA)  */
#define _MCGA       0x0010      /* MultiColor Graphics Array  (MCGA) */
#define _HGC        0x0020      /* Hercules Graphics Card     (HGC)  */

/* videoconfig monitor values */
/* these manifest constants can be used to determine the type of the active */
/* adapter, using either simple comparisons or the bitwise-AND operator (&) */
#define _MONO       0x0001      /* Monochrome */
#define _COLOR      0x0002      /* Color (or Enhanced emulating color) */
#define _ENHCOLOR   0x0004      /* Enhanced Color */
#define _ANALOG     0x0018      /* Analog */


/* ERROR VALUES */
#define _GROK			0
#define _GRERROR		(-1)
#define _GRMODENOTSUPPORTED	(-2)
#define _GRNOTINPROPERMODE	(-3)
#define _GRINVALIDPARAMETER	(-4)
#define _GRFONTFILENOTFOUND	(-5)
#define _GRINVALIDFONTFILE	(-6)
#define _GRCORRUPTEDFONTFILE	(-7)
#define _GRINSUFFICIENTMEMORY	(-8)
#define _GRINVALIDIMAGEBUFFER	(-9)
/* Warnings */
#define _GRNOOUTPUT		1
#define _GRCLIPPED		2
#define _GRPARAMETERALTERED	3

/* COORDINATE SYSTEMS */


/* OUTPUT ROUTINES */

/* control parameters for Rectangle, Ellipse and Pie */
#define _GBORDER        2       /* draw outline only */
#define _GFILLINTERIOR  3       /* fill using current fill mask */

#define _GCLEARSCREEN 0
#define _GVIEWPORT    1
#define _GWINDOW      2


/* PEN COLOR, LINE STYLE, FILL PATTERN */


/* TEXT */
#define _GCURSOROFF 0
#define _GCURSORON  1

#define _GWRAPOFF   0
#define _GWRAPON    1


/* SCREEN IMAGES */

/* "action verbs" for _putimage() */
#define _GPSET          3
#define _GPRESET        2
#define _GAND           1
#define _GOR            0
#define _GXOR           4

/* universal color values: */
#define _BLACK          0x000000L
#define _BLUE           0x2a0000L
#define _GREEN          0x002a00L
#define _CYAN           0x2a2a00L
#define _RED            0x00002aL
#define _MAGENTA        0x2a002aL
#define _BROWN          0x00152aL
#define _WHITE          0x2a2a2aL
#define _GRAY           0x151515L
#define _LIGHTBLUE      0x3F1515L
#define _LIGHTGREEN     0x153f15L
#define _LIGHTCYAN      0x3f3f15L
#define _LIGHTRED       0x15153fL
#define _LIGHTMAGENTA   0x3f153fL
#define _LIGHTYELLOW    0x153f3fL
#define _BRIGHTWHITE    0x3f3f3fL

/* mono mode F color values: */
#define _MODEFOFF       0L
#define _MODEFOFFTOON   1L
#define _MODEFOFFTOHI   2L
#define _MODEFONTOOFF   3L
#define _MODEFON        4L
#define _MODEFONTOHI    5L
#define _MODEFHITOOFF   6L
#define _MODEFHITOON    7L
#define _MODEFHI        8L

/* mono mode 7 color values: */
#define _MODE7OFF       0L
#define _MODE7ON        1L
#define _MODE7HI        2L



#define _MAXTEXTROWS	999


#ifdef __cplusplus
extern "C" {
#endif

short far cdecl _setactivepage(short);
short far cdecl _setvisualpage(short);
short far cdecl _getvisualpage(void);
short far cdecl _getactivepage(void);
struct videoconfig far * far cdecl _getvideoconfig(struct videoconfig far *);
struct xycoord far cdecl _setvieworg(short, short);
struct xycoord far cdecl _setlogorg(short, short);
struct xycoord far cdecl _getlogcoord(short, short);
struct xycoord far cdecl _getviewcoord(short, short);
struct xycoord far cdecl _getphyscoord(short, short);
short far cdecl _setvideomode(short);
short far cdecl _setvideomoderows(short mode, short rows);

void far cdecl _setcliprgn(short, short, short, short);
void far cdecl _setviewport(short, short, short, short);

void far cdecl _clearscreen(short);

struct xycoord far cdecl _moveto(short, short);
struct xycoord far cdecl _getcurrentposition(void);

short far cdecl _lineto(short, short);
short far cdecl _rectangle(short, short, short, short, short);
short far cdecl _ellipse(short, short, short, short, short);
short far cdecl _arc(short, short, short, short, short, short, short, short);
short far cdecl _pie(short, short, short, short, short, short, short,
				 short, short);
short far cdecl _polygon(short cntrl, struct xycoord far *points,
							 short num_pnts);

short far cdecl _setpixel(short, short);
short far cdecl _getpixel(short, short);
short far cdecl _floodfill(short, short, short);

short far cdecl _setcolor(short);
short far cdecl _getcolor(void);

void far cdecl _setlinestyle(unsigned short);
unsigned short far cdecl _getlinestyle(void);
short far cdecl _getarcinfo(struct xycoord far *start,struct xycoord far *end, 
				struct xycoord far *fillpoint);
short far cdecl _grstatus(void);

void far cdecl _setfillmask(unsigned char far *);
unsigned char far * far cdecl _getfillmask(unsigned char far *);

/* COLOR SELECTION */

long far cdecl _setbkcolor(long);
long far cdecl _getbkcolor(void);

long far cdecl _remappalette(short, long);
short far cdecl _remapallpalette(long far *);
short far cdecl _selectpalette(short);
short far cdecl _settextrows(short);
void far cdecl _settextwindow(short, short, short, short);
void far cdecl _gettextwindow(short far *r1, short far *c1,
			      short far *r2, short far *c2);
void far cdecl _scrolltextwindow(short scroll_lines);
void far cdecl _outtext(char far *);
void far cdecl _outmem(unsigned char far *text, short num_bytes);
short far cdecl _wrapon(short);
short far cdecl _displaycursor(short);

struct rccoord far cdecl _settextposition(short, short);
struct rccoord far cdecl _gettextposition(void);

short far cdecl _settextcolor(short);
short far cdecl _gettextcolor(void);

short far cdecl _settextcursor(short attr);
short far cdecl _gettextcursor(void);


short far cdecl _getwritemode(void);
short far cdecl _setwritemode(short action);

short far cdecl  _setfont(unsigned char far *options);
void far cdecl _outgtext(unsigned char far *text);
struct xycoord far cdecl _setgtextvector(short x, short y);
struct xycoord far cdecl _getgtextvector(void);
short far cdecl _getgtextextent(unsigned char far *text);
short far cdecl  _registerfonts(unsigned char far *);
void far cdecl _unregisterfonts(void);
short far cdecl _getfontinfo(struct _fontinfo far *buffer);



void far cdecl _getimage(short, short, short, short, char far *);
void far cdecl _putimage(short, short, char far *, short);
long far cdecl _imagesize(short, short, short, short);


#ifdef  __cplusplus
}
#endif




/* Terminal IO styles */
#define WDS_SELECT		1L
#define WDS_NOSCROLL		2L
#define WDS_NOPAGES		4L
#define WDS_NOTEXTBUFFER	8L

/* WinDosIO types */
#define WD_INIT			1
#define WD_SETFOCUS		2
#define WD_GET_HDC		4
#define WD_REGISTER_WINDOW	5
#define WD_CREATE_CHILD_WINDOW	6
#define WD_CREATE_MAIN_WINDOW	7
#define WD_SETTITLE		8
#define WD_DEFERPAINT		9
#define WD_DESTROY		11
#define WD_SELECT		12
#define WD_CLOSE		13
#define WD_GETERRNO		14


struct WINDOSIO {
	short wrapWidth;
};


/* WM_COMMAND notification codes */
#define WDN_SETFOCUS	1
#define WDN_KILLFOCUS	2
#define WDN_LBUTTON	3
#define WDN_RBUTTON	4

/* Error codes */
#define WDE_UNINITIALIZED		-1
#define WDE_NO_CURRENT_WINDOW		-2
#define WDE_USERQUIT			-3
#define WDE_TOO_MANY_WINDOWS		-4
#define WDE_HANDLE_OUT_OF_RANGE 	-5
#define WDE_DISK_ERROR			-6
#define WDE_ALREADY_UNGOT		-7
#define WDE_OUT_OF_MEMORY		-8
#define WDE_BAD_LINESIZE		-9
#define WDE_UNKNOWN_WDCODE		-10
#define WDE_NO_MORE_APPLICATIONS	-11
#define WDE_BAD_MODE			-12
#define WDE_BAD_X			-13
#define WDE_BAD_Y			-14
#define WDE_GRAPHICS_NOT_INITIALIZED	-15
#define WDE_BAD_SEGMENT			-16

#endif

