/***************************************************************************
* EXAMPL4.C
* This example creates a non scrollable, cursor addressable window which
* is programmed and looks just like an old fashion menu.
****************************************************************************/

#include <WinDosIO.h>

#define CURUP	72
#define CURDWN	80
#define HOME	71
#define END	79

struct MENU {
    char *entry;
    char *popup;
 } menu[] = {
{"Apples","An apple a day keeps the doctor away"},
{"Oranges","Orange you glad I didn't say banana"},
{"Peanuts","For comic relief"},
{"Kiwi","I don't eat birds or shoe polish"},
{"Cashews", "God bless you"}};

short menuMax = sizeof(menu) / sizeof(struct MENU);
short getkey(void);

struct text_info ti;


main()
 {
	short i;
	short holdLine;

	for (i = 0; i < menuMax; i++)
		printf("%-13.13s[ ]\n",(char far *)menu[i].entry);
	gotoxy(15,1);
	for(;;)
         {
	    short k = getkey();
	    if (k < 0) break;
	    switch (k)
	     {
		   case CURDWN:
			if (wherey() < menuMax) gotoxy(15,wherey()+1);
		        break;
		   case CURUP:
			if (wherey() > 1) gotoxy(15,wherey()-1);
		        break;
		   case HOME:
			gotoxy(15,1);
	 	        break;
		   case END:
			gotoxy(15,menuMax);
		        break;
		   default:
			holdLine = wherey();
			gettextinfo(&ti);
			window(20,10,60,10);
			clrscr();
			printf("%s",(char far *)menu[holdLine-1].popup);
			window(ti.winleft,ti.wintop,ti.winright,ti.winbottom);
			gotoxy(ti.curx,ti.cury);
			break;
		}
	 }
	return 0;
 }

short getkey(void)
 {
	int k = getch();
	if (!k)
  	   return getch();
	return k;
 }



